/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\n\u001a\u00020\u0003H\u0017J\u0013\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "", "owner", "", "repository", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getOwner", "()Ljava/lang/String;", "getRepository", "toString", "showOwner", "", "equals", "other", "hashCode", "", "intellij.vcs.github"})
public final class GHRepositoryPath {
    @NotNull
    private final String owner;
    @NotNull
    private final String repository;

    public GHRepositoryPath(@NotNull String owner, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.owner = owner;
        this.repository = repository;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getRepository() {
        return this.repository;
    }

    @NotNull
    public final String toString(boolean showOwner) {
        return showOwner ? this.owner + "/" + this.repository : this.repository;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.owner + "/" + this.repository;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHRepositoryPath)) {
            return false;
        }
        if (!StringsKt.equals((String)this.owner, (String)((GHRepositoryPath)other).owner, (boolean)true)) {
            return false;
        }
        return StringsKt.equals((String)this.repository, (String)((GHRepositoryPath)other).repository, (boolean)true);
    }

    public int hashCode() {
        int result = StringUtil.stringHashCodeInsensitive((CharSequence)this.owner);
        result = 31 * result + StringUtil.stringHashCodeInsensitive((CharSequence)this.repository);
        return result;
    }
}

