/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.beans.PropertyChangeSupport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.options.DefaultImageEditorSettings;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.impl.ImageEditorColorSchemeSettingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/images/options/impl/GridOptionsImpl;", "Lorg/intellij/images/options/GridOptions;", "propertyChangeSupport", "Ljava/beans/PropertyChangeSupport;", "<init>", "(Ljava/beans/PropertyChangeSupport;)V", "showDefault", "", "lineMinZoomFactor", "", "lineSpan", "lineColor", "Ljava/awt/Color;", "isShowDefault", "getLineZoomFactor", "getLineSpan", "getLineColor", "setLineMinZoomFactor", "", "setLineSpan", "inject", "options", "setOption", "name", "", "value", "", "intellij.platform.images"})
public final class GridOptionsImpl
implements GridOptions {
    @NotNull
    private final PropertyChangeSupport propertyChangeSupport;
    private boolean showDefault;
    private int lineMinZoomFactor;
    private int lineSpan;
    @Nullable
    private Color lineColor;

    public GridOptionsImpl(@NotNull PropertyChangeSupport propertyChangeSupport) {
        Intrinsics.checkNotNullParameter((Object)propertyChangeSupport, (String)"propertyChangeSupport");
        this.propertyChangeSupport = propertyChangeSupport;
        this.showDefault = DefaultImageEditorSettings.INSTANCE.getShowGrid();
        this.lineMinZoomFactor = DefaultImageEditorSettings.INSTANCE.getShowGridWhenZoomEqualOrMoreThan();
        this.lineSpan = DefaultImageEditorSettings.INSTANCE.getShowGridAfterEveryXPixels();
    }

    @Override
    public boolean isShowDefault() {
        return this.showDefault;
    }

    @Override
    public int getLineZoomFactor() {
        return this.lineMinZoomFactor;
    }

    @Override
    public int getLineSpan() {
        return this.lineSpan;
    }

    @Override
    @NotNull
    public Color getLineColor() {
        Color color = this.lineColor;
        if (color == null && (color = EditorColorsManager.getInstance().getGlobalScheme().getColor(ImageEditorColorSchemeSettingsKt.getGRID_LINE_COLOR_KEY())) == null) {
            JBColor jBColor = JBColor.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"DARK_GRAY");
            color = (Color)jBColor;
        }
        return color;
    }

    private final void setLineMinZoomFactor(int lineMinZoomFactor) {
        int oldValue = this.lineMinZoomFactor;
        if (oldValue != lineMinZoomFactor) {
            this.lineMinZoomFactor = lineMinZoomFactor;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineZoomFactor", oldValue, this.lineMinZoomFactor);
        }
    }

    private final void setLineSpan(int lineSpan) {
        int oldValue = this.lineSpan;
        if (oldValue != lineSpan) {
            this.lineSpan = lineSpan;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineSpan", oldValue, this.lineSpan);
        }
    }

    @Override
    public void inject(@NotNull GridOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.showDefault = options.isShowDefault();
        this.setLineMinZoomFactor(options.getLineZoomFactor());
        this.setLineSpan(options.getLineSpan());
    }

    @Override
    public boolean setOption(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)"Editor.Grid.showDefault", (Object)name)) {
            this.showDefault = (Boolean)value;
        } else if (Intrinsics.areEqual((Object)"Editor.Grid.lineZoomFactor", (Object)name)) {
            this.setLineMinZoomFactor((Integer)value);
        } else if (Intrinsics.areEqual((Object)"Editor.Grid.lineSpan", (Object)name)) {
            this.setLineSpan((Integer)value);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

