/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirSuspendModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSuspendModifierChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirSuspendModifierChecker INSTANCE = new FirSuspendModifierChecker();

    private FirSuspendModifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(typeRef instanceof FirTypeRefWithNullability)) {
            return;
        }
        FirElement firElement = typeRef;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"SUSPEND_KEYWORD");
        FirModifier<?> firModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
        if (firModifier == null) {
            return;
        }
        FirModifier<?> suspendModifier = firModifier;
        if (!(typeRef instanceof FirFunctionTypeRef) || ((FirFunctionTypeRef)typeRef).isMarkedNullable()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)suspendModifier.getSource()), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)suspendModifier.getToken(), (Object)"non-functional type", (DiagnosticContext)context2, null, (int)32, null);
        }
    }
}

