/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationInfoProvider;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationInfoProvider;", "sinceVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "computeDeprecationInfo", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "providers"})
@SourceDebugExtension(value={"SMAP\ndeprecationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,486:1\n228#2:487\n*S KotlinDebug\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider\n*L\n423#1:487\n*E\n"})
public final class SinceKotlinProvider
extends DeprecationInfoProvider {
    @NotNull
    private final ApiVersion sinceVersion;

    public SinceKotlinProvider(@NotNull ApiVersion sinceVersion) {
        Intrinsics.checkNotNullParameter((Object)sinceVersion, (String)"sinceVersion");
        this.sinceVersion = sinceVersion;
    }

    @Override
    @Nullable
    public FirDeprecationInfo computeDeprecationInfo(@NotNull LanguageVersionSettings languageVersionSettings) {
        FutureApiDeprecationInfo futureApiDeprecationInfo;
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        boolean condition$iv = this.sinceVersion.compareTo(languageVersionSettings.getApiVersion()) <= 0;
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            futureApiDeprecationInfo = null;
        } else {
            boolean bl = false;
            futureApiDeprecationInfo = new FutureApiDeprecationInfo(DeprecationLevelValue.HIDDEN, true, this.sinceVersion);
        }
        return futureApiDeprecationInfo;
    }
}

