/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.ModuleEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0015\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker$CompoundKey;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fqNames", "", "", "getFqNames", "()Ljava/util/Set;", "javaClassLookup", "getJavaClassLookup", "()Z", "aliasLookup", "getAliasLookup", "kotlinFullClassLookup", "getKotlinFullClassLookup", "get", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "subscribe", "", "checkKeyValidity", "key", "calculate", "(Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker$CompoundKey;)Ljava/lang/Boolean;", "CompoundKey", "ModelChangeListener", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nFrameworkAvailabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkAvailabilityChecker.kt\norg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1755#2,3:77\n*S KotlinDebug\n*F\n+ 1 FrameworkAvailabilityChecker.kt\norg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker\n*L\n45#1:77,3\n*E\n"})
public abstract class FrameworkAvailabilityChecker
extends SynchronizedFineGrainedEntityCache<CompoundKey, Boolean> {
    public FrameworkAvailabilityChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false, false, 4, null);
    }

    @NotNull
    protected abstract Set<String> getFqNames();

    protected abstract boolean getJavaClassLookup();

    protected abstract boolean getAliasLookup();

    protected abstract boolean getKotlinFullClassLookup();

    public final boolean get(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (Boolean)this.get(new CompoundKey(module, includeTests));
    }

    @Override
    protected void subscribe() {
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener(this.getProject()));
    }

    @Override
    protected void checkKeyValidity(@NotNull CompoundKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Module module = key.getModule();
        if (module.isDisposed()) {
            throw new IllegalStateException("Module " + module.getName() + " is already disposed");
        }
    }

    @Override
    @NotNull
    public Boolean calculate(@NotNull CompoundKey key) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            GlobalSearchScope globalSearchScope = key.getModule().getModuleWithDependenciesAndLibrariesScope(key.getIncludeTests());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleWithDependenciesAndLibrariesScope(...)");
            GlobalSearchScope moduleScope = globalSearchScope;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.getProject());
            Iterable $this$any$iv = this.getFqNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String fqName2 = (String)element$iv;
                    boolean bl2 = false;
                    if (!(this.getJavaClassLookup() && javaPsiFacade.findClass(fqName2, moduleScope) != null || this.getAliasLookup() && !KotlinTopLevelTypeAliasFqNameIndex.Helper.get(fqName2, this.getProject(), moduleScope).isEmpty() || this.getKotlinFullClassLookup() && !KotlinFullClassNameIndex.Helper.get(fqName2, this.getProject(), moduleScope).isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker$CompoundKey;", "", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "<init>", "(Lcom/intellij/openapi/module/Module;Z)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getIncludeTests", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.base.code-insight"})
    public static final class CompoundKey {
        @NotNull
        private final Module module;
        private final boolean includeTests;

        public CompoundKey(@NotNull Module module, boolean includeTests) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.includeTests = includeTests;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        public final boolean getIncludeTests() {
            return this.includeTests;
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        public final boolean component2() {
            return this.includeTests;
        }

        @NotNull
        public final CompoundKey copy(@NotNull Module module, boolean includeTests) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new CompoundKey(module, includeTests);
        }

        public static /* synthetic */ CompoundKey copy$default(CompoundKey compoundKey, Module module, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                module = compoundKey.module;
            }
            if ((n & 2) != 0) {
                bl = compoundKey.includeTests;
            }
            return compoundKey.copy(module, bl);
        }

        @NotNull
        public String toString() {
            return "CompoundKey(module=" + this.module + ", includeTests=" + this.includeTests + ")";
        }

        public int hashCode() {
            int result2 = this.module.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.includeTests);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompoundKey)) {
                return false;
            }
            CompoundKey compoundKey = (CompoundKey)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)compoundKey.module)) {
                return false;
            }
            return this.includeTests == compoundKey.includeTests;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker$ModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ModuleEntityChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/codeInsight/FrameworkAvailabilityChecker;Lcom/intellij/openapi/project/Project;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/module/Module;", "kotlin.base.code-insight"})
    private final class ModelChangeListener
    extends ModuleEntityChangeListener {
        public ModelChangeListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, false, 2, null);
        }

        @Override
        protected void entitiesChanged(@NotNull List<? extends Module> outdated2) {
            Intrinsics.checkNotNullParameter(outdated2, (String)"outdated");
            Class<?> checkerClass = FrameworkAvailabilityChecker.this.getClass();
            FrameworkAvailabilityChecker frameworkAvailabilityChecker = (FrameworkAvailabilityChecker)this.getProject().getService(checkerClass);
            if (frameworkAvailabilityChecker == null) {
                throw new IllegalStateException(("Cannot find service " + checkerClass).toString());
            }
            FrameworkAvailabilityChecker service2 = frameworkAvailabilityChecker;
            FineGrainedEntityCache.invalidateEntries$default(service2, (arg_0, arg_1) -> ModelChangeListener.entitiesChanged$lambda$0(outdated2, arg_0, arg_1), null, 2, null);
        }

        private static final boolean entitiesChanged$lambda$0(List $outdated, CompoundKey key, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $outdated.contains(key.getModule());
        }
    }
}

