/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.PoweredLibraryScopeBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibrarySourceScope;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/scope/PoweredLibraryScopeBase;", "project", "Lcom/intellij/openapi/project/Project;", "topPackageNames", "", "", "entriesVirtualFileSystems", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Lcom/intellij/openapi/roots/libraries/Library;)V", "getFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "equals", "", "other", "", "calcHashCode", "", "toString", "kotlin.base.project-structure"})
final class LibrarySourceScope
extends PoweredLibraryScopeBase {
    @NotNull
    private final Library library;

    public LibrarySourceScope(@NotNull Project project, @Nullable Set<String> topPackageNames, @Nullable Set<? extends NewVirtualFileSystem> entriesVirtualFileSystems, @NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        super(project, VirtualFile.EMPTY_ARRAY, virtualFileArray, topPackageNames, entriesVirtualFileSystems);
        this.library = library;
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myIndex.getSourceRootForFile(file);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LibrarySourceScope && Intrinsics.areEqual((Object)this.library, (Object)((LibrarySourceScope)((Object)other)).library);
    }

    public int calcHashCode() {
        return this.library.hashCode();
    }

    @NotNull
    public String toString() {
        return "LibrarySourceScope(" + this.library + ")";
    }
}

