/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.StartupUiUtil;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.RunBlockingProblemDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.TraceElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspectionPresentation;", "Lcom/intellij/codeInspection/ui/DefaultInspectionToolPresentation;", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "context", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "<init>", "(Lcom/intellij/codeInspection/ex/InspectionToolWrapper;Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;)V", "getCustomPreviewPanel", "Ljavax/swing/JComponent;", "descriptor", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "parent", "Lcom/intellij/openapi/Disposable;", "getDescription", "", "callStack", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/TraceElement;", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRunBlockingInspectionPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunBlockingInspectionPresentation.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspectionPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1863#2,2:67\n*S KotlinDebug\n*F\n+ 1 RunBlockingInspectionPresentation.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/RunBlockingInspectionPresentation\n*L\n62#1:67,2\n*E\n"})
public final class RunBlockingInspectionPresentation
extends DefaultInspectionToolPresentation {
    public RunBlockingInspectionPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull GlobalInspectionContextImpl context2) {
        Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(toolWrapper, context2);
    }

    @Nullable
    public JComponent getCustomPreviewPanel(@NotNull CommonProblemDescriptor descriptor2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (descriptor2 instanceof RunBlockingProblemDescriptor) {
            DescriptionEditorPane htmlView = new DescriptionEditorPane();
            EditorKit editorKit = htmlView.getEditorKit();
            Intrinsics.checkNotNull((Object)editorKit, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLEditorKit");
            StyleSheet css = ((HTMLEditorKit)editorKit).getStyleSheet();
            css.addRule("p.problem-description-group {text-indent: " + JBUIScale.scale((int)9) + "px;font-weight:bold;}");
            css.addRule("div.problem-description {margin-left: " + JBUIScale.scale((int)9) + "px;}");
            css.addRule("ul {margin-left:" + JBUIScale.scale((int)10) + "px;text-indent: 0}");
            css.addRule("code {font-family:" + StartupUiUtil.getLabelFont().getFamily() + "}");
            htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(this){
                final /* synthetic */ RunBlockingInspectionPresentation this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    String fileURL;
                    String ref;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    URL uRL = e.getURL();
                    if (uRL == null) {
                        return;
                    }
                    URL url = uRL;
                    String string = ref = url.getRef();
                    Intrinsics.checkNotNull((Object)string);
                    int offset = Integer.parseInt(string);
                    String string2 = fileURL = url.toExternalForm();
                    Intrinsics.checkNotNull((Object)string2);
                    int n = 0;
                    String string3 = fileURL;
                    Intrinsics.checkNotNull((Object)string3);
                    int n2 = StringsKt.indexOf$default((CharSequence)string3, (char)'#', (int)0, (boolean)false, (int)6, null);
                    String string4 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    fileURL = string4;
                    VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                    if (vFile == null) {
                        vFile = VfsUtil.findFileByURL((URL)url);
                    }
                    if (vFile != null) {
                        Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.this$0.getProject(), vFile, offset);
                        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
                        Navigatable currentDescriptor = navigatable;
                        currentDescriptor.navigate(true);
                    }
                }
            });
            DescriptionEditorPaneKt.readHTML((JEditorPane)((JEditorPane)htmlView), (String)this.getDescription(((RunBlockingProblemDescriptor)descriptor2).getTrace()));
            return (JComponent)htmlView;
        }
        return null;
    }

    private final String getDescription(List<TraceElement> callStack) {
        StringBuilder stringBuilder;
        StringBuilder $this$getDescription_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u241.append("<div class=\"problem-description\"><h>" + KotlinBundle.message((String)"inspection.runblocking.presentation.text", (Object[])new Object[0]) + "</h><p><ul>");
        Iterable $this$forEach$iv = callStack;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceElement it = (TraceElement)element$iv;
            boolean bl2 = false;
            $this$getDescription_u24lambda_u241.append("<li><a HREF=" + it.getUrl() + ">" + it.getFqName() + " (" + it.getFileAndLine() + ")</a></li>");
        }
        $this$getDescription_u24lambda_u241.append("</ul></p></div>");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

