/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\nH\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\nH\u0002J!\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\u0019\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/SimplifyBooleanWithConstantsUtils;", "", "<init>", "()V", "topBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "performSimplification", "", "element", "toSimplifiedExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "simplifyExpression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "canBeReducedToTrue", "canBeReducedToFalse", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "removeRedundantAssertion", "areThereExpressionsToBeSimplified", "hasBooleanType", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nSimplifyBooleanWithConstantsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyBooleanWithConstantsUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/SimplifyBooleanWithConstantsUtils\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n26#2,7:159\n22#2:166\n22#2:167\n26#2,7:168\n28#3,2:175\n28#3,2:191\n28#3,2:207\n36#4,13:177\n36#4,13:193\n36#4,13:209\n154#5:190\n1#6:206\n*S KotlinDebug\n*F\n+ 1 SimplifyBooleanWithConstantsUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/SimplifyBooleanWithConstantsUtils\n*L\n24#1:159,7\n55#1:166\n80#1:167\n83#1:168,7\n112#1:175,2\n120#1:191,2\n153#1:207,2\n112#1:177,13\n120#1:193,13\n153#1:209,13\n119#1:190\n*E\n"})
public final class SimplifyBooleanWithConstantsUtils {
    @NotNull
    public static final SimplifyBooleanWithConstantsUtils INSTANCE = new SimplifyBooleanWithConstantsUtils();

    private SimplifyBooleanWithConstantsUtils() {
    }

    private final KtBinaryExpression topBinary(KtBinaryExpression $this$topBinary) {
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$topBinary)), SimplifyBooleanWithConstantsUtils::topBinary$lambda$0));
        KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
        if (ktBinaryExpression == null) {
            ktBinaryExpression = $this$topBinary;
        }
        return ktBinaryExpression;
    }

    /*
     * WARNING - void declaration
     */
    public final void performSimplification(@NotNull KtBinaryExpression element) {
        PsiElement psiElement;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtBinaryExpression topBinary = this.topBinary(element);
        KtExpression simplified = this.toSimplifiedExpression((KtExpression)topBinary);
        PsiElement psiElement2 = (PsiElement)topBinary;
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)simplified, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
        PsiElement newElement$iv = (PsiElement)ktExpression;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression2;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replaced(...)");
        KtExpression result2 = (KtExpression)psiElement;
        this.removeRedundantAssertion(result2);
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression) {
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (this.canBeReducedToTrue(expression)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression)) {
            return psiFactory.createExpression("false");
        }
        if (expression instanceof KtParenthesizedExpression) {
            KtExpression expr = ((KtParenthesizedExpression)expression).getExpression();
            if (expr != null) {
                KtExpression ktExpression;
                KtExpression simplified = this.toSimplifiedExpression(expr);
                if (simplified instanceof KtBinaryExpression) {
                    Object[] objectArray = new Object[]{simplified};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"($0)", (Object[])objectArray, (boolean)false, (int)4, null);
                } else {
                    ktExpression = simplified;
                }
                return ktExpression;
            }
        } else if (expression instanceof KtBinaryExpression) {
            if (!this.areThereExpressionsToBeSimplified(expression)) {
                PsiElement $this$copied$iv = (PsiElement)expression;
                boolean $i$f$copied = false;
                PsiElement psiElement = $this$copied$iv.copy();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                return (KtExpression)((PsiElement)((KtBinaryExpression)psiElement));
            }
            KtExpression left = ((KtBinaryExpression)expression).getLeft();
            KtExpression right = ((KtBinaryExpression)expression).getRight();
            IElementType iElementType = ((KtBinaryExpression)expression).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            IElementType op = iElementType;
            if (left != null && right != null && (Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left);
                KtExpression simpleRight = this.simplifyExpression(right);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, op);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, op);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, op);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, op);
                } else {
                    String opText = ((KtBinaryExpression)expression).getOperationReference().getText();
                    Object[] objectArray = new Object[]{simpleLeft, simpleRight};
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0 " + opText + " $1"), (Object[])objectArray, (boolean)false, (int)4, null);
                }
                return ktExpression;
            }
        }
        PsiElement $this$copied$iv = (PsiElement)expression;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        return (KtExpression)((PsiElement)((KtExpression)psiElement));
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression) {
        PsiElement psiElement;
        void $this$replaced$iv;
        PsiElement psiElement2 = (PsiElement)expression;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression);
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression;
            }
        }
        return (KtExpression)psiElement;
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation) {
        Project project = otherOperand.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        IElementType iElementType = operation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            if (constantOperand) {
                return psiFactory.createExpression("true");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            if (!constantOperand) {
                return psiFactory.createExpression("false");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            KtExpression ktExpression;
            KtExpression it = this.toSimplifiedExpression(otherOperand);
            boolean bl = false;
            if (constantOperand == Intrinsics.areEqual((Object)operation, (Object)KtTokens.EQEQ)) {
                ktExpression = it;
            } else {
                Object[] objectArray = new Object[]{it};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"!$0", (Object[])objectArray, (boolean)false, (int)4, null);
            }
            return ktExpression;
        }
        return this.toSimplifiedExpression(otherOperand);
    }

    private final boolean canBeReducedToTrue(KtExpression $this$canBeReducedToTrue) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToTrue, true);
    }

    private final boolean canBeReducedToFalse(KtExpression $this$canBeReducedToFalse) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToFalse, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean canBeReducedToBooleanConstant(KtExpression expression, Boolean constant) {
        boolean bl;
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)expression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$canBeReducedToBooleanConstant_u24lambda_u242 = analysisSession$iv$iv;
                boolean bl4 = false;
                KaConstantValue kaConstantValue = $this$canBeReducedToBooleanConstant_u24lambda_u242.evaluate(expression);
                Object value = kaConstantValue != null ? kaConstantValue.getValue() : null;
                bl2 = Intrinsics.areEqual((Object)value, (Object)constant);
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
        }
        return bl;
    }

    static /* synthetic */ boolean canBeReducedToBooleanConstant$default(SimplifyBooleanWithConstantsUtils simplifyBooleanWithConstantsUtils, KtExpression ktExpression, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return simplifyBooleanWithConstantsUtils.canBeReducedToBooleanConstant(ktExpression, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeRedundantAssertion(@NotNull KtExpression expression) {
        String string;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getNonStrictParentOfType22 = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)callExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider $i$f$getNonStrictParentOfType22 = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        try {
            String string2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                String string3;
                KaLifetimeOwner kaLifetimeOwner;
                block11: {
                    boolean bl = false;
                    KaSession $this$removeRedundantAssertion_u24lambda_u244 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    KaCallInfo kaCallInfo = $this$removeRedundantAssertion_u24lambda_u244.resolveToCall((KtElement)callExpression);
                    kaLifetimeOwner = kaCallInfo;
                    if (kaCallInfo == null) return;
                    if ((kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull(kaLifetimeOwner)) != null) break block11;
                    return;
                }
                KaLifetimeOwner kaLifetimeOwner2 = kaLifetimeOwner;
                CallableId callableId = ((KaCallableSymbol)KaCallKt.getSymbol((KaCallableMemberCall)kaLifetimeOwner2)).getCallableId();
                if (callableId != null) {
                    CallableId it = callableId;
                    boolean bl = false;
                    string3 = it.getPackageName().asString() + "." + it.getCallableName().asString();
                } else {
                    string3 = null;
                }
                string2 = string3;
            }
            string = string2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        }
        String fqName2 = string;
        List list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        List valueArguments = list2;
        if (!Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.assert")) return;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)valueArguments);
        if (!KotlinPsiUtilsKt.isTrueConstant((KtExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null))) return;
        boolean bl = true;
        boolean isRedundant = bl;
        if (!isRedundant) return;
        callExpression.delete();
    }

    public final boolean areThereExpressionsToBeSimplified(@Nullable KtExpression element) {
        block9: {
            block11: {
                boolean bl;
                KtExpression p0;
                block10: {
                    boolean bl2;
                    if (element == null) {
                        return false;
                    }
                    KtExpression ktExpression = element;
                    if (ktExpression instanceof KtParenthesizedExpression) {
                        return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element).getExpression());
                    }
                    if (!(ktExpression instanceof KtBinaryExpression)) break block9;
                    IElementType iElementType = ((KtBinaryExpression)element).getOperationToken();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
                    IElementType op = iElementType;
                    if (!Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) && !Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) && !Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) && !Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ)) break block9;
                    if (!this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element).getLeft())) break block10;
                    KtExpression ktExpression2 = ((KtBinaryExpression)element).getRight();
                    if (ktExpression2 != null) {
                        p0 = ktExpression2;
                        boolean $i$f$areThereExpressionsToBeSimplified$stub_for_inlining = false;
                        boolean bl3 = false;
                        bl2 = this.hasBooleanType(p0);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) break block11;
                }
                if (!this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element).getRight())) break block9;
                KtExpression ktExpression = ((KtBinaryExpression)element).getLeft();
                if (ktExpression != null) {
                    p0 = ktExpression;
                    boolean $i$f$areThereExpressionsToBeSimplified$stub_for_inlining$5 = false;
                    boolean bl4 = false;
                    bl = this.hasBooleanType(p0);
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return SimplifyBooleanWithConstantsUtils.canBeReducedToBooleanConstant$default(this, element, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasBooleanType(KtExpression expression) {
        boolean bl;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)expression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                KaType ktType2;
                boolean bl3 = false;
                KaSession $this$hasBooleanType_u24lambda_u246 = analysisSession$iv$iv;
                boolean bl4 = false;
                KaType kaType = ktType2 = $this$hasBooleanType_u24lambda_u246.getExpressionType(expression);
                bl2 = kaType != null ? $this$hasBooleanType_u24lambda_u246.isBooleanType(kaType) : false;
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
        }
        return bl;
    }

    private static final boolean topBinary$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtBinaryExpression;
    }
}

