/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilsKt;
import org.jetbrains.kotlin.idea.completion.impl.k2.context.FirBasicCompletionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KDocNameReferencePositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinRawPositionContext;
import org.jetbrains.kotlin.idea.util.positionContext.KotlinSimpleNameReferencePositionContext;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012R\u00020\u0010\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker;", "", "basicContext", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/context/FirBasicCompletionContext;", "positionContext", "Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/impl/k2/context/FirBasicCompletionContext;Lorg/jetbrains/kotlin/idea/util/positionContext/KotlinRawPositionContext;)V", "isDefinitelyInvisibleByPsi", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canAccessInternalDeclarationsFromFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isVisible", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "kotlin.completion.impl.k2"})
@SourceDebugExtension(value={"SMAP\nCompletionVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n+ 2 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n*L\n1#1,80:1\n19#2,9:81\n*S KotlinDebug\n*F\n+ 1 CompletionVisibilityChecker.kt\norg/jetbrains/kotlin/idea/completion/checkers/CompletionVisibilityChecker\n*L\n28#1:81,9\n*E\n"})
public final class CompletionVisibilityChecker {
    @NotNull
    private final FirBasicCompletionContext basicContext;
    @NotNull
    private final KotlinRawPositionContext positionContext;

    public CompletionVisibilityChecker(@NotNull FirBasicCompletionContext basicContext, @NotNull KotlinRawPositionContext positionContext) {
        Intrinsics.checkNotNullParameter((Object)basicContext, (String)"basicContext");
        Intrinsics.checkNotNullParameter((Object)positionContext, (String)"positionContext");
        this.basicContext = basicContext;
        this.positionContext = positionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDefinitelyInvisibleByPsi(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String description$iv = "isDefinitelyInvisibleByPsi";
        boolean $i$f$forbidAnalysis = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.getExplicitAnalysisRestriction() != null) {
            boolean bl = false;
            if (this.basicContext.getParameters().getInvocationCount() >= 2) {
                return false;
            }
            if (this.basicContext.getOriginalKtFile() instanceof KtCodeFragment) {
                return false;
            }
            KtFile ktFile2 = declaration.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            KtFile declarationContainingFile = ktFile2;
            if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.basicContext.getOriginalKtFile()) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.basicContext.getFakeKtFile())) {
                return true;
            }
            if (declaration.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
                return !this.canAccessInternalDeclarationsFromFile(declarationContainingFile);
            }
            return false;
        }
        permissionRegistry$iv.setExplicitAnalysisRestriction(new KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction(description$iv));
        try {
            boolean bl = false;
            if (this.basicContext.getParameters().getInvocationCount() >= 2) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.basicContext.getOriginalKtFile() instanceof KtCodeFragment) {
                boolean bl3 = false;
                return bl3;
            }
            KtFile ktFile3 = declaration.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
            KtFile declarationContainingFile = ktFile3;
            if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration)) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.basicContext.getOriginalKtFile()) && !Intrinsics.areEqual((Object)declarationContainingFile, (Object)this.basicContext.getFakeKtFile())) {
                boolean bl4 = true;
                return bl4;
            }
            if (declaration.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
                boolean bl5 = !this.canAccessInternalDeclarationsFromFile(declarationContainingFile);
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            permissionRegistry$iv.setExplicitAnalysisRestriction(null);
        }
    }

    private final boolean canAccessInternalDeclarationsFromFile(KtFile file) {
        if (file.isCompiled()) {
            return false;
        }
        KaModule useSiteModule = this.basicContext.getUseSiteModule();
        KaModule declarationModule = KaModuleProvider.Companion.getModule(this.basicContext.getProject(), (PsiElement)file, useSiteModule);
        return Intrinsics.areEqual((Object)declarationModule, (Object)useSiteModule) || this.basicContext.getUseSiteModule().getDirectFriendDependencies().contains(declarationModule);
    }

    public final boolean isVisible(@NotNull KaSession $context_receiver_0, @NotNull KaDeclarationSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.positionContext instanceof KDocNameReferencePositionContext) {
            return true;
        }
        DeprecationInfo deprecationInfo2 = $context_receiver_0.getDeprecationStatus(symbol);
        if ((deprecationInfo2 != null ? deprecationInfo2.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN) {
            return false;
        }
        if (this.basicContext.getParameters().getInvocationCount() > 1) {
            return true;
        }
        if (symbol instanceof KaClassLikeSymbol) {
            KaDeclarationSymbol kaDeclarationSymbol = symbol;
            KaClassLikeSymbol kaClassLikeSymbol = kaDeclarationSymbol instanceof KaClassLikeSymbol ? (KaClassLikeSymbol)kaDeclarationSymbol : null;
            Object classId = kaClassLikeSymbol != null ? kaClassLikeSymbol.getClassId() : null;
            ClassId classId2 = classId;
            boolean bl = classId2 != null && (classId2 = classId2.asSingleFqName()) != null ? FqNameUtilsKt.isJavaClassNotToBeUsedInKotlin((FqName)classId2) : false;
            if (bl) {
                return false;
            }
        }
        if (this.basicContext.getOriginalKtFile() instanceof KtCodeFragment) {
            return true;
        }
        KotlinRawPositionContext kotlinRawPositionContext = this.positionContext;
        KotlinSimpleNameReferencePositionContext kotlinSimpleNameReferencePositionContext = kotlinRawPositionContext instanceof KotlinSimpleNameReferencePositionContext ? (KotlinSimpleNameReferencePositionContext)kotlinRawPositionContext : null;
        return $context_receiver_0.isVisible(symbol, $context_receiver_0.getSymbol(this.basicContext.getOriginalKtFile()), (KtExpression)(kotlinSimpleNameReferencePositionContext != null ? kotlinSimpleNameReferencePositionContext.getExplicitReceiver() : null), this.positionContext.getPosition());
    }
}

