/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0017B\u0019\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002%\b\u0002\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/RestoreCaret;", "T", "Lcom/intellij/psi/PsiElement;", "", "beforeElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "relativeOffset", "", "beforeElementTextLength", "restoreCaret", "", "afterElement", "defaultOffset", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "element", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "Companion", "kotlin.code-insight.impl-base"})
public final class RestoreCaret<T extends PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Editor editor;
    private final int relativeOffset;
    private final int beforeElementTextLength;

    public RestoreCaret(@NotNull T beforeElement, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter(beforeElement, (String)"beforeElement");
        this.editor = editor;
        this.relativeOffset = Companion.findRelativeOffset((PsiElement)beforeElement, this.editor);
        this.beforeElementTextLength = beforeElement.getTextLength();
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    public final void restoreCaret(@NotNull T afterElement, @Nullable Function1<? super T, Integer> defaultOffset) {
        int offset;
        Intrinsics.checkNotNullParameter(afterElement, (String)"afterElement");
        if (this.editor == null) {
            return;
        }
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(afterElement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document2);
        PsiElement psiElement = pointer.getElement();
        if (psiElement == null) {
            return;
        }
        PsiElement afterElementChanged = psiElement;
        int n = this.relativeOffset != -1 && afterElementChanged.getTextLength() == this.beforeElementTextLength ? PsiUtilsKt.getStartOffset((PsiElement)afterElementChanged) + this.relativeOffset : (offset = defaultOffset != null ? ((Number)defaultOffset.invoke((Object)afterElementChanged)).intValue() : -1);
        if (offset == -1) {
            return;
        }
        if (document2.getTextLength() > offset) {
            this.editor.getCaretModel().moveToOffset(offset);
        }
    }

    public static /* synthetic */ void restoreCaret$default(RestoreCaret restoreCaret, PsiElement psiElement, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        restoreCaret.restoreCaret(psiElement, function1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/core/RestoreCaret$Companion;", "", "<init>", "()V", "findRelativeOffset", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public final int findRelativeOffset(@NotNull PsiElement element, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (editor != null) {
                List list2 = editor.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
                Caret singleCaret = (Caret)CollectionsKt.singleOrNull((List)list2);
                if (singleCaret != null) {
                    int relative;
                    int caretOffset = singleCaret.getOffset();
                    TextRange textRange = element.getTextRange();
                    if (textRange.getStartOffset() <= caretOffset && caretOffset <= textRange.getEndOffset() && (relative = caretOffset - PsiUtilsKt.getStartOffset((PsiElement)element)) >= 0) {
                        return relative;
                    }
                }
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

