/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItemsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0003\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "<init>", "(Lcom/sun/jdi/Location;Ljava/util/List;)V", "getLocation", "()Lcom/sun/jdi/Location;", "getSpilledVariables", "()Ljava/util/List;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "createFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "uniqueId", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "kotlin.jvm-debugger.coroutines"})
public abstract class CoroutineStackFrameItem
extends StackFrameItem {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Location location;
    @NotNull
    private final List<JavaValue> spilledVariables;
    @NotNull
    private final ReadOnlyProperty log$delegate;

    private CoroutineStackFrameItem(Location location, List<? extends JavaValue> spilledVariables) {
        super(location, spilledVariables);
        this.location = location;
        this.spilledVariables = spilledVariables;
        this.log$delegate = ProvidersKt.getLogger();
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final List<JavaValue> getSpilledVariables() {
        return this.spilledVariables;
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        StackFrameProxyImpl stackFrameProxyImpl = CoroutineStackFrameItemsKt.findFirstFrame(debugProcess);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frame = stackFrameProxyImpl;
        XSourcePosition position = CoroutineUtilsKt.findPosition(this.location, debugProcess);
        return (XStackFrame)new CoroutineStackFrame(frame, position, this.spilledVariables, false, this.location);
    }

    @NotNull
    public final String uniqueId() {
        return SafeUtilKt.safeSourceName(this.location) + ":" + SafeUtilKt.safeMethod(this.location) + ":" + SafeUtilKt.safeLineNumber(this.location) + ":" + SafeUtilKt.safeKotlinPreferredLineNumber(this.location);
    }

    public /* synthetic */ CoroutineStackFrameItem(Location location, List spilledVariables, DefaultConstructorMarker $constructor_marker) {
        this(location, spilledVariables);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CoroutineStackFrameItem.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

