/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.ConflictingExtensionPropertyInspection;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0016\u0010\u001e\u001a\u00020\t*\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010 \u001a\u00020\t*\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J+\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010(\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "conflictingSyntheticExtension", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "scopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "isSameAsSynthetic", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "syntheticProperty", "checkGetterBodyIsGetMethodCall", "getter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getMethod", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkSetterBodyIsSetMethodCall", "setter", "setMethod", "isGetMethodCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetMethodCall", "valueParameterName", "Lorg/jetbrains/kotlin/name/Name;", "createFixes", "", "Lcom/intellij/codeInspection/IntentionWrapper;", "property", "conflictingExtension", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;Z)[Lcom/intellij/codeInspection/IntentionWrapper;", "DeleteRedundantExtensionAction", "MarkHiddenAndDeprecatedAction", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConflictingExtensionPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConflictingExtensionPropertyInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ResolutionFacade.kt\norg/jetbrains/kotlin/idea/resolve/ResolutionFacadeKt\n*L\n1#1,255:1\n21#2,2:256\n37#3,2:258\n61#4:260\n61#4:261\n*S KotlinDebug\n*F\n+ 1 ConflictingExtensionPropertyInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection\n*L\n87#1:256,2\n173#1:258,2\n64#1:260\n68#1:261\n*E\n"})
public final class ConflictingExtensionPropertyInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = session.getFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        KtFile file = ktFile2;
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)file);
        return (PsiElementVisitor)VisitorWrappersKt.propertyVisitor(arg_0 -> ConflictingExtensionPropertyInspection.buildVisitor$lambda$0(resolutionFacade, this, isOnTheFly, holder, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final SyntheticJavaPropertyDescriptor conflictingSyntheticExtension(PropertyDescriptor descriptor2, SyntheticScopes scopes) {
        Object v3;
        block2: {
            void $this$firstIsInstanceOrNull$iv;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null || (receiverParameterDescriptor = receiverParameterDescriptor.getType()) == null) {
                return null;
            }
            ReceiverParameterDescriptor extensionReceiverType = receiverParameterDescriptor;
            Collection collection = CollectionsKt.listOf((Object)extensionReceiverType);
            Name name2 = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Iterable iterable = SyntheticScopesKt.collectSyntheticExtensionProperties((SyntheticScopes)scopes, (Collection)collection, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof SyntheticJavaPropertyDescriptor)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    private final boolean isSameAsSynthetic(KtProperty declaration, SyntheticJavaPropertyDescriptor syntheticProperty) {
        KtPropertyAccessor ktPropertyAccessor = declaration.getGetter();
        if (ktPropertyAccessor == null) {
            return false;
        }
        KtPropertyAccessor getter = ktPropertyAccessor;
        KtPropertyAccessor setter = declaration.getSetter();
        if (!this.checkGetterBodyIsGetMethodCall(getter, syntheticProperty.getGetMethod())) {
            return false;
        }
        if (setter != null) {
            FunctionDescriptor functionDescriptor = syntheticProperty.getSetMethod();
            if (functionDescriptor == null) {
                return false;
            }
            FunctionDescriptor setMethod = functionDescriptor;
            if (!this.checkSetterBodyIsSetMethodCall(setter, setMethod)) {
                return false;
            }
        }
        return true;
    }

    private final boolean checkGetterBodyIsGetMethodCall(KtPropertyAccessor getter, FunctionDescriptor getMethod) {
        boolean bl;
        if (getter.hasBlockBody()) {
            Object object = getter.getBodyBlockExpression();
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
                return false;
            }
            Object statement = object;
            KtReturnExpression ktReturnExpression = statement instanceof KtReturnExpression ? (KtReturnExpression)statement : null;
            bl = this.isGetMethodCall((KtExpression)(ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null), getMethod);
        } else {
            bl = this.isGetMethodCall(getter.getBodyExpression(), getMethod);
        }
        return bl;
    }

    private final boolean checkSetterBodyIsSetMethodCall(KtPropertyAccessor setter, FunctionDescriptor setMethod) {
        List list2 = setter.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list2);
        if (ktParameter == null || (ktParameter = ktParameter.getNameAsName()) == null) {
            return false;
        }
        KtParameter valueParameterName = ktParameter;
        if (setter.hasBlockBody()) {
            Object object = setter.getBodyBlockExpression();
            if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
                return false;
            }
            Object statement = object;
            return this.isSetMethodCall((KtExpression)statement, setMethod, (Name)valueParameterName);
        }
        return this.isSetMethodCall(setter.getBodyExpression(), setMethod, (Name)valueParameterName);
    }

    private final boolean isGetMethodCall(KtExpression $this$isGetMethodCall, FunctionDescriptor getMethod) {
        KtExpression receiver2;
        ResolvedCall resolvedCall;
        KtExpression ktExpression = $this$isGetMethodCall;
        boolean bl = ktExpression instanceof KtCallExpression ? (resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)$this$isGetMethodCall, null, 1, null)) != null && ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall) && Intrinsics.areEqual((Object)resolvedCall.getResultingDescriptor().getOriginal(), (Object)getMethod.getOriginal()) : (ktExpression instanceof KtQualifiedExpression ? (receiver2 = ((KtQualifiedExpression)$this$isGetMethodCall).getReceiverExpression()) instanceof KtThisExpression && ((KtThisExpression)receiver2).getLabelQualifier() == null && this.isGetMethodCall(((KtQualifiedExpression)$this$isGetMethodCall).getSelectorExpression(), getMethod) : false);
        return bl;
    }

    private final boolean isSetMethodCall(KtExpression $this$isSetMethodCall, FunctionDescriptor setMethod, Name valueParameterName) {
        KtExpression ktExpression = $this$isSetMethodCall;
        if (ktExpression instanceof KtCallExpression) {
            List list2 = ((KtCallExpression)$this$isSetMethodCall).getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
            KtExpression ktExpression2 = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
            KtSimpleNameExpression ktSimpleNameExpression = ktExpression2 instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression2 : null;
            if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)valueParameterName)) {
                return false;
            }
            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)$this$isSetMethodCall, null, 1, null);
            return resolvedCall != null && ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall) && Intrinsics.areEqual((Object)resolvedCall.getResultingDescriptor().getOriginal(), (Object)setMethod.getOriginal());
        }
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiver2 = ((KtQualifiedExpression)$this$isSetMethodCall).getReceiverExpression();
            return receiver2 instanceof KtThisExpression && ((KtThisExpression)receiver2).getLabelQualifier() == null && this.isSetMethodCall(((KtQualifiedExpression)$this$isSetMethodCall).getSelectorExpression(), setMethod, valueParameterName);
        }
        return false;
    }

    private final IntentionWrapper[] createFixes(KtProperty property, SyntheticJavaPropertyDescriptor conflictingExtension, boolean isOnTheFly) {
        IntentionWrapper[] intentionWrapperArray;
        if (this.isSameAsSynthetic(property, conflictingExtension)) {
            LowPriorityAction lowPriorityAction;
            Object[] objectArray;
            IntentionWrapper fix1 = new IntentionWrapper((IntentionAction)new DeleteRedundantExtensionAction(property));
            if (isOnTheFly) {
                objectArray = new MarkHiddenAndDeprecatedAction(property);
                lowPriorityAction = new LowPriorityAction((MarkHiddenAndDeprecatedAction)objectArray){};
            } else {
                lowPriorityAction = null;
            }
            LowPriorityAction fix22 = lowPriorityAction;
            objectArray = new IntentionWrapper[]{fix1, fix22};
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            intentionWrapperArray = thisCollection$iv.toArray(new IntentionWrapper[0]);
        } else {
            intentionWrapperArray = new IntentionWrapper[]{};
        }
        return intentionWrapperArray;
    }

    private static final Unit buildVisitor$lambda$0(ResolutionFacade resolutionFacade, ConflictingExtensionPropertyInspection this$0, boolean $isOnTheFly, ProblemsHolder $holder, KtProperty property) {
        if (property.getReceiverTypeReference() != null) {
            PsiElement psiElement = property.getNameIdentifier();
            if (psiElement == null) {
                return Unit.INSTANCE;
            }
            PsiElement nameElement = psiElement;
            VariableDescriptor variableDescriptor = ExtendedResolutionApiKt.resolveToDescriptorIfAny$default(property, resolutionFacade, null, 2, null);
            PropertyDescriptor propertyDescriptor = variableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor : null;
            if (propertyDescriptor == null) {
                return Unit.INSTANCE;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            ResolutionFacade $this$frontendService$iv = resolutionFacade;
            boolean $i$f$frontendService = false;
            SyntheticScopes syntheticScopes = $this$frontendService$iv.getFrontendService(SyntheticScopes.class);
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = this$0.conflictingSyntheticExtension(propertyDescriptor2, syntheticScopes);
            if (syntheticJavaPropertyDescriptor == null) {
                return Unit.INSTANCE;
            }
            SyntheticJavaPropertyDescriptor conflictingExtension = syntheticJavaPropertyDescriptor;
            ResolutionFacade $this$frontendService$iv2 = resolutionFacade;
            boolean $i$f$frontendService2 = false;
            if (DeprecationResolver.isHiddenInResolution$default((DeprecationResolver)$this$frontendService$iv2.getFrontendService(DeprecationResolver.class), (DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor2), null, null, (boolean)false, (boolean)false, (int)30, null)) {
                return Unit.INSTANCE;
            }
            IntentionWrapper[] fixes = this$0.createFixes(property, conflictingExtension, $isOnTheFly);
            ProblemDescriptor problemDescriptor = $holder.getManager().createProblemDescriptor(nameElement, KotlinBundle.message((String)"this.property.conflicts.with.synthetic.extension.and.should.be.removed.or.renamed.to.avoid.breaking.code.by.future.changes.in.the.compiler", (Object[])new Object[0]), true, (LocalQuickFix[])fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor problemDescriptor2 = problemDescriptor;
            $holder.registerProblem(problemDescriptor2);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$DeleteRedundantExtensionAction;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nConflictingExtensionPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConflictingExtensionPropertyInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$DeleteRedundantExtensionAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,255:1\n14#2:256\n*S KotlinDebug\n*F\n+ 1 ConflictingExtensionPropertyInspection.kt\norg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$DeleteRedundantExtensionAction\n*L\n181#1:256\n*E\n"})
    private static final class DeleteRedundantExtensionAction
    extends KotlinQuickFixAction<KtProperty> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Logger LOG;

        public DeleteRedundantExtensionAction(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super((PsiElement)property);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"delete.redundant.extension.property", (Object[])new Object[0]);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty declaration = ktProperty;
            FqName fqName2 = ImportsUtils.getImportableFqName(ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)declaration, BodyResolveMode.PARTIAL));
            if (fqName2 != null) {
                String string = KotlinBundle.message((String)"searching.for.imports.to.delete.title", (Object[])new Object[0]);
                ProgressManager.getInstance().run((Task)new Task.Modal(project, declaration, this, string){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ KtProperty $declaration;
                    final /* synthetic */ DeleteRedundantExtensionAction this$0;
                    {
                        this.$project = $project;
                        this.$declaration = $declaration;
                        this.this$0 = $receiver;
                        super($project, $super_call_param$1, true);
                    }

                    public void run(ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        List importsToDelete = (List)ActionsKt.runReadAction(() -> invoke.1.run$lambda$2(this.$project, this.$declaration));
                        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), () -> invoke.1.run$lambda$5(this.$project, this.this$0, importsToDelete, this.$declaration));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final List run$lambda$2(Project $project, KtProperty $declaration) {
                        void $this$filterTo$iv$iv;
                        Iterable $this$mapNotNullTo$iv$iv;
                        Iterable $this$filterIsInstanceTo$iv$iv;
                        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$project);
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
                        GlobalSearchScope searchScope = KotlinSourceFilterScope.Companion.projectSources(globalSearchScope, $project);
                        Query query = ReferencesSearch.search((PsiElement)((PsiElement)$declaration), (SearchScope)((SearchScope)searchScope));
                        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                        Iterable $this$filterIsInstance$iv = (Iterable)query;
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof KtSimpleNameReference)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$mapNotNull = false;
                        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            KtImportDirective it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl = false;
                            KtSimpleNameReference ref = (KtSimpleNameReference)element$iv$iv;
                            boolean bl2 = false;
                            PsiElement $this$getStrictParentOfType$iv = (PsiElement)ref.getExpression();
                            boolean $i$f$getStrictParentOfType = false;
                            if ((KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtImportDirective.class, (boolean)true) == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Iterable $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$mapNotNullTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            KtImportDirective ktImportDirective = (KtImportDirective)element$iv$iv;
                            boolean bl = false;
                            if (!(!ktImportDirective.isAllUnder() && UtilsKt.targetDescriptors$default(ktImportDirective, null, 1, null).size() == 1)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }

                    private static final Unit run$lambda$5$lambda$4(List $importsToDelete, KtProperty $declaration) {
                        Iterable $this$forEach$iv = $importsToDelete;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            KtImportDirective ktImportDirective = (KtImportDirective)element$iv;
                            boolean bl = false;
                            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)ktImportDirective)) continue;
                            try {
                                ktImportDirective.delete();
                            }
                            catch (Exception e) {
                                DeleteRedundantExtensionAction.access$getLOG$cp().error((Throwable)e);
                            }
                        }
                        $declaration.delete();
                        return Unit.INSTANCE;
                    }

                    private static final void run$lambda$5(Project $project, DeleteRedundantExtensionAction this$0, List $importsToDelete, KtProperty $declaration) {
                        ApplicationUtilsKt.executeWriteCommand($project, this$0.getText(), (Function0<Unit>)((Function0)() -> invoke.1.run$lambda$5$lambda$4($importsToDelete, $declaration)));
                    }
                });
            } else {
                ApplicationUtilsKt.executeWriteCommand(project, this.getText(), (Function0<Unit>)((Function0)() -> DeleteRedundantExtensionAction.invoke$lambda$0(declaration)));
            }
        }

        private static final Unit invoke$lambda$0(KtProperty $declaration) {
            $declaration.delete();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Logger access$getLOG$cp() {
            return LOG;
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DeleteRedundantExtensionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$DeleteRedundantExtensionAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConflictingExtensionPropertyInspection$MarkHiddenAndDeprecatedAction;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "addAnnotationWithLineBreak", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "annotationEntry", "kotlin.idea"})
    private static final class MarkHiddenAndDeprecatedAction
    extends KotlinQuickFixAction<KtProperty> {
        public MarkHiddenAndDeprecatedAction(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super((PsiElement)property);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"mark.as.deprecated.level.deprecationlevel.hidden", (Object[])new Object[0]);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty element = ktProperty;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            Name name2 = element.getNameAsName();
            Intrinsics.checkNotNull((Object)name2);
            String name3 = RenderingUtilsKt.render((Name)name2);
            this.addAnnotationWithLineBreak((KtNamedDeclaration)element, factory2.createAnnotationEntry("@Deprecated(\"Is replaced with automatic synthetic extension\", ReplaceWith(\"" + name3 + "\"), level = DeprecationLevel.HIDDEN)"));
        }

        private final KtAnnotationEntry addAnnotationWithLineBreak(KtNamedDeclaration $this$addAnnotationWithLineBreak, KtAnnotationEntry annotationEntry2) {
            KtAnnotationEntry ktAnnotationEntry;
            Project project = $this$addAnnotationWithLineBreak.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiElement newLine = new KtPsiFactory(project, false, 2, null).createNewLine();
            if ($this$addAnnotationWithLineBreak.getModifierList() != null) {
                KtAnnotationEntry ktAnnotationEntry2 = $this$addAnnotationWithLineBreak.addAnnotationEntry(annotationEntry2);
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry2, (String)"addAnnotationEntry(...)");
                KtAnnotationEntry result2 = ktAnnotationEntry2;
                KtModifierList ktModifierList = $this$addAnnotationWithLineBreak.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                ktModifierList.addAfter(newLine, (PsiElement)result2);
                ktAnnotationEntry = result2;
            } else {
                KtAnnotationEntry ktAnnotationEntry3 = $this$addAnnotationWithLineBreak.addAnnotationEntry(annotationEntry2);
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry3, (String)"addAnnotationEntry(...)");
                KtAnnotationEntry result3 = ktAnnotationEntry3;
                $this$addAnnotationWithLineBreak.addAfter(newLine, (PsiElement)$this$addAnnotationWithLineBreak.getModifierList());
                ktAnnotationEntry = result3;
            }
            return ktAnnotationEntry;
        }
    }
}

