/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.VisibilityUtilKt;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004\u001d\u001e\u001f B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0004!\"#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "getFamilyName", "", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lkotlin/Unit;", "invoke", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "Public", "Private", "Protected", "Internal", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Internal;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Private;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Protected;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Public;", "kotlin.code-insight.intentions.k2"})
@SourceDebugExtension(value={"SMAP\nChangeVisibilityModifierIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeVisibilityModifierIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,157:1\n1557#2:158\n1628#2,3:159\n1863#2,2:164\n1251#3,2:162\n*S KotlinDebug\n*F\n+ 1 ChangeVisibilityModifierIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention\n*L\n99#1:158\n99#1:159,3\n149#1:164,2\n124#1:162,2\n*E\n"})
public abstract class ChangeVisibilityModifierIntention
extends KotlinApplicableModCommandAction<KtDeclaration, Unit> {
    @NotNull
    private final KtModifierKeywordToken modifier;

    private ChangeVisibilityModifierIntention(KtModifierKeywordToken modifier) {
        super(Reflection.getOrCreateKotlinClass(KtDeclaration.class));
        this.modifier = modifier;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.modifier.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.modifier.getValue()};
        return KotlinBundle.message((String)"make.0", (Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtDeclaration element) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TextRange textRange;
        TextRange keywordRange;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtDeclaration ktDeclaration = element;
        if (ktDeclaration instanceof KtNamedFunction) {
            PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else if (ktDeclaration instanceof KtProperty) {
            v1 = ((KtProperty)element).getValOrVarKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtPropertyAccessor) {
            v1 = ((KtPropertyAccessor)element).getNamePlaceholder().getTextRange();
        } else if (ktDeclaration instanceof KtClass) {
            PsiElement psiElement = ((KtClass)element).getClassOrInterfaceKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else if (ktDeclaration instanceof KtObjectDeclaration) {
            PsiElement psiElement = ((KtObjectDeclaration)element).getObjectKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else if (ktDeclaration instanceof KtPrimaryConstructor) {
            PsiElement psiElement = ((KtPrimaryConstructor)element).getConstructorKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else if (ktDeclaration instanceof KtSecondaryConstructor) {
            v1 = ((KtSecondaryConstructor)element).getConstructorKeyword().getTextRange();
        } else if (ktDeclaration instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else if (ktDeclaration instanceof KtTypeAlias) {
            PsiElement psiElement = ((KtTypeAlias)element).getTypeAliasKeyword();
            v1 = psiElement != null ? psiElement.getTextRange() : null;
        } else {
            v1 = keywordRange = null;
        }
        if (element instanceof KtPrimaryConstructor) {
            KtParameterList ktParameterList = ((KtPrimaryConstructor)element).getValueParameterList();
            if (ktParameterList != null) {
                KtParameterList it = ktParameterList;
                boolean bl = false;
                textRange = TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)), (int)0);
            } else {
                textRange = null;
            }
        } else {
            textRange = null;
        }
        TextRange withoutKeywordRange = textRange;
        Object object = new TextRange[3];
        KtModifierList ktModifierList = element.getModifierList();
        object[0] = ktModifierList != null ? FixersUtilKt.getRange((PsiElement)((PsiElement)ktModifierList)) : null;
        object[1] = keywordRange;
        object[2] = withoutKeywordRange;
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range2;
            TextRange textRange2 = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TextRangeUtilsKt.relativeTo((TextRange)range2, (PsiElement)element));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
        KtModifierList modifierList;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtModifierList ktModifierList = modifierList = element.getModifierList();
        boolean bl = ktModifierList != null ? ktModifierList.hasModifier(this.modifier) : false;
        if (bl) {
            return false;
        }
        KtPropertyAccessor ktPropertyAccessor = element instanceof KtPropertyAccessor ? (KtPropertyAccessor)element : null;
        return !KtPsiUtil.isLocal((KtDeclaration)(ktPropertyAccessor != null && (ktPropertyAccessor = ktPropertyAccessor.getProperty()) != null ? (KtDeclaration)ktPropertyAccessor : element));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtDeclaration element) {
        KtModifierList modifierList;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaDeclarationSymbol symbol = $context_receiver_0.getSymbol(element);
        Visibility targetVisibility = VisibilityUtilKt.toVisibility(this.modifier);
        if (Intrinsics.areEqual((Object)symbol.getCompilerVisibility(), (Object)targetVisibility)) {
            return null;
        }
        KtModifierList ktModifierList = modifierList = element.getModifierList();
        boolean bl = ktModifierList != null ? ktModifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false;
        if (bl) {
            boolean bl2;
            block12: {
                void $this$any$iv;
                KaCallableSymbol kaCallableSymbol = symbol instanceof KaCallableSymbol ? (KaCallableSymbol)symbol : null;
                if (kaCallableSymbol == null) {
                    return null;
                }
                KaCallableSymbol callableDescriptor = kaCallableSymbol;
                Sequence sequence = SequencesKt.map($context_receiver_0.getAllOverriddenSymbols(callableDescriptor), arg_0 -> ChangeVisibilityModifierIntention.prepareContext$lambda$2(targetVisibility, arg_0));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    if (!(it == null || it > 0)) continue;
                    bl2 = true;
                    break block12;
                }
                bl2 = false;
            }
            if (bl2) {
                return null;
            }
        }
        if (element instanceof KtPropertyAccessor) {
            if (((KtPropertyAccessor)element).isGetter()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)targetVisibility, (Object)Visibilities.Public.INSTANCE)) {
                KtModifierList ktModifierList2 = ((KtPropertyAccessor)element).getModifierList();
                if ((ktModifierList2 != null && (ktModifierList2 = KtPsiUtilKt.visibilityModifierType((KtModifierList)ktModifierList2)) != null ? ktModifierList2.getValue() : null) == null) {
                    return null;
                }
            } else {
                KtProperty ktProperty = ((KtPropertyAccessor)element).getProperty();
                Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
                Visibility propVisibility = $context_receiver_0.getSymbol(ktProperty).getCompilerVisibility();
                if (Intrinsics.areEqual((Object)propVisibility, (Object)targetVisibility)) {
                    return null;
                }
                Integer compare = targetVisibility.compareTo(propVisibility);
                if (compare == null || compare > 0) {
                    return null;
                }
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtDeclaration element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)SetsKt.plus((Set)SetsKt.plus((Set)ExpectActualUtils.actualsForExpected$default(ExpectActualUtils.INSTANCE, element, null, 1, null), (Object)ExpectActualUtils.INSTANCE.expectedDeclarationIfAny(element)), (Object)element));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration declaration = (KtDeclaration)element$iv;
            boolean bl = false;
            Project project = declaration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            VisibilityUtilKt.setVisibility$default((KtModifierListOwner)declaration, this.modifier, false, 2, null);
            if (!(declaration instanceof KtPropertyAccessor)) continue;
            KtModifierList ktModifierList = ((KtPropertyAccessor)declaration).getModifierList();
            if (ktModifierList == null || (ktModifierList = ktModifierList.getNextSibling()) == null) continue;
            ktModifierList.replace(psiFactory.createWhiteSpace());
        }
    }

    private static final Integer prepareContext$lambda$2(Visibility $targetVisibility, KaCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Visibility visibility = it.getCompilerVisibility();
        return visibility != null ? visibility.compareTo($targetVisibility) : null;
    }

    public /* synthetic */ ChangeVisibilityModifierIntention(KtModifierKeywordToken modifier, DefaultConstructorMarker $constructor_marker) {
        this(modifier);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Internal;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention;", "<init>", "()V", "isApplicableByPsi", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.code-insight.intentions.k2"})
    public static final class Internal
    extends ChangeVisibilityModifierIntention {
        public Internal() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"INTERNAL_KEYWORD");
            super(ktModifierKeywordToken, null);
        }

        @Override
        public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return VisibilityUtilKt.canBeInternal((KtModifierListOwner)element) && super.isApplicableByPsi(element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Private;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention;", "<init>", "()V", "isApplicableByPsi", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.code-insight.intentions.k2"})
    public static final class Private
    extends ChangeVisibilityModifierIntention {
        public Private() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"PRIVATE_KEYWORD");
            super(ktModifierKeywordToken, null);
        }

        @Override
        public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return VisibilityUtilKt.canBePrivate((KtModifierListOwner)element) && super.isApplicableByPsi(element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Protected;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention;", "<init>", "()V", "isApplicableByPsi", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.code-insight.intentions.k2"})
    public static final class Protected
    extends ChangeVisibilityModifierIntention {
        public Protected() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"PROTECTED_KEYWORD");
            super(ktModifierKeywordToken, null);
        }

        @Override
        public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return VisibilityUtilKt.canBeProtected((KtModifierListOwner)element) && super.isApplicableByPsi(element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention$Public;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ChangeVisibilityModifierIntention;", "<init>", "()V", "isApplicableByPsi", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin.code-insight.intentions.k2"})
    public static final class Public
    extends ChangeVisibilityModifierIntention {
        public Public() {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"PUBLIC_KEYWORD");
            super(ktModifierKeywordToken, null);
        }

        @Override
        public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return VisibilityUtilKt.canBePublic((KtModifierListOwner)element) && super.isApplicableByPsi(element);
        }
    }
}

