/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.usages;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinCallableDefinitionUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinExplicitReferenceUsage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/usages/KotlinParameterUsage;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/usages/KotlinExplicitReferenceUsage;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "parameterInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "containingCallable", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/usages/KotlinCallableDefinitionUsage;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/usages/KotlinCallableDefinitionUsage;)V", "processReplacedElement", "", "getReplacementText", "", "changeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeInfo;", "kotlin.idea"})
public final class KotlinParameterUsage
extends KotlinExplicitReferenceUsage<KtElement> {
    @NotNull
    private final KotlinParameterInfo parameterInfo;
    @NotNull
    private final KotlinCallableDefinitionUsage<?> containingCallable;

    public KotlinParameterUsage(@NotNull KtElement element, @NotNull KotlinParameterInfo parameterInfo, @NotNull KotlinCallableDefinitionUsage<?> containingCallable) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parameterInfo, (String)"parameterInfo");
        Intrinsics.checkNotNullParameter(containingCallable, (String)"containingCallable");
        super(element);
        this.parameterInfo = parameterInfo;
        this.containingCallable = containingCallable;
    }

    @Override
    protected void processReplacedElement(@NotNull KtElement element) {
        KtQualifiedExpression qualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
        KtElement elementToShorten = Intrinsics.areEqual((Object)(ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null), (Object)element) ? (KtElement)qualifiedExpression : element;
        DelayedRequestsWaitingSetKt.addToShorteningWaitSet(elementToShorten, new ShortenReferences.Options(true, true, false, false, false, false, 60, null));
    }

    @Override
    @NotNull
    public String getReplacementText(@NotNull KotlinChangeInfo changeInfo) {
        Intrinsics.checkNotNullParameter((Object)changeInfo, (String)"changeInfo");
        if (!Intrinsics.areEqual((Object)changeInfo.getReceiverParameterInfo(), (Object)this.parameterInfo)) {
            return this.parameterInfo.getInheritedName(this.containingCallable);
        }
        String newName = changeInfo.getNewName();
        if (KtPsiUtilKt.isIdentifier((String)newName)) {
            return "this@" + newName;
        }
        return "this";
    }
}

