/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "runScratch", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "getScratchFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "Companion", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nScratchFileAutoRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class ScratchFileAutoRunner
implements DocumentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm myAlarm;
    public static final int AUTO_RUN_DELAY_IN_SECONDS = 2;

    public ScratchFileAutoRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (this.project.isDisposed()) {
            return;
        }
        ScratchFile scratchFile = this.getScratchFile(file, this.project);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        if (!scratchFile2.getOptions().isInteractiveMode()) {
            return;
        }
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            this.runScratch(scratchFile2);
        }
    }

    private final void runScratch(ScratchFile scratchFile) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile) && !scratchFile.getOptions().isRepl()) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(() -> ScratchFileAutoRunner.runScratch$lambda$2(scratchFile), 2000, true);
    }

    private final ScratchFile getScratchFile(VirtualFile file, Project project) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        TextEditor editor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        TextEditor textEditor = editor;
        return textEditor != null && (textEditor = KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview(textEditor)) != null ? textEditor.getScratchFile() : null;
    }

    public void dispose() {
    }

    private static final void runScratch$lambda$2(ScratchFile $scratchFile) {
        block3: {
            KtFile ktFile2;
            Object object = $scratchFile.getKtScratchFile();
            if (object == null) break block3;
            KtFile it = ktFile2 = object;
            boolean bl = false;
            object = it.isValid() && !$scratchFile.hasErrors() ? ktFile2 : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                if ($scratchFile.getOptions().isRepl()) {
                    RunScratchFromHereAction.Handler.INSTANCE.doAction($scratchFile);
                } else {
                    RunScratchAction.Handler.INSTANCE.doAction($scratchFile, true);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion;", "", "<init>", "()V", "addListener", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "AUTO_RUN_DELAY_IN_SECONDS", "", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nScratchFileAutoRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,81:1\n31#2,2:82\n*S KotlinDebug\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion\n*L\n29#1:82,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addListener(@NotNull Project project, @NotNull TextEditor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (ScratchUtilsKt.getScratchFile(editor) != null) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<ScratchFileAutoRunner> serviceClass$iv = ScratchFileAutoRunner.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                editor.getEditor().getDocument().addDocumentListener((DocumentListener)object, (Disposable)editor);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

