/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KaCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.codeInsight.compiler.KtCompilerFacilityUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.scripting.definitions.ScriptConfigurationsProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ5\u0010\u000e\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J.\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002JL\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0006\u0010&\u001a\u00020\u000bJ \u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u0006\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "execute", "", "callback", "Lkotlin/Function0;", "executeInBackground", "title", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "indicator", "createFileWithLightClassSupport", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "psiFile", "tryRunCommandLine", "modifiedScratchSourceFile", "reportError", "e", "", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "stop", "compileFileToTempDir", "Ljava/io/File;", "createCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "tempOutDir", "Companion", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKtScratchExecutionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchExecutionSession.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n28#2,2:217\n36#3,13:219\n1557#4:232\n1628#4,3:233\n*S KotlinDebug\n*F\n+ 1 KtScratchExecutionSession.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession\n*L\n159#1:217,2\n159#1:219,13\n207#1:232\n207#1:233,3\n*E\n"})
public final class KtScratchExecutionSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchFile file;
    @NotNull
    private final KtCompilingExecutor executor;
    @Nullable
    private volatile ProgressIndicator backgroundProcessIndicator;
    private static final int TIMEOUT_MS = 30000;

    public KtScratchExecutionSession(@NotNull ScratchFile file, @NotNull KtCompilingExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.file = file;
        this.executor = executor;
    }

    public final void execute(@NotNull Function0<Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        KtFile ktFile2 = this.file.getKtScratchFile();
        if (ktFile2 == null) {
            ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
            return;
        }
        KtFile psiFile = ktFile2;
        List<ScratchExpression> expressions = this.file.getExpressions();
        if (!this.executor.checkForErrors(psiFile, expressions)) {
            return;
        }
        KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ActionsKt.runReadAction(() -> KtScratchExecutionSession.execute$lambda$0(expressions));
        if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
            ScratchExecutor.errorOccurs$default(this.executor, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
            return;
        }
        if (!(result2 instanceof KtScratchSourceFileProcessor.Result.OK)) {
            throw new NoWhenBranchMatchedException();
        }
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
        this.executeInBackground(KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), (Function1<? super ProgressIndicator, Unit>)((Function1)arg_0 -> KtScratchExecutionSession.execute$lambda$1(this, result2, psiFile, callback2, arg_0)));
    }

    private final void executeInBackground(@NlsContexts.ProgressTitle String title, Function1<? super ProgressIndicator, Unit> block) {
        Project project = this.file.getProject();
        new Task.Backgroundable(title, block, project){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $block;
            {
                this.$block = $block;
                super($super_call_param$1, $title, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$block.invoke((Object)indicator);
            }
        }.queue();
    }

    private final KtFile createFileWithLightClassSupport(KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile) {
        return (KtFile)ActionsKt.runReadAction(() -> KtScratchExecutionSession.createFileWithLightClassSupport$lambda$2(psiFile, result2));
    }

    private final void tryRunCommandLine(KtFile modifiedScratchSourceFile, KtFile psiFile, KtScratchSourceFileProcessor.Result.OK result2, Function0<Unit> callback2) {
        boolean bl;
        boolean bl2 = bl = this.backgroundProcessIndicator != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            Project project = this.file.getProject();
            List<ScratchExpression> list2 = this.file.getExpressions();
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            this.runCommandLine(project, modifiedScratchSourceFile, list2, psiFile, result2, progressIndicator, callback2);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.reportError(result2, e, psiFile);
        }
    }

    private final void reportError(KtScratchSourceFileProcessor.Result.OK result2, Throwable e, KtFile psiFile) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), result2.getCode());
        String string = e.getMessage();
        if (string == null) {
            Object[] objectArray = new Object[]{psiFile.getName()};
            string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
        }
        this.executor.errorOccurs(string, e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runCommandLine(Project project, KtFile modifiedScratchSourceFile, List<ScratchExpression> expressions, KtFile psiFile, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback2) {
        File file = (File)DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> KtScratchExecutionSession.runCommandLine$lambda$3(this, modifiedScratchSourceFile, expressions));
        if (file == null) {
            return;
        }
        File tempDir = file;
        try {
            Module module = this.file.getModule();
            String string = result2.getMainClassName();
            String string2 = tempDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = this.createCommandLine(psiFile, module, string, string2);
            TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine commandLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment = environmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
            String commandLinePresentation = commandLine.getCommandPresentation(environment);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), commandLinePresentation);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(environment.createProcess(commandLine, indicator), null, commandLinePresentation);
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
            ProcessOutput executionResult = processOutput;
            if (executionResult.isTimeout()) {
                Object[] objectArray = new Object[]{30000};
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", objectArray), null, false, 6, null);
            } else if (!executionResult.isCancelled()) {
                this.executor.parseOutput(executionResult, expressions);
            }
        }
        finally {
            tempDir.delete();
            callback2.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File compileFileToTempDir(KtFile psiFile, List<ScratchExpression> expressions) {
        Object result2;
        Object object;
        void this_$iv$iv;
        if (!this.executor.checkForErrors(psiFile, expressions)) {
            return null;
        }
        File file = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File tmpDir = file;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + tmpDir.getPath());
        boolean $i$f$analyze = false;
        Project project = ((KtElement)psiFile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)psiFile);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)psiFile);
        try {
            Object object2;
            Object lock$iv$iv;
            Object object3 = lock$iv$iv = new Object();
            synchronized (object3) {
                Object object4;
                boolean bl = false;
                KaSession $this$compileFileToTempDir_u24lambda_u246 = analysisSession$iv$iv;
                boolean bl2 = false;
                CompilerConfiguration $this$compileFileToTempDir_u24lambda_u246_u24lambda_u244 = object4 = new CompilerConfiguration();
                boolean bl3 = false;
                Module containingModule = GenericPsiUtils.getModule((PsiElement)psiFile);
                if (containingModule != null) {
                    $this$compileFileToTempDir_u24lambda_u246_u24lambda_u244.put(CommonConfigurationKeys.MODULE_NAME, (Object)containingModule.getName());
                }
                $this$compileFileToTempDir_u24lambda_u246_u24lambda_u244.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)psiFile));
                CompilerConfiguration configuration2 = object4;
                try {
                    KaCompilerTarget.Jvm compilerTarget = new KaCompilerTarget.Jvm(false, null, 2, null);
                    Function1 allowedErrorFilter = KtScratchExecutionSession::compileFileToTempDir$lambda$6$lambda$5;
                    object4 = KtCompilerFacilityUtils.compileToDirectory($this$compileFileToTempDir_u24lambda_u246, psiFile, configuration2, compilerTarget, (Function1<? super KaDiagnostic, Boolean>)allowedErrorFilter, tmpDir);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ScratchUtilsKt.getLOG().error(e);
                    File file2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 7] lbl43 : MonitorExitStatement: MONITOREXIT : var10_10
                    File file3 = file2;
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)psiFile);
                    return file3;
                }
                object2 = object4;
            }
            object = object2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)psiFile);
        }
        Object object5 = result2 = object;
        if (object5 instanceof KaCompilationResult.Failure) {
            ScratchUtilsKt.getLOG().warn("Errors found on analyzing the scratch file. Compilation aborted");
            return null;
        }
        if (object5 instanceof KaCompilationResult.Success) {
            return tmpDir;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TargetEnvironmentRequest, TargetedCommandLine> createCommandLine(KtFile originalFile, Module module, String mainClassName, String tempOutDir) {
        WslTargetEnvironmentConfiguration wslConfiguration;
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper;
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JavaParameters javaParameters = new JavaParametersBuilder(project).withSdkFrom(module, true).withMainClassName(mainClassName).build();
        javaParameters.getClassPath().add(tempOutDir);
        if (module != null) {
            javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module));
        }
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ScriptConfigurationsProvider scriptConfigurationsProvider = ScriptConfigurationsProvider.Companion.getInstance(project2);
        if (scriptConfigurationsProvider != null && (scriptCompilationConfigurationWrapper = scriptConfigurationsProvider.getScriptConfiguration(originalFile)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper;
            boolean bl = false;
            Iterable iterable = it.getDependenciesClassPath();
            PathsList pathsList = javaParameters.getClassPath();
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void f;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(f.getAbsolutePath());
            }
            pathsList.addAll((List)destination$iv$iv);
        }
        if ((wslTargetEnvironmentConfiguration = (wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk()))) == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(originalFile.getProject())) == null) {
            wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        WslTargetEnvironmentConfiguration request = wslTargetEnvironmentConfiguration;
        return TuplesKt.to((Object)request, (Object)javaParameters.toCommandLine((TargetEnvironmentRequest)request).build());
    }

    private static final KtScratchSourceFileProcessor.Result execute$lambda$0(List $expressions) {
        return new KtScratchSourceFileProcessor().process($expressions);
    }

    private static final Unit execute$lambda$1(KtScratchExecutionSession this$0, KtScratchSourceFileProcessor.Result $result, KtFile $psiFile, Function0 $callback, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this$0.backgroundProcessIndicator = indicator;
        KtFile modifiedScratchSourceFile = this$0.createFileWithLightClassSupport((KtScratchSourceFileProcessor.Result.OK)$result, $psiFile);
        this$0.tryRunCommandLine(modifiedScratchSourceFile, $psiFile, (KtScratchSourceFileProcessor.Result.OK)$result, (Function0<Unit>)$callback);
        return Unit.INSTANCE;
    }

    private static final KtFile createFileWithLightClassSupport$lambda$2(KtFile $psiFile, KtScratchSourceFileProcessor.Result.OK $result) {
        return KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)$psiFile), (boolean)false, (boolean)false, (int)6, null).createPhysicalFile("tmp.kt", $result.getCode());
    }

    private static final File runCommandLine$lambda$3(KtScratchExecutionSession this$0, KtFile $modifiedScratchSourceFile, List $expressions) {
        return this$0.compileFileToTempDir($modifiedScratchSourceFile, $expressions);
    }

    private static final boolean compileFileToTempDir$lambda$6$lambda$5(KaDiagnostic it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "<init>", "()V", "TIMEOUT_MS", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

