/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.output.OutputStylingUtilsKt;
import org.jetbrains.kotlin.idea.scratch.output.PreviewEditorScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0011J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "targetDocument", "Lcom/intellij/openapi/editor/Document;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "blocks", "Ljava/util/NavigableMap;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "computeSourceToPreviewAlignments", "", "Lkotlin/Pair;", "", "getBlock", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "expression", "addBlockToTheEnd", "clear", "", "computeCellLineStart", "scratchExpression", "getBlockAtLine", "line", "OutputBlock", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nPreviewEditorScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,216:1\n1557#2:217\n1628#2,3:218\n1#3:221\n7#4,6:222\n*S KotlinDebug\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager\n*L\n84#1:217\n84#1:218,3\n97#1:222,6\n*E\n"})
public final class PreviewOutputBlocksManager {
    @NotNull
    private final Document targetDocument;
    @NotNull
    private final FoldingModel foldingModel;
    @NotNull
    private final MarkupModel markupModel;
    @NotNull
    private final NavigableMap<ScratchExpression, OutputBlock> blocks;

    public PreviewOutputBlocksManager(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.targetDocument = document;
        FoldingModel foldingModel = editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        this.foldingModel = foldingModel;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        this.markupModel = markupModel;
        this.blocks = new TreeMap(Comparator.comparingInt(arg_0 -> PreviewOutputBlocksManager.blocks$lambda$1(PreviewOutputBlocksManager::blocks$lambda$0, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Integer, Integer>> computeSourceToPreviewAlignments() {
        void $this$mapTo$iv$iv;
        Collection collection = this.blocks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputBlock outputBlock = (OutputBlock)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)it.getSourceExpression().getLineStart(), (Object)it.getLineStart()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ScratchOutputBlock getBlock(@NotNull ScratchExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return (ScratchOutputBlock)this.blocks.get(expression);
    }

    @NotNull
    public final ScratchOutputBlock addBlockToTheEnd(@NotNull ScratchExpression expression) {
        OutputBlock outputBlock;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        OutputBlock it = outputBlock = new OutputBlock(expression);
        boolean bl = false;
        if (this.blocks.putIfAbsent(expression, it) != null) {
            throw new IllegalStateException(("There is already a cell for " + expression + "!").toString());
        }
        return outputBlock;
    }

    public final void clear() {
        this.blocks.clear();
        ActionsKt.runWriteAction(() -> PreviewOutputBlocksManager.clear$lambda$5(this));
    }

    private final int computeCellLineStart(ScratchExpression scratchExpression) {
        Map.Entry<ScratchExpression, OutputBlock> entry = this.blocks.lowerEntry(scratchExpression);
        if (entry == null || (entry = entry.getValue()) == null) {
            return scratchExpression.getLineStart();
        }
        Map.Entry<ScratchExpression, OutputBlock> previous = entry;
        int distanceBetweenSources = scratchExpression.getLineStart() - ((OutputBlock)((Object)previous)).getSourceExpression().getLineEnd();
        int differenceBetweenSourceAndOutputHeight = PreviewEditorScratchOutputHandlerKt.access$getHeight(((OutputBlock)((Object)previous)).getSourceExpression()) - ((OutputBlock)((Object)previous)).getHeight();
        int compensation = Math.max(differenceBetweenSourceAndOutputHeight, 0);
        return ((OutputBlock)((Object)previous)).getLineEnd() + compensation + distanceBetweenSources;
    }

    @Nullable
    public final ScratchOutputBlock getBlockAtLine(int line) {
        Object v2;
        block1: {
            Collection collection = this.blocks.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                OutputBlock it = (OutputBlock)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final int blocks$lambda$0(ScratchExpression it) {
        return it.getLineStart();
    }

    private static final int blocks$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final Unit clear$lambda$5(PreviewOutputBlocksManager this$0) {
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this$0){
            final /* synthetic */ PreviewOutputBlocksManager this$0;
            {
                this.this$0 = previewOutputBlocksManager;
            }

            public final void run() {
                boolean bl = false;
                PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0).setText((CharSequence)"");
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "sourceExpression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;)V", "getSourceExpression", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "outputs", "", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "value", "", "lineStart", "getLineStart", "()I", "lineEnd", "getLineEnd", "height", "getHeight", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "addOutput", "", "output", "printAndSaveOutput", "recalculatePosition", "updateFolding", "isLastCell", "", "()Z", "isOutputSmall", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nPreviewEditorScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1863#2,2:217\n7#3,6:219\n1#4:225\n*S KotlinDebug\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock\n*L\n118#1:217,2\n138#1:219,6\n*E\n"})
    private final class OutputBlock
    implements ScratchOutputBlock {
        @NotNull
        private final ScratchExpression sourceExpression;
        @NotNull
        private final List<ScratchOutput> outputs;
        private int lineStart;
        @Nullable
        private FoldRegion foldRegion;

        public OutputBlock(ScratchExpression sourceExpression) {
            Intrinsics.checkNotNullParameter((Object)sourceExpression, (String)"sourceExpression");
            this.sourceExpression = sourceExpression;
            this.outputs = new ArrayList();
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        @Override
        @NotNull
        public ScratchExpression getSourceExpression() {
            return this.sourceExpression;
        }

        @Override
        public int getLineStart() {
            return this.lineStart;
        }

        @Override
        public int getLineEnd() {
            return this.getLineStart() + PreviewEditorScratchOutputHandlerKt.access$countNewLines(this.outputs);
        }

        public final int getHeight() {
            return this.getLineEnd() - this.getLineStart() + 1;
        }

        @Override
        public void addOutput(@NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.printAndSaveOutput(output);
            Map.Entry entry = PreviewOutputBlocksManager.this.blocks.lowerEntry(this.getSourceExpression());
            if (entry != null && (entry = (OutputBlock)entry.getValue()) != null) {
                super.updateFolding();
            }
            Collection collection = PreviewOutputBlocksManager.this.blocks.tailMap(this.getSourceExpression()).values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutputBlock it = (OutputBlock)element$iv;
                boolean bl = false;
                it.recalculatePosition();
                it.updateFolding();
            }
        }

        private final void printAndSaveOutput(ScratchOutput output) {
            int beforeAdding = this.getLineEnd();
            int currentOutputStartLine = this.outputs.isEmpty() ? this.getLineStart() : beforeAdding + 1;
            this.outputs.add(output);
            ActionsKt.runWriteAction(() -> OutputBlock.printAndSaveOutput$lambda$2(PreviewOutputBlocksManager.this, currentOutputStartLine, output));
            PreviewEditorScratchOutputHandlerKt.highlightLines$default(PreviewOutputBlocksManager.this.markupModel, currentOutputStartLine, this.getLineEnd(), OutputStylingUtilsKt.getAttributesForOutputType(output.getType()), null, 8, null);
        }

        private final void recalculatePosition() {
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        private final void updateFolding() {
            PreviewOutputBlocksManager.this.foldingModel.runBatchFoldingOperation(() -> OutputBlock.updateFolding$lambda$3(this, PreviewOutputBlocksManager.this));
        }

        private final boolean isLastCell() {
            return false;
        }

        private final boolean isOutputSmall() {
            return true;
        }

        private static final Unit printAndSaveOutput$lambda$2(PreviewOutputBlocksManager this$0, int $currentOutputStartLine, ScratchOutput $output) {
            Project project$iv = null;
            String name$iv = null;
            Object groupId$iv = null;
            boolean $i$f$executeCommand = false;
            CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this$0, $currentOutputStartLine, $output){
                final /* synthetic */ PreviewOutputBlocksManager this$0;
                final /* synthetic */ int $currentOutputStartLine$inlined;
                final /* synthetic */ ScratchOutput $output$inlined;
                {
                    this.this$0 = previewOutputBlocksManager;
                    this.$currentOutputStartLine$inlined = n;
                    this.$output$inlined = scratchOutput;
                }

                public final void run() {
                    boolean bl = false;
                    PreviewEditorScratchOutputHandlerKt.access$insertStringAtLine(PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0), this.$currentOutputStartLine$inlined, this.$output$inlined.getText());
                }
            }, name$iv, groupId$iv);
            return Unit.INSTANCE;
        }

        private static final void updateFolding$lambda$3(OutputBlock this$0, PreviewOutputBlocksManager this$1) {
            block2: {
                FoldRegion foldRegion = this$0.foldRegion;
                if (foldRegion != null) {
                    FoldRegion foldRegion2 = foldRegion;
                    FoldingModel foldingModel = this$1.foldingModel;
                    FoldRegion p0 = foldRegion2;
                    boolean bl = false;
                    boolean $i$f$updateFolding$lambda$3$stub_for_inlining = false;
                    foldingModel.removeFoldRegion(p0);
                }
                if (this$0.getHeight() <= PreviewEditorScratchOutputHandlerKt.access$getHeight(this$0.getSourceExpression())) {
                    return;
                }
                int firstFoldedLine = this$0.getLineStart() + (PreviewEditorScratchOutputHandlerKt.access$getHeight(this$0.getSourceExpression()) - 1);
                String placeholderLine = PreviewEditorScratchOutputHandlerKt.access$getLineContent(this$1.targetDocument, firstFoldedLine) + "...";
                FoldRegion foldRegion3 = this$0.foldRegion = this$1.foldingModel.addFoldRegion(this$1.targetDocument.getLineStartOffset(firstFoldedLine), this$1.targetDocument.getLineEndOffset(this$0.getLineEnd()), placeholderLine);
                if (foldRegion3 == null) break block2;
                foldRegion3.setExpanded(this$0.isLastCell() && this$0.isOutputSmall());
            }
        }
    }
}

