/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/util/WasExperimentalOptInsNecessityCheckerFe10;", "", "<init>", "()V", "VERSION_ARGUMENT", "Lorg/jetbrains/kotlin/name/Name;", "getNecessaryOptInsFromWasExperimental", "", "Lorg/jetbrains/kotlin/name/FqName;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleApiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getSinceKotlinAnnotationApiVersionArgumentIfPresent", "getWasExperimentalAnnotationMarkerClassArgument", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nWasExperimentalOptInsNecessityCheckerFe10.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasExperimentalOptInsNecessityCheckerFe10.kt\norg/jetbrains/kotlin/idea/util/WasExperimentalOptInsNecessityCheckerFe10\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n119#2:76\n119#2:78\n1#3:77\n1#3:89\n1611#4,9:79\n1863#4:88\n1864#4:90\n1620#4:91\n*S KotlinDebug\n*F\n+ 1 WasExperimentalOptInsNecessityCheckerFe10.kt\norg/jetbrains/kotlin/idea/util/WasExperimentalOptInsNecessityCheckerFe10\n*L\n59#1:76\n69#1:78\n71#1:89\n71#1:79,9\n71#1:88\n71#1:90\n71#1:91\n*E\n"})
public final class WasExperimentalOptInsNecessityCheckerFe10 {
    @NotNull
    public static final WasExperimentalOptInsNecessityCheckerFe10 INSTANCE = new WasExperimentalOptInsNecessityCheckerFe10();
    @NotNull
    private static final Name VERSION_ARGUMENT;

    private WasExperimentalOptInsNecessityCheckerFe10() {
    }

    @NotNull
    public final Collection<FqName> getNecessaryOptInsFromWasExperimental(@NotNull Annotations annotations2, @NotNull ModuleDescriptor module, @NotNull ApiVersion moduleApiVersion) {
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleApiVersion, (String)"moduleApiVersion");
        AnnotationDescriptor wasExperimental = annotations2.findAnnotation(OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME());
        ApiVersion sinceApiVersion = this.getSinceKotlinAnnotationApiVersionArgumentIfPresent(annotations2);
        if (wasExperimental == null || sinceApiVersion == null || moduleApiVersion.compareTo(sinceApiVersion) >= 0) {
            return CollectionsKt.emptyList();
        }
        return this.getWasExperimentalAnnotationMarkerClassArgument(wasExperimental, module);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ApiVersion getSinceKotlinAnnotationApiVersionArgumentIfPresent(Annotations annotations2) {
        StringValue stringValue;
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor sinceKotlin = annotationDescriptor;
        ConstantValue constantValue = (ConstantValue)sinceKotlin.getAllValueArguments().get(VERSION_ARGUMENT);
        if (constantValue == null) return null;
        ConstantValue constantValue2 = constantValue;
        boolean $i$f$safeAs = false;
        ConstantValue constantValue3 = constantValue2;
        if (!(constantValue3 instanceof StringValue)) {
            constantValue3 = null;
        }
        if ((stringValue = (StringValue)constantValue3) == null) return null;
        String string = (String)stringValue.getValue();
        if (string == null) return null;
        String string2 = string;
        boolean bl = false;
        ApiVersion apiVersion = ApiVersion.Companion.parse(string2);
        return apiVersion;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Collection<FqName> getWasExperimentalAnnotationMarkerClassArgument(AnnotationDescriptor annotation, ModuleDescriptor module) {
        Collection collection;
        ConstantValue constantValue = (ConstantValue)annotation.getAllValueArguments().get(OptInNames.INSTANCE.getWAS_EXPERIMENTAL_ANNOTATION_CLASS());
        if (constantValue != null) {
            List list2;
            ArrayValue arrayValue;
            ConstantValue constantValue2 = constantValue;
            boolean $i$f$safeAs = false;
            ConstantValue constantValue3 = constantValue2;
            if (!(constantValue3 instanceof ArrayValue)) {
                constantValue3 = null;
            }
            if ((arrayValue = (ArrayValue)constantValue3) != null && (list2 = (List)arrayValue.getValue()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = list2;
                boolean $i$f$mapNotNull = false;
                void var9_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FqName it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ConstantValue it = (ConstantValue)element$iv$iv;
                    boolean bl2 = false;
                    KClassValue kClassValue = it instanceof KClassValue ? (KClassValue)it : null;
                    if ((kClassValue != null && (kClassValue = kClassValue.getArgumentType(module)) != null ? FqNameUtilKt.getFqName((KotlinType)kClassValue) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                collection = (List)destination$iv$iv;
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    static {
        Name name2 = Name.identifier((String)"version");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        VERSION_ARGUMENT = name2;
    }
}

