/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class MouseClickInfo {
    private final MouseButton button;
    private int times;

    @Nonnull
    public static MouseClickInfo leftButton() {
        return MouseClickInfo.button(MouseButton.LEFT_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo middleButton() {
        return MouseClickInfo.button(MouseButton.MIDDLE_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo rightButton() {
        return MouseClickInfo.button(MouseButton.RIGHT_BUTTON);
    }

    @Nonnull
    public static MouseClickInfo button(@Nonnull MouseButton button2) {
        return new MouseClickInfo(button2, 1);
    }

    private MouseClickInfo(@Nonnull MouseButton button2, int times) {
        this.button = Preconditions.checkNotNull(button2);
        this.times = times;
    }

    @Nonnull
    public MouseButton button() {
        return this.button;
    }

    public int times() {
        return this.times;
    }

    public MouseClickInfo times(int newTimes) {
        this.times = newTimes;
        return this;
    }

    @Nonnull
    public String toString() {
        return Strings.concat(String.format("%s[button=%s, times=%d]", this.getClass().getName(), this.button.toString(), this.times));
    }
}

