/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.listener;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.WeakReference;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class WeakEventListener
implements AWTEventListener {
    private final WeakReference<AWTEventListener> listenerReference;
    private final Toolkit toolkit;

    @Nonnull
    public static WeakEventListener attachAsWeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener2, long eventMask) {
        WeakEventListener l2 = new WeakEventListener(toolkit, listener2);
        toolkit.addAWTEventListener(l2, eventMask);
        return l2;
    }

    private WeakEventListener(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener listener2) {
        this.listenerReference = new WeakReference<AWTEventListener>(listener2);
        this.toolkit = toolkit;
    }

    @Nonnull
    public AWTEventListener underlyingListener() {
        return (AWTEventListener)this.listenerReference.get();
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        AWTEventListener listener2 = (AWTEventListener)this.listenerReference.get();
        if (listener2 == null) {
            this.dispose();
            return;
        }
        listener2.eventDispatched(e);
    }

    public void dispose() {
        this.toolkit.removeAWTEventListener(this);
    }

    @VisibleForTesting
    void simulateUnderlyingListenerIsGarbageCollected() {
        this.listenerReference.clear();
    }
}

