/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;

public class GenericType
extends VarType
implements Type {
    public static final int WILDCARD_EXTENDS = 1;
    public static final int WILDCARD_SUPER = 2;
    public static final int WILDCARD_UNBOUND = 3;
    public static final int WILDCARD_NO = 4;
    private final VarType parent;
    private final List<VarType> arguments;
    private final int wildcard;

    public GenericType(int type, int arrayDim, String value, VarType parent, List<VarType> arguments, int wildcard) {
        super(type, arrayDim, value, GenericType.getFamily(type, arrayDim), GenericType.getStackSize(type, arrayDim), false);
        this.parent = parent;
        this.arguments = arguments == null ? Collections.emptyList() : arguments;
        this.wildcard = wildcard;
    }

    public static VarType parse(String signature) {
        return GenericType.parse(signature, 4);
    }

    public static VarType parse(String signature, int wildcard) {
        int type = 0;
        int arrayDim = 0;
        String value = null;
        List<VarType> params = null;
        VarType parent = null;
        block5: for (int index = 0; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '[': {
                    ++arrayDim;
                    continue block5;
                }
                case 'T': {
                    type = 18;
                    value = signature.substring(index + 1, signature.length() - 1);
                    break block5;
                }
                case 'L': {
                    type = 8;
                    signature = signature.substring(index + 1, signature.length() - 1);
                    String cl = GenericType.getNextClassSignature(signature);
                    if (cl.length() == signature.length()) {
                        int argStart = cl.indexOf(60);
                        if (argStart >= 0) {
                            value = cl.substring(0, argStart);
                            params = GenericType.parseArgumentsList(cl.substring(argStart + 1, cl.length() - 1));
                            break block5;
                        }
                        value = cl;
                        break block5;
                    }
                    StringBuilder name_buff = new StringBuilder();
                    while (!signature.isEmpty()) {
                        String name = cl;
                        String args = null;
                        int argStart = cl.indexOf(60);
                        if (argStart >= 0) {
                            name = cl.substring(0, argStart);
                            args = cl.substring(argStart + 1, cl.length() - 1);
                        }
                        if (!name_buff.isEmpty()) {
                            name_buff.append('$');
                        }
                        name_buff.append(name);
                        value = name_buff.toString();
                        List<VarType> list = params = args == null ? null : GenericType.parseArgumentsList(args);
                        if (cl.length() == signature.length()) break block5;
                        parent = parent == null && params == null ? GenericType.parse("L" + value + ";") : new GenericType(8, 0, value, parent, params, wildcard);
                        signature = signature.substring(cl.length() + 1);
                        cl = GenericType.getNextClassSignature(signature);
                    }
                    break block5;
                }
                default: {
                    value = signature.substring(index, index + 1);
                    type = GenericType.getType(value.charAt(0));
                }
            }
        }
        if (type == 18) {
            return new GenericType(type, arrayDim, value, null, null, wildcard);
        }
        if (type == 8) {
            if (parent == null && params == null && wildcard == 4) {
                return new VarType(type, arrayDim, value);
            }
            return new GenericType(type, arrayDim, value, parent, params, wildcard);
        }
        return new VarType(type, arrayDim, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getNextClassSignature(String value) {
        int counter = 0;
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    --counter;
                    break;
                }
                case '.': {
                    if (counter != 0) break;
                    return value.substring(0, index);
                }
            }
            ++index;
        }
        return value.substring(0, index);
    }

    private static List<VarType> parseArgumentsList(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<VarType> args = new ArrayList<VarType>();
        while (!value.isEmpty()) {
            int wildcard;
            String typeStr = GenericType.getNextType(value);
            int len = typeStr.length();
            switch (typeStr.charAt(0)) {
                case '*': {
                    int n = 3;
                    break;
                }
                case '+': {
                    int n = 1;
                    break;
                }
                case '-': {
                    int n = 2;
                    break;
                }
                default: {
                    int n = wildcard = 4;
                }
            }
            if (wildcard != 4) {
                typeStr = typeStr.substring(1);
            }
            args.add(typeStr.isEmpty() ? null : GenericType.parse(typeStr, wildcard));
            value = value.substring(len);
        }
        return args;
    }

    public static String getNextType(String value) {
        int index;
        int counter = 0;
        boolean contMode = false;
        block8: for (index = 0; index < value.length(); ++index) {
            switch (value.charAt(index)) {
                case '*': {
                    if (contMode) continue block8;
                    break block8;
                }
                case 'L': 
                case 'T': {
                    if (!contMode) {
                        contMode = true;
                    }
                }
                case '+': 
                case '-': 
                case '[': {
                    continue block8;
                }
                case '<': {
                    ++counter;
                    continue block8;
                }
                case '>': {
                    --counter;
                    continue block8;
                }
                case ';': {
                    if (counter != 0) continue block8;
                    break block8;
                }
                default: {
                    if (!contMode) break block8;
                }
            }
        }
        return value.substring(0, index + 1);
    }

    @Override
    public GenericType decreaseArrayDim() {
        assert (this.getArrayDim() > 0) : this;
        return new GenericType(this.getType(), this.getArrayDim() - 1, this.getValue(), this.parent, this.arguments, this.wildcard);
    }

    @Override
    public VarType resizeArrayDim(int newArrayDim) {
        return new GenericType(this.getType(), newArrayDim, this.getValue(), this.parent, this.arguments, this.wildcard);
    }

    public VarType getParent() {
        return this.parent;
    }

    public List<VarType> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    public int getWildcard() {
        return this.wildcard;
    }

    public List<TypeAnnotationWriteHelper> appendCastName(StringBuilder clsName, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        if (this.parent != null && this.parent.isGeneric()) {
            typeAnnWriteHelpers = ((GenericType)this.parent).appendCastName(clsName, typeAnnWriteHelpers);
            clsName.append(".");
            typeAnnWriteHelpers = ExprProcessor.writeNestedTypeAnnotations(clsName, typeAnnWriteHelpers);
            clsName.append(this.getValue().substring(this.parent.getValue().length() + 1));
            return this.appendTypeArguments(clsName, typeAnnWriteHelpers);
        }
        String stringTypes = DecompilerContext.getImportCollector().getNestedName(this.getValue().replace('/', '.'));
        List<String> nestedTypes = Arrays.asList(stringTypes.split("\\."));
        typeAnnWriteHelpers = ExprProcessor.writeNestedClass(clsName, this, nestedTypes, typeAnnWriteHelpers);
        this.appendTypeArguments(clsName, typeAnnWriteHelpers);
        ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
        return typeAnnWriteHelpers;
    }

    private List<TypeAnnotationWriteHelper> appendTypeArguments(StringBuilder buffer, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        if (!this.arguments.isEmpty()) {
            buffer.append('<');
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                VarType par = this.arguments.get(i);
                List<TypeAnnotationWriteHelper> locTypeAnnWriteHelpers = GenericMain.getGenericTypeAnnotations(i, typeAnnWriteHelpers);
                typeAnnWriteHelpers.removeAll(locTypeAnnWriteHelpers);
                locTypeAnnWriteHelpers = GenericMain.writeTypeAnnotationBeforeWildCard(buffer, par, locTypeAnnWriteHelpers);
                if (par == null) {
                    buffer.append('?');
                    continue;
                }
                if (par.isGeneric()) {
                    GenericType gen = (GenericType)par;
                    switch (gen.getWildcard()) {
                        case 1: {
                            buffer.append("? extends ");
                            break;
                        }
                        case 2: {
                            buffer.append("? super ");
                        }
                    }
                    locTypeAnnWriteHelpers = GenericMain.writeTypeAnnotationAfterWildCard(buffer, par, locTypeAnnWriteHelpers);
                    buffer.append(GenericMain.getGenericCastTypeName(gen, locTypeAnnWriteHelpers));
                    continue;
                }
                buffer.append(ExprProcessor.getCastTypeName(par, locTypeAnnWriteHelpers));
            }
            buffer.append(">");
        }
        return typeAnnWriteHelpers;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        switch (this.getWildcard()) {
            case 1: {
                buf.append("? extends ");
                break;
            }
            case 2: {
                buf.append("? super ");
            }
        }
        buf.append(super.toString());
        this.appendTypeArguments(buf, Collections.emptyList());
        return buf.toString();
    }

    @Override
    public VarType remap(Map<VarType, VarType> map) {
        VarType main = super.remap(map);
        if (main != this) {
            return main;
        }
        boolean changed = false;
        VarType parent = this.getParent();
        if (map.containsKey(parent)) {
            parent = map.get(parent);
            changed = true;
        }
        ArrayList<VarType> newArgs = new ArrayList<VarType>();
        for (VarType arg : this.getArguments()) {
            VarType newArg = null;
            if (arg != null) {
                newArg = arg.remap(map);
            }
            if (newArg != arg) {
                newArgs.add(newArg);
                changed = true;
                continue;
            }
            newArgs.add(arg);
        }
        if (changed) {
            return new GenericType(main.getType(), main.getArrayDim(), main.getValue(), parent, newArgs, this.getWildcard());
        }
        return this;
    }
}

