/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.iterators.SingleNodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMatchingVisitor
extends JavaElementVisitor {
    public static final String[] MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile", "default"};
    private final GlobalMatchingVisitor myMatchingVisitor;
    private PsiClass myClazz;

    public JavaMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(0);
        }
        PsiComment other = null;
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof PsiComment)) {
            if (element instanceof PsiMember && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)comment) instanceof PsiDeclarationStatement) {
                other = (PsiComment)ObjectUtils.tryCast((Object)element.getFirstChild(), PsiComment.class);
            }
        } else {
            other = (PsiComment)element;
        }
        if (!this.myMatchingVisitor.setResult(other != null)) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)comment.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            RegExpPredicate predicate = (RegExpPredicate)substitutionHandler.findPredicate(RegExpPredicate.class);
            if (predicate != null) {
                predicate.setNodeTextGenerator(e -> JavaMatchUtil.getCommentText((PsiComment)e).trim());
                this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)other, this.myMatchingVisitor.getMatchContext()));
            } else {
                int end;
                int start;
                String text = other.getText();
                int length = text.length();
                IElementType tokenType = other.getTokenType();
                int n = start = tokenType == JavaDocTokenType.DOC_COMMENT_START ? 3 : 2;
                while (start < length && text.charAt(start) == ' ') {
                    ++start;
                }
                int n2 = end = tokenType == JavaTokenType.END_OF_LINE_COMMENT || length < 4 ? length : length - 2;
                while (end > 0 && text.charAt(end - 1) == ' ') {
                    --end;
                }
                this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)other, start, end, this.myMatchingVisitor.getMatchContext()));
            }
        } else if (handler instanceof LiteralWithSubstitutionHandler) {
            if (comment instanceof PsiDocComment) {
                this.myMatchingVisitor.setResult(handler.match((PsiElement)comment, (PsiElement)other, this.myMatchingVisitor.getMatchContext()));
            } else {
                int offset;
                LiteralWithSubstitutionHandler lwsHandler = (LiteralWithSubstitutionHandler)handler;
                String commentText = other.getText();
                for (offset = other.getTokenType() == JavaDocTokenType.DOC_COMMENT_START ? 3 : 2; commentText.length() > offset && commentText.charAt(offset) <= ' '; ++offset) {
                }
                this.myMatchingVisitor.setResult(lwsHandler.match((PsiElement)other, JavaMatchUtil.getCommentText(other).trim(), offset, this.myMatchingVisitor.getMatchContext()));
            }
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)comment, (PsiElement)other, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(MatchUtil.normalize((String)JavaMatchUtil.getCommentText(comment)), MatchUtil.normalize((String)JavaMatchUtil.getCommentText(other))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitModifierList(@NotNull PsiModifierList list) {
        if (list == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(1);
        }
        PsiModifierList other = (PsiModifierList)this.myMatchingVisitor.getElement();
        for (String modifier : MODIFIERS) {
            if (this.myMatchingVisitor.setResult(!list.hasModifierProperty(modifier) || other.hasModifierProperty(modifier))) continue;
            return;
        }
        Object[] annotations = list.getAnnotations();
        if (annotations.length > 0) {
            HashSet annotationSet = ContainerUtil.newHashSet((Object[])annotations);
            for (Object annotation : annotations) {
                PsiNameValuePair[] attributes;
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !"Modifier".equals(nameReferenceElement.getText())) continue;
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                for (PsiNameValuePair pair : attributes = parameterList.getAttributes()) {
                    PsiAnnotationMemberValue value = pair.getValue();
                    if (value == null) continue;
                    if (value instanceof PsiArrayInitializerMemberValue) {
                        boolean matchedOne = false;
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                            if (!JavaMatchingVisitor.annotationValueMatchesModifierList(other, v)) continue;
                            matchedOne = true;
                            break;
                        }
                        if (this.myMatchingVisitor.setResult(matchedOne)) continue;
                        return;
                    }
                    if (this.myMatchingVisitor.setResult(JavaMatchingVisitor.annotationValueMatchesModifierList(other, value))) continue;
                    return;
                }
                annotationSet.remove(annotation);
            }
            if (!annotationSet.isEmpty()) {
                Object[] otherAnnotations = other.getAnnotations();
                SmartList unmatchedElements = new SmartList(otherAnnotations);
                this.myMatchingVisitor.getMatchContext().pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitModifierList$1((List)unmatchedElements, arg_0));
                try {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotationSet.toArray(PsiAnnotation.EMPTY_ARRAY), (PsiElement[])otherAnnotations));
                    other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
                }
                finally {
                    this.myMatchingVisitor.getMatchContext().popMatchedElementsListener();
                }
            }
        }
    }

    private static boolean annotationValueMatchesModifierList(PsiModifierList list, PsiAnnotationMemberValue value) {
        String name = StringUtil.unquoteString((String)value.getText());
        if ("Instance".equals(name)) {
            return !list.hasModifierProperty("static") && !list.hasModifierProperty("abstract") && list.getParent() instanceof PsiMember;
        }
        return list.hasModifierProperty(name) && (!"packageLocal".equals(name) || list.getParent() instanceof PsiMember);
    }

    public void visitDocTag(@NotNull PsiDocTag tag) {
        if (tag == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(2);
        }
        PsiDocTag other = (PsiDocTag)this.myMatchingVisitor.getElement();
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern.isTypedVar(tag.getNameElement());
        if (!isTypedVar && !this.myMatchingVisitor.setResult(tag.getName().equals(other.getName()))) {
            return;
        }
        PsiDocTagValue psiDocTagValue = tag.getValueElement();
        boolean isTypedValue = false;
        if (psiDocTagValue != null) {
            PsiElement[] children = psiDocTagValue.getChildren();
            if (children.length == 1) {
                psiDocTagValue = children[0];
            }
            if ((isTypedValue = pattern.isTypedVar((PsiElement)psiDocTagValue)) && (other.getValueElement() != null ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)psiDocTagValue, (PsiElement)other.getValueElement())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)psiDocTagValue)))) {
                return;
            }
        }
        if (!isTypedValue && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((NodeIterator)new DocValuesIterator(tag.getFirstChild()), (NodeIterator)new DocValuesIterator(other.getFirstChild())))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(tag.getNameElement(), other.getNameElement()));
        }
    }

    public void visitDocComment(@NotNull PsiDocComment comment) {
        PsiDocComment other;
        if (comment == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(3);
        }
        if ((other = (PsiDocComment)this.myMatchingVisitor.getElement(PsiDocComment.class)) == null) {
            return;
        }
        PsiDocTag[] tags = comment.getTags();
        if (tags.length > 0 && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tags, (PsiElement[])other.getTags()))) {
            return;
        }
        this.visitComment((PsiComment)comment);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(4);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(element, this.myMatchingVisitor.getElement()));
    }

    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        PsiArrayInitializerExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(5);
        }
        if ((other = this.getExpression(PsiArrayInitializerExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression.getInitializers(), (PsiElement[])other.getInitializers()));
    }

    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(6);
        }
        PsiClassInitializer other = (PsiClassInitializer)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer.getModifierList(), (PsiElement)other.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)initializer.getBody(), (PsiElement)other.getBody()));
    }

    public void visitCodeBlock(@NotNull PsiCodeBlock block) {
        if (block == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(7);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, this.myMatchingVisitor.getElement()));
    }

    public void visitJavaToken(@NotNull PsiJavaToken token) {
        PsiElement other;
        if (token == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(8);
        }
        this.myMatchingVisitor.setResult((!((other = this.myMatchingVisitor.getElement()) instanceof PsiJavaToken) || token.getTokenType() == ((PsiJavaToken)other).getTokenType()) && (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)token) ? this.myMatchingVisitor.handleTypedElement((PsiElement)token, other) : this.myMatchingVisitor.matchText((PsiElement)token, other)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(9);
        }
        PsiAnnotation other = (PsiAnnotation)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotation.getNameReferenceElement(), (PsiElement)other.getNameReferenceElement()))) {
            return;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length == 0) {
            return;
        }
        Object[] otherAttributes = other.getParameterList().getAttributes();
        SmartList unmatchedElements = new SmartList(otherAttributes);
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitAnnotation$2((List)unmatchedElements, arg_0));
        try {
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])attributes, (PsiElement[])otherAttributes))) {
                other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
        finally {
            context.popMatchedElementsListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(10);
        }
        PsiNameValuePair other = (PsiNameValuePair)this.myMatchingVisitor.getElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        PsiIdentifier nameIdentifier = pair.getNameIdentifier();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
        if (nameIdentifier != null) {
            context.pushResult();
        }
        PsiIdentifier otherIdentifier = other.getNameIdentifier();
        try {
            PsiAnnotationMemberValue value1 = pair.getValue();
            PsiAnnotationMemberValue value2 = other.getValue();
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(JavaMatchingVisitor.getElementToMatch(value1), JavaMatchingVisitor.getElementToMatch(value2)) || value1 instanceof PsiReferenceExpression && this.myMatchingVisitor.match((PsiElement)value1, (PsiElement)value2))) {
                if (nameIdentifier != null) {
                    this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText(nameIdentifier.getText(), otherIdentifier == null ? "value" : otherIdentifier.getText()));
                } else {
                    this.myMatchingVisitor.setResult(otherIdentifier == null || "value".equals(otherIdentifier.getText()));
                }
            }
        }
        finally {
            PsiIdentifier matchNode;
            if (otherIdentifier != null) {
                matchNode = otherIdentifier;
            } else {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                PsiAnnotation annotation = (PsiAnnotation)factory.createStatementFromText("@Anno(value=\"\")", (PsiElement)other).getFirstChild().getFirstChild();
                matchNode = annotation.getParameterList().getAttributes()[0].getNameIdentifier();
            }
            if (nameIdentifier != null) {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)matchNode);
            }
        }
    }

    private static PsiElement getElementToMatch(PsiAnnotationMemberValue value) {
        PsiArrayInitializerMemberValue arrayInitializer;
        PsiAnnotationMemberValue[] initializers;
        if (value instanceof PsiArrayInitializerMemberValue && (initializers = (arrayInitializer = (PsiArrayInitializerMemberValue)value).getInitializers()).length > 0) {
            return initializers[0];
        }
        return value;
    }

    private boolean checkHierarchy(PsiMember element, PsiMember patternElement) {
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternElement);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            if (!substitutionHandler.isSubtype()) {
                if (substitutionHandler.isStrictSubtype()) {
                    return element.getContainingClass() != this.myClazz;
                }
            } else {
                return true;
            }
        }
        return this.myClazz == null || element.getContainingClass() == this.myClazz;
    }

    public void visitField(@NotNull PsiField field) {
        PsiField other;
        if (field == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(11);
        }
        if ((other = (PsiField)this.myMatchingVisitor.getElement(PsiField.class)) == null) {
            return;
        }
        PsiDocComment comment = field.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other.getDocComment()))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)field))) {
            return;
        }
        super.visitField(field);
    }

    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        PsiEnumConstant other;
        if (enumConstant == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(12);
        }
        if ((other = (PsiEnumConstant)this.myMatchingVisitor.getElement(PsiEnumConstant.class)) == null) {
            return;
        }
        PsiExpressionList argumentList = enumConstant.getArgumentList();
        if (argumentList != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)argumentList, (PsiElement)other.getArgumentList()))) {
            return;
        }
        PsiEnumConstantInitializer enumConstantInitializer = enumConstant.getInitializingClass();
        if (enumConstantInitializer != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)enumConstantInitializer, (PsiElement)other.getInitializingClass()))) {
            return;
        }
        super.visitEnumConstant(enumConstant);
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass clazz) {
        PsiAnonymousClass other;
        if (clazz == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(13);
        }
        if ((other = (PsiAnonymousClass)this.myMatchingVisitor.getElement(PsiAnonymousClass.class)) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = clazz.getBaseClassReference();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)classReference);
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.match((PsiElement)clazz.getBaseClassReference(), (PsiElement)other.getBaseClassReference())) && this.myMatchingVisitor.matchSons((PsiElement)clazz.getArgumentList(), (PsiElement)other.getArgumentList()) && this.matchClasses((PsiClass)clazz, (PsiClass)other)) && isTypedVar) {
            this.myMatchingVisitor.setResult(classReference instanceof LightElement || this.matchType((PsiElement)classReference, (PsiElement)other.getBaseClassReference()));
        }
    }

    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        PsiLambdaExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(14);
        }
        if ((other = this.getExpression(PsiLambdaExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        PsiParameterList parameterList1 = expression.getParameterList();
        if (!this.myMatchingVisitor.setResult(parameterList1.isEmpty() || this.myMatchingVisitor.matchSons((PsiElement)parameterList1, (PsiElement)other.getParameterList()))) {
            return;
        }
        PsiElement body1 = this.getElementToMatch(expression.getBody());
        if (body1 == null) {
            return;
        }
        PsiElement body2 = this.getElementToMatch(other.getBody());
        if (body1 instanceof PsiExpression && (body2 == null || body2 instanceof PsiStatement || body2 instanceof PsiComment)) {
            PsiElement parent = body1.getParent();
            this.myMatchingVisitor.setResult(parent instanceof PsiStatement ? this.myMatchingVisitor.matchSequentially(parent, body2) : this.myMatchingVisitor.matchSequentially(body1, body2 == null ? other.getBody() : body2.getParent()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(body1, body2));
        }
    }

    private PsiElement getElementToMatch(PsiElement element) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (element instanceof PsiCodeBlock) {
                List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
                if (list.isEmpty()) {
                    return null;
                }
                element = (PsiElement)list.get(0);
                if (list.size() > 1) {
                    return element;
                }
            }
            if (element instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
                element = expressionStatement.getExpression();
            }
            if (element instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                element = returnStatement.getReturnValue();
            }
        }
        return element;
    }

    private boolean matchInAnyOrder(PsiReferenceList patternElements, PsiReferenceList matchElements) {
        if (patternElements == null) {
            return this.myMatchingVisitor.isLeftLooseMatching() || matchElements == null;
        }
        return this.myMatchingVisitor.matchInAnyOrder((PsiElement[])patternElements.getReferenceElements(), (PsiElement[])(matchElements != null ? matchElements.getReferenceElements() : PsiElement.EMPTY_ARRAY));
    }

    public void visitRecordHeader(@NotNull PsiRecordHeader recordHeader) {
        if (recordHeader == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(15);
        }
        PsiRecordHeader other = (PsiRecordHeader)this.myMatchingVisitor.getElement(PsiRecordHeader.class);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])recordHeader.getRecordComponents(), (PsiElement[])other.getRecordComponents()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchClasses(PsiClass patternClass, PsiClass matchClass) {
        PsiClass saveClazz = this.myClazz;
        this.myClazz = matchClass;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        JavaCompiledPattern javaPattern = (JavaCompiledPattern)context.getPattern();
        HashSet matchedElements = new HashSet();
        context.pushMatchedElementsListener(elements -> matchedElements.addAll(elements));
        try {
            PsiClassInitializer[] initializers2;
            PsiClassInitializer[] initializers;
            PsiClass[] nestedClasses;
            PsiMethod[] methods;
            PsiField[] fields;
            int n;
            boolean templateIsInterface = patternClass.isInterface();
            if (templateIsInterface && !matchClass.isInterface()) {
                boolean bl = false;
                return bl;
            }
            if (templateIsInterface && patternClass.isAnnotationType() && !matchClass.isAnnotationType()) {
                boolean bl = false;
                return bl;
            }
            if (patternClass.isEnum() && !matchClass.isEnum()) {
                boolean bl = false;
                return bl;
            }
            if (patternClass instanceof PsiTypeParameter != matchClass instanceof PsiTypeParameter) {
                boolean bl = false;
                return bl;
            }
            if (patternClass.isRecord() && !matchClass.isRecord()) {
                boolean bl = false;
                return bl;
            }
            if (!this.myMatchingVisitor.match((PsiElement)patternClass.getRecordHeader(), (PsiElement)matchClass.getRecordHeader())) {
                boolean bl = false;
                return bl;
            }
            if (!this.matchInAnyOrder(patternClass.getExtendsList(), matchClass.getExtendsList())) {
                boolean bl = false;
                return bl;
            }
            PsiReferenceList implementsList = patternClass.getImplementsList();
            if (implementsList != null) {
                if (implementsList.getFirstChild() != null && matchClass.isInterface()) {
                    boolean bl = false;
                    return bl;
                }
                SmartList elements2 = new SmartList();
                for (PsiJavaCodeReferenceElement element : implementsList.getReferenceElements()) {
                    SubstitutionHandler substitutionHandler;
                    MatchingHandler handler = javaPattern.getHandler((PsiElement)element);
                    if (handler instanceof SubstitutionHandler && ((substitutionHandler = (SubstitutionHandler)handler).isSubtype() || substitutionHandler.isStrictSubtype())) {
                        if (this.matchWithinHierarchy((PsiElement)element, (PsiElement)matchClass, substitutionHandler)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    elements2.add(element);
                }
                if (!elements2.isEmpty()) {
                    PsiElement[] matchElements;
                    PsiReferenceList implementsList2 = matchClass.getImplementsList();
                    Object[] objectArray = matchElements = implementsList2 == null ? PsiElement.EMPTY_ARRAY : implementsList2.getReferenceElements();
                    if (!this.myMatchingVisitor.matchInAnyOrder(elements2.toArray(PsiElement.EMPTY_ARRAY), matchElements)) {
                        n = 0;
                        return n != 0;
                    }
                }
            }
            if ((fields = (PsiField[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiField.class)) != null) {
                PsiField[] fields2;
                PsiField[] psiFieldArray = fields2 = javaPattern.isRequestsSuperFields() ? matchClass.getAllFields() : matchClass.getFields();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])fields, (PsiElement[])fields2)) {
                    boolean matchElements = false;
                    return matchElements;
                }
            }
            if ((methods = (PsiMethod[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiMethod.class)) != null) {
                PsiMethod[] methods2;
                PsiMethod[] psiMethodArray = methods2 = javaPattern.isRequestsSuperMethods() ? matchClass.getAllMethods() : matchClass.getMethods();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])methods, (PsiElement[])methods2)) {
                    n = 0;
                    return n != 0;
                }
            }
            if ((nestedClasses = (PsiClass[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiClass.class)) != null) {
                PsiClass[] nestedClasses2;
                PsiClass[] psiClassArray = nestedClasses2 = javaPattern.isRequestsSuperInners() ? matchClass.getAllInnerClasses() : matchClass.getInnerClasses();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])nestedClasses, (PsiElement[])nestedClasses2)) {
                    boolean element = false;
                    return element;
                }
            }
            if ((initializers = patternClass.getInitializers()).length > 0 && !this.myMatchingVisitor.matchInAnyOrder((PsiElement[])initializers, (PsiElement[])(initializers2 = matchClass.getInitializers()))) {
                boolean handler = false;
                return handler;
            }
            SmartList unmatchedElements = new SmartList((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)matchClass, PsiMember.class));
            unmatchedElements.removeAll(matchedElements);
            MatchingHandler unmatchedSubstitutionHandler = null;
            for (PsiElement element = patternClass.getLBrace(); element != null; element = element.getNextSibling()) {
                if (!(element instanceof PsiTypeElement) || !(element.getNextSibling() instanceof PsiErrorElement)) continue;
                unmatchedSubstitutionHandler = javaPattern.getHandler(element);
                break;
            }
            if (unmatchedSubstitutionHandler instanceof SubstitutionHandler) {
                SubstitutionHandler handler = (SubstitutionHandler)unmatchedSubstitutionHandler;
                for (PsiElement element : unmatchedElements) {
                    handler.handle(element, context);
                }
            } else {
                matchClass.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myClazz = saveClazz;
            context.popMatchedElementsListener();
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (matchElement instanceof PsiBlockStatement) {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)matchElement).getCodeBlock();
                if (patternElement instanceof PsiBlockStatement || codeBlock.getStatementCount() == 1) {
                    matchElement = codeBlock.getFirstChild();
                }
            }
            if (patternElement instanceof PsiBlockStatement) {
                patternElement = ((PsiBlockStatement)patternElement).getCodeBlock().getFirstChild();
            }
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        PsiArrayAccessExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(16);
        }
        if ((other = this.getExpression(PsiArrayAccessExpression.class, (PsiExpression)expression)) != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression.getArrayExpression(), (PsiElement)other.getArrayExpression()) && this.myMatchingVisitor.match((PsiElement)expression.getIndexExpression(), (PsiElement)other.getIndexExpression()));
        }
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(17);
        }
        if (this.getExpression(PsiMethodReferenceExpression.class, (PsiExpression)expression) == null) {
            return;
        }
        super.visitMethodReferenceExpression(expression);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        PsiElement target;
        boolean multiMatch;
        if (reference == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(18);
        }
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        PsiElement referenceNameElement = reference.getReferenceNameElement();
        assert (referenceNameElement != null);
        MatchingHandler _handler = pattern.getHandlerSimple(referenceNameElement);
        boolean special = false;
        if (_handler == null) {
            _handler = pattern.getHandlerSimple((PsiElement)reference);
            special = reference.resolve() != null;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiElement unwrapped = JavaMatchingVisitor.unwrap(other, context);
        PsiExpression qualifier = reference.getQualifierExpression();
        if (_handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler = (SubstitutionHandler)_handler;
            if (qualifier == null || special) {
                if (other instanceof PsiReferenceExpression && other.getParent() instanceof PsiMethodCallExpression) {
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                if (handler.isSubtype() || handler.isStrictSubtype()) {
                    if (this.myMatchingVisitor.setResult(this.matchWithinHierarchy((PsiElement)reference, unwrapped, handler))) {
                        handler.addResult(other, this.myMatchingVisitor.getMatchContext());
                    }
                } else if (this.myMatchingVisitor.setResult(handler.validate(unwrapped, context))) {
                    handler.addResult(other, context);
                }
                return;
            }
        }
        boolean bl = multiMatch = unwrapped != null && reference.getContainingFile() == unwrapped.getContainingFile();
        if (!(unwrapped instanceof PsiReferenceExpression)) {
            this.myMatchingVisitor.setResult(multiMatch && this.myMatchingVisitor.matchText((PsiElement)reference, unwrapped));
            return;
        }
        PsiReferenceExpression reference2 = (PsiReferenceExpression)unwrapped;
        PsiExpression qualifier2 = reference2.getQualifierExpression();
        if (multiMatch && (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (qualifier2 == null || qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) && (target = reference.resolve()) != null) {
            this.myMatchingVisitor.setResult(target == reference2.resolve());
            return;
        }
        if (qualifier == null && qualifier2 == null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceNameElement, reference2.getReferenceNameElement()));
            return;
        }
        if (this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiMethodCallExpression) && qualifier != null)) {
            PsiElement referenceNameElement2 = reference2.getReferenceNameElement();
            if (pattern.isTypedVar(referenceNameElement) ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(referenceNameElement, referenceNameElement2)) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceNameElement, referenceNameElement2))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(qualifier instanceof PsiThisExpression && qualifier2 == null || this.myMatchingVisitor.matchOptionally((PsiElement)qualifier, (PsiElement)qualifier2))) {
                return;
            }
            if (qualifier2 == null) {
                this.myMatchingVisitor.setResult(this.matchImplicitQualifier(qualifier, unwrapped, context));
            }
        }
    }

    private static PsiElement unwrap(PsiElement element, @NotNull MatchContext context) {
        if (context == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(19);
        }
        return context.getOptions().isLooseMatching() && element instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element)) : element;
    }

    private static int getArrayDimensions(PsiElement element) {
        if (element == null) {
            return 0;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType type = variable.getType();
            return type.getArrayDimensions();
        }
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            PsiType type = method.getReturnType();
            return type == null ? 0 : type.getArrayDimensions();
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiType type = typeElement.getType();
            return type.getArrayDimensions();
        }
        return 0;
    }

    @NotNull
    private static PsiTypeElement getInnermostComponentTypeElement(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(20);
        }
        PsiElement child = typeElement.getFirstChild();
        while (child instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)child;
            child = typeElement.getFirstChild();
        }
        PsiTypeElement psiTypeElement = typeElement;
        if (psiTypeElement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(21);
        }
        return psiTypeElement;
    }

    @Contract(value="!null->!null; null->null")
    private static PsiElement getInnermostComponent(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        if (!(element instanceof PsiTypeElement)) {
            return element;
        }
        PsiTypeElement typeElement = (PsiTypeElement)element;
        if (typeElement.getType() instanceof PsiDisjunctionType) {
            return typeElement;
        }
        if (typeElement.isInferredType()) {
            PsiType type = typeElement.getType();
            if (type == PsiTypes.nullType() || type instanceof PsiLambdaParameterType || type instanceof PsiLambdaExpressionType) {
                return typeElement;
            }
            String canonicalText = type.getCanonicalText();
            typeElement = JavaPsiFacade.getElementFactory((Project)typeElement.getProject()).createTypeElementFromText(canonicalText, (PsiElement)typeElement);
        }
        return (referenceElement = typeElement.getInnermostComponentReferenceElement()) != null ? referenceElement : JavaMatchingVisitor.getInnermostComponentTypeElement(typeElement);
    }

    private static PsiTypeElement[] getTypeParameters(@NotNull PsiJavaCodeReferenceElement referenceElement, Boolean replaceDiamondWithExplicitTypes) {
        PsiReferenceParameterList referenceElementParameterList;
        if (referenceElement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(22);
        }
        if ((referenceElementParameterList = referenceElement.getParameterList()) == null) {
            return null;
        }
        PsiTypeElement[] typeParameterElements = referenceElementParameterList.getTypeParameterElements();
        if (typeParameterElements.length != 1 || replaceDiamondWithExplicitTypes == Boolean.FALSE) {
            return typeParameterElements;
        }
        PsiType type = typeParameterElements[0].getType();
        if (!(type instanceof PsiDiamondType)) {
            return typeParameterElements;
        }
        PsiDiamondType diamondType = (PsiDiamondType)type;
        if (replaceDiamondWithExplicitTypes == null) {
            return null;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = diamondType.resolveInferredTypes();
        StringBuilder text = new StringBuilder(referenceElement.getQualifiedName());
        text.append('<');
        boolean comma = false;
        for (PsiType inferredType : inferenceResult.getInferredTypes()) {
            if (comma) {
                text.append(',');
            } else {
                comma = true;
            }
            text.append(inferredType.getCanonicalText());
        }
        text.append('>');
        PsiJavaCodeReferenceElement newReferenceElement = JavaPsiFacade.getElementFactory((Project)referenceElement.getProject()).createReferenceFromText(text.toString(), (PsiElement)referenceElement);
        PsiReferenceParameterList newParameterList = newReferenceElement.getParameterList();
        return newParameterList == null ? null : newParameterList.getTypeParameterElements();
    }

    private Boolean shouldReplaceDiamondWithExplicitTypes(@NotNull PsiElement element) {
        SubstitutionHandler substitutionHandler;
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(23);
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return Boolean.TRUE;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return Boolean.TRUE;
        }
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        if (elements.length != 1) {
            return Boolean.TRUE;
        }
        PsiTypeElement typeElement = elements[0];
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)typeElement);
        if (handler instanceof SubstitutionHandler && (substitutionHandler = (SubstitutionHandler)handler).getMinOccurs() > 0) {
            return null;
        }
        return !(typeElement.getType() instanceof PsiDiamondType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchType(@NotNull PsiElement patternType, PsiElement matchedType) {
        boolean caseSensitive;
        String text2;
        String text;
        boolean equalsIgnorePackage;
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement patternElement;
        if (patternType == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(24);
        }
        PsiElement matchedElement = (patternElement = JavaMatchingVisitor.getInnermostComponent(patternType)) instanceof PsiTypeElement && ((PsiTypeElement)patternElement).isInferredType() ? matchedType : JavaMatchingVisitor.getInnermostComponent(matchedType);
        PsiTypeElement[] typeParameters = null;
        if (matchedElement instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)matchedElement;
            typeParameters = JavaMatchingVisitor.getTypeParameters(referenceElement, this.shouldReplaceDiamondWithExplicitTypes(patternElement));
        } else if (matchedElement instanceof PsiTypeParameter) {
            matchedElement = ((PsiTypeParameter)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiClass && ((PsiClass)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiClass)matchedElement).getTypeParameters();
            matchedElement = ((PsiClass)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiMethod && ((PsiMethod)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiMethod)matchedElement).getTypeParameters();
            matchedElement = ((PsiMethod)matchedElement).getNameIdentifier();
        }
        if (patternElement instanceof PsiTypeElement && matchedElement instanceof PsiTypeElement) {
            PsiType type1 = ((PsiTypeElement)patternElement).getType();
            PsiType type2 = ((PsiTypeElement)matchedElement).getType();
            if (type1 instanceof PsiWildcardType) {
                PsiWildcardType wildcardType1 = (PsiWildcardType)type1;
                if (type2 instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType2 = (PsiWildcardType)type2;
                    if (wildcardType1.equals((Object)wildcardType2)) {
                        return true;
                    }
                    if (wildcardType1.isExtends() && (wildcardType2.isExtends() || !wildcardType2.isBounded())) {
                        if (wildcardType2.isExtends()) {
                            return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                        }
                        return this.myMatchingVisitor.matchOptionally(patternElement.getLastChild(), null);
                    }
                    if (wildcardType1.isSuper() && wildcardType2.isSuper()) {
                        return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                    }
                }
            }
        }
        if (patternElement instanceof PsiJavaCodeReferenceElement) {
            PsiTypeElement[] elements;
            referenceElement = (PsiJavaCodeReferenceElement)patternElement;
            PsiReferenceParameterList list = referenceElement.getParameterList();
            boolean typeParametersMatched = false;
            if (list != null && (elements = list.getTypeParameterElements()).length > 0) {
                typeParametersMatched = true;
                if (!this.myMatchingVisitor.matchSequentially((PsiElement[])elements, (PsiElement[])(typeParameters == null ? PsiElement.EMPTY_ARRAY : typeParameters))) {
                    return false;
                }
            }
            patternElement = referenceElement.getReferenceNameElement();
            if (typeParametersMatched && matchedElement instanceof PsiJavaCodeReferenceElement) {
                matchedElement = ((PsiJavaCodeReferenceElement)matchedElement).getReferenceNameElement();
            }
        }
        int matchedArrayDimensions = JavaMatchingVisitor.getArrayDimensions(matchedType);
        int patternArrayDimensions = JavaMatchingVisitor.getArrayDimensions(patternType);
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternElement)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(patternElement);
            RegExpPredicate regExpPredicate = null;
            boolean fullTypeResult = false;
            if (patternArrayDimensions != 0) {
                if (patternArrayDimensions != matchedArrayDimensions) {
                    return false;
                }
            } else if (matchedArrayDimensions != 0) {
                regExpPredicate = (RegExpPredicate)handler.findPredicate(RegExpPredicate.class);
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(element -> StructuralSearchUtil.getMeaningfulText((PsiElement)element) + "[]".repeat(matchedArrayDimensions));
                }
                fullTypeResult = true;
            }
            try {
                boolean result;
                boolean bl = result = handler.isSubtype() || handler.isStrictSubtype() ? this.matchWithinHierarchy(patternElement, matchedElement, handler) : handler.validate(matchedElement, this.myMatchingVisitor.getMatchContext());
                if (result) {
                    handler.addResult(fullTypeResult ? matchedType : matchedElement, this.myMatchingVisitor.getMatchContext());
                }
                boolean bl2 = result;
                return bl2;
            }
            finally {
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(null);
                }
            }
        }
        if (matchedArrayDimensions != patternArrayDimensions) {
            return false;
        }
        if (patternElement instanceof PsiIdentifier && (parent = patternElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            patternElement = parent;
        }
        if (matchedElement instanceof PsiIdentifier && (parent = matchedElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            matchedElement = parent;
        }
        if ((equalsIgnorePackage = MatchUtils.compareWithNoDifferenceToPackage((String)(text = JavaMatchingVisitor.getText(patternElement)), (String)(text2 = JavaMatchingVisitor.getText(matchedElement)), (!(caseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch()) ? 1 : 0) != 0)) || !(matchedElement instanceof PsiJavaReference)) {
            return equalsIgnorePackage;
        }
        PsiElement element2 = ((PsiJavaReference)matchedElement).resolve();
        if (!(element2 instanceof PsiClass)) {
            return false;
        }
        String name = ((PsiClass)element2).getQualifiedName();
        return caseSensitive ? text.equals(name) : text.equalsIgnoreCase(name);
    }

    @Contract(pure=true)
    @NotNull
    private static String getText(@NotNull PsiElement element) {
        int index;
        String result;
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(25);
        }
        if (element instanceof PsiClass) {
            result = ((PsiClass)element).getQualifiedName();
            if (result == null) {
                result = element.getText();
            }
        } else {
            PsiTypeElement typeElement;
            result = element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).getCanonicalText() : (element instanceof PsiTypeElement ? ((typeElement = (PsiTypeElement)element).isInferredType() ? typeElement.getText() : typeElement.getType().getCanonicalText()) : element.getText());
        }
        String string = (index = result.indexOf(60)) == -1 ? result : result.substring(0, index);
        if (string == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(26);
        }
        return string;
    }

    private boolean matchWithinHierarchy(@Nullable PsiElement patternElement, PsiElement matchElement, SubstitutionHandler handler) {
        PsiElement psiElement;
        PsiElement patternParent;
        boolean includeInterfaces = true;
        boolean includeClasses = true;
        if (patternElement != null && (patternParent = (patternElement = StructuralSearchUtil.getParentIfIdentifier((PsiElement)patternElement)).getParent()) instanceof PsiReferenceList && (psiElement = patternParent.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            if (patternParent == psiClass.getExtendsList()) {
                includeInterfaces = psiClass.isInterface();
            } else if (patternParent == psiClass.getImplementsList()) {
                includeClasses = false;
            }
        }
        HierarchyNodeIterator nodes = new HierarchyNodeIterator(matchElement, includeClasses, includeInterfaces);
        if (!includeClasses) {
            nodes.advance();
        }
        if (handler.isStrictSubtype()) {
            nodes.advance();
        }
        boolean negated = handler.getPredicate() instanceof NotPredicate;
        while (nodes.hasNext() && negated == handler.validate(nodes.current(), this.myMatchingVisitor.getMatchContext())) {
            nodes.advance();
        }
        return negated != nodes.hasNext();
    }

    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        PsiConditionalExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(27);
        }
        if ((other = this.getExpression(PsiConditionalExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression.getCondition(), (PsiElement)other.getCondition()) && this.myMatchingVisitor.matchSons((PsiElement)expression, (PsiElement)other));
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        PsiPolyadicExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(28);
        }
        if ((other = this.getExpression(PsiPolyadicExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        if (this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(other.getOperationTokenType()))) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression.getOperands(), (PsiElement[])other.getOperands()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitVariable(@NotNull PsiVariable var) {
        block21: {
            block23: {
                block22: {
                    block20: {
                        if (var == null) {
                            JavaMatchingVisitor.$$$reportNull$$$0(29);
                        }
                        other = (PsiVariable)this.myMatchingVisitor.getElement();
                        context = this.myMatchingVisitor.getMatchContext();
                        nameIdentifier = var.getNameIdentifier();
                        isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
                        context.pushResult();
                        try {
                            if (this.myMatchingVisitor.setResult((isTypedVar != false || this.myMatchingVisitor.matchText((PsiElement)nameIdentifier, (PsiElement)other.getNameIdentifier()) != false) && this.myMatchingVisitor.match((PsiElement)var.getModifierList(), (PsiElement)other.getModifierList()) != false)) break block20;
                        }
                        catch (Throwable var12_21) {
                            v0 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                            if (identifier == null && (name = other.getName()) != null) {
                                fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
                                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                            } else {
                                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
                            }
                            throw var12_21;
                        }
                        v1 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                        if (identifier == null && (name = other.getName()) != null) {
                            fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
                            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                        } else {
                            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
                        }
                        return;
                    }
                    typeElement1 = var.getTypeElement();
                    if (typeElement1 == null) break block21;
                    typeElement2 = other.getTypeElement();
                    if (typeElement2 != null) ** GOTO lbl56
                    typeElement2 = JavaPsiFacade.getElementFactory((Project)other.getProject()).createTypeElement(other.getType());
                    matchingHandler = context.getPattern().getHandler((PsiElement)typeElement1);
                    if (!(matchingHandler instanceof SubstitutionHandler)) break block22;
                    ** if (this.myMatchingVisitor.setResult((boolean)this.myMatchingVisitor.matchOptionally((PsiElement)typeElement1, null)) && this.myMatchingVisitor.setResult((boolean)((SubstitutionHandler)matchingHandler).validate((PsiElement)typeElement2, (MatchContext)context))) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        v2 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                        if (identifier == null && (name = other.getName()) != null) {
                            fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
                            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                        } else {
                            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
                        }
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block23;
                    }
                }
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)typeElement1, (PsiElement)typeElement2))) break block23;
                v3 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                if (identifier == null && (name = other.getName()) != null) {
                    fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
                    this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                } else {
                    this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
                }
                return;
            }
            break block21;
lbl56:
            // 1 sources

            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)typeElement1, (PsiElement)typeElement2))) break block21;
            v4 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
            if (identifier == null && (name = other.getName()) != null) {
                fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
            } else {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
            }
            return;
        }
        initializer = var.getInitializer();
        var2Initializer = other.getInitializer();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)initializer, (PsiElement)var2Initializer));
        v5 /* !! */  = identifier = other instanceof PsiReceiverParameter != false ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
        if (identifier == null && (name = other.getName()) != null) {
            fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name);
            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
        } else {
            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
        }
    }

    private void matchArrayOrArguments(@NotNull PsiNewExpression patternExpression, @NotNull PsiNewExpression matchExpression) {
        PsiExpression[] dimensions2;
        PsiExpression[] dimensions1;
        if (patternExpression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(30);
        }
        if (matchExpression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(31);
        }
        PsiType type1 = patternExpression.getType();
        PsiType type2 = matchExpression.getType();
        if (!this.myMatchingVisitor.setResult(type1 != null && type2 != null && type1.getArrayDimensions() == type2.getArrayDimensions())) {
            return;
        }
        PsiArrayInitializerExpression initializer1 = patternExpression.getArrayInitializer();
        PsiArrayInitializerExpression initializer2 = matchExpression.getArrayInitializer();
        if (initializer1 != null) {
            if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)initializer1, (PsiElement)initializer2))) {
                return;
            }
        } else if (initializer2 != null) {
            this.myMatchingVisitor.setResult(JavaMatchingVisitor.areZeroLiterals(patternExpression.getArrayDimensions()) && initializer2.getInitializers().length == 0);
            return;
        }
        if (!this.myMatchingVisitor.setResult((dimensions1 = patternExpression.getArrayDimensions()).length == (dimensions2 = matchExpression.getArrayDimensions()).length)) {
            return;
        }
        if (dimensions1.length != 0) {
            for (int i = 0; i < dimensions1.length; ++i) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)dimensions1[i], (PsiElement)dimensions2[i]))) continue;
                return;
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)patternExpression.getArgumentList(), (PsiElement)matchExpression.getArgumentList()) && this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)patternExpression, (PsiCallExpression)matchExpression)));
        }
    }

    private static boolean areZeroLiterals(PsiExpression @NotNull [] expressions) {
        if (expressions == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(32);
        }
        for (PsiExpression expression : expressions) {
            if (expression instanceof PsiLiteralExpression && expression.getText().equals("0")) continue;
            return false;
        }
        return true;
    }

    private boolean matchImplicitQualifier(@NotNull PsiExpression qualifier, @NotNull PsiElement reference, @NotNull MatchContext context) {
        PsiMethod target;
        if (qualifier == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(33);
        }
        if (reference == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(34);
        }
        if (context == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(35);
        }
        Object object = target = reference instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)reference).resolveMethod() : ((PsiReference)reference).resolve();
        if (target instanceof PsiMember && qualifier instanceof PsiThisExpression) {
            return !((PsiMember)target).hasModifierProperty("static") && (target instanceof PsiField || target instanceof PsiMethod);
        }
        SubstitutionHandler handler = (SubstitutionHandler)ObjectUtils.tryCast((Object)context.getPattern().getHandler((PsiElement)qualifier), SubstitutionHandler.class);
        if (handler == null) {
            return false;
        }
        if (target instanceof PsiModifierListOwner && ((PsiModifierListOwner)target).hasModifierProperty("static")) {
            PsiClass containingClass = target instanceof PsiMember ? ((PsiMember)target).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class);
            return handler.isSubtype() || handler.isStrictSubtype() ? this.matchWithinHierarchy(null, (PsiElement)containingClass, handler) : handler.validate((PsiElement)containingClass, context);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
        PsiExpression implicitReference = factory.createExpressionFromText("this", reference);
        return handler.validate((PsiElement)implicitReference, context);
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        PsiMethodCallExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(36);
        }
        if ((other = this.getExpression(PsiMethodCallExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        PsiReferenceExpression ref1 = expression.getMethodExpression();
        PsiReferenceExpression ref2 = other.getMethodExpression();
        PsiElement patternMethodName = ref1.getReferenceNameElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar(patternMethodName);
        if (!isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(patternMethodName, ref2.getReferenceNameElement()))) {
            return;
        }
        PsiExpression patternQualifier = ref1.getQualifierExpression();
        PsiExpression matchedQualifier = ref2.getQualifierExpression();
        if (!this.myMatchingVisitor.setResult(patternQualifier instanceof PsiThisExpression && matchedQualifier == null || this.myMatchingVisitor.matchOptionally((PsiElement)patternQualifier, (PsiElement)matchedQualifier))) {
            return;
        }
        if (patternQualifier != null && matchedQualifier == null && !this.myMatchingVisitor.setResult(this.matchImplicitQualifier(patternQualifier, (PsiElement)other, context))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expression.getArgumentList(), (PsiElement)other.getArgumentList()))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)expression, (PsiCallExpression)other))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(patternMethodName, ref2.getReferenceNameElement()));
        }
    }

    private boolean matchTypeParameters(@NotNull PsiCallExpression call1, @NotNull PsiCallExpression call2) {
        PsiReferenceParameterList patternParameterList;
        PsiTypeElement[] patternTypeElements;
        if (call1 == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(37);
        }
        if (call2 == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(38);
        }
        if ((patternTypeElements = (patternParameterList = call1.getTypeArgumentList()).getTypeParameterElements()).length == 0) {
            return true;
        }
        PsiReferenceParameterList matchedParameterList = call2.getTypeArgumentList();
        if (matchedParameterList.getFirstChild() == null && this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            JavaResolveResult resolveResult = call2.resolveMethodGenerics();
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return false;
            }
            PsiTypeParameterList typeParameterList = targetMethod.getTypeParameterList();
            if (typeParameterList == null) {
                return false;
            }
            PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            matchedParameterList = (PsiReferenceParameterList)matchedParameterList.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType type = substitutor.substitute(typeParameter);
                if (type == null) {
                    return false;
                }
                PsiTypeElement matchedTypeElement = JavaPsiFacade.getElementFactory((Project)call1.getProject()).createTypeElement(type);
                matchedParameterList.add((PsiElement)matchedTypeElement);
            }
        }
        PsiTypeElement[] matchedTypeElements = matchedParameterList.getTypeParameterElements();
        return this.myMatchingVisitor.matchSequentially((PsiElement[])patternTypeElements, (PsiElement[])matchedTypeElements);
    }

    public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
        PsiElement other;
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(39);
        }
        if (this.myMatchingVisitor.setResult((other = this.myMatchingVisitor.getElement()) instanceof PsiExpressionStatement)) {
            PsiExpressionStatement expr2 = (PsiExpressionStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getExpression(), (PsiElement)expr2.getExpression()));
        }
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        PsiLiteralExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(40);
        }
        if ((other = this.getExpression(PsiLiteralExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        PsiType type1 = expression.getType();
        if (type1 != null && !this.myMatchingVisitor.setResult(type1.equals(other.getType()))) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)expression.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            int offset = 0;
            int length = other.getTextLength();
            String text = other.getText();
            if (StringUtil.isQuotedString((String)text)) {
                --length;
                ++offset;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, offset, length, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)expression, (PsiElement)other, this.myMatchingVisitor.getMatchContext()));
        } else {
            Object value1 = expression.getValue();
            Object value2 = other.getValue();
            if ((value1 instanceof String || value1 instanceof Character) && (value2 instanceof String || value2 instanceof Character)) {
                String patternValue = value1.toString();
                if (!patternValue.isEmpty() && patternValue.equals(patternValue.trim())) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(MatchUtil.normalize((String)patternValue), MatchUtil.normalize((String)value2.toString())));
                } else {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(patternValue, value2.toString()));
                }
            } else if (value1 != null && value2 != null) {
                this.myMatchingVisitor.setResult(value1.equals(value2));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)expression, (PsiElement)other));
            }
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        PsiAssignmentExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(41);
        }
        if ((other = this.getExpression(PsiAssignmentExpression.class, (PsiExpression)expression)) != null) {
            this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression.getLExpression(), (PsiElement)other.getLExpression()) && this.myMatchingVisitor.match((PsiElement)expression.getRExpression(), (PsiElement)other.getRExpression()));
        }
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(42);
        }
        PsiIfStatement other = (PsiIfStatement)this.myMatchingVisitor.getElement();
        PsiStatement elseBranch = statement.getElseBranch();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getThenBranch(), (PsiElement)other.getThenBranch()) && (elseBranch == null || this.matchBody((PsiElement)elseBranch, (PsiElement)other.getElseBranch())));
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(43);
        }
        this.myMatchingVisitor.setResult(this.matchSwitchBlock((PsiSwitchBlock)statement));
    }

    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(44);
        }
        this.myMatchingVisitor.setResult(this.matchSwitchBlock((PsiSwitchBlock)expression));
    }

    private boolean matchSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
        if (switchBlock == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(45);
        }
        PsiSwitchBlock other = (PsiSwitchBlock)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.match((PsiElement)switchBlock.getExpression(), (PsiElement)other.getExpression())) {
            return false;
        }
        PsiCodeBlock body = switchBlock.getBody();
        PsiSwitchLabelStatementBase[] cases1 = (PsiSwitchLabelStatementBase[])PsiTreeUtil.getChildrenOfType((PsiElement)body, PsiSwitchLabelStatementBase.class);
        if (cases1 != null) {
            PsiSwitchLabelStatementBase[] cases2 = (PsiSwitchLabelStatementBase[])PsiTreeUtil.getChildrenOfType((PsiElement)other.getBody(), PsiSwitchLabelStatementBase.class);
            return this.myMatchingVisitor.matchSequentially((PsiElement[])cases1, (PsiElement[])(cases2 != null ? cases2 : PsiElement.EMPTY_ARRAY));
        }
        List statements1 = PsiTreeUtil.getChildrenOfAnyType((PsiElement)body, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
        if (!statements1.isEmpty()) {
            List statements2 = PsiTreeUtil.getChildrenOfAnyType((PsiElement)other.getBody(), (Class[])new Class[]{PsiStatement.class, PsiComment.class});
            return this.myMatchingVisitor.matchSequentially(statements1.toArray(PsiElement.EMPTY_ARRAY), statements2.toArray(PsiElement.EMPTY_ARRAY));
        }
        return true;
    }

    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(46);
        }
        this.myMatchingVisitor.setResult(this.matchLabelStatement((PsiSwitchLabelStatementBase)statement, (PsiSwitchLabelStatementBase)this.myMatchingVisitor.getElement()));
    }

    public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(47);
        }
        this.myMatchingVisitor.setResult(this.matchLabelStatement((PsiSwitchLabelStatementBase)statement, (PsiSwitchLabelStatementBase)this.myMatchingVisitor.getElement()));
    }

    private boolean matchLabelStatement(@NotNull PsiSwitchLabelStatementBase statement1, @NotNull PsiSwitchLabelStatementBase statement2) {
        PsiCaseLabelElement[] caseLabelElements;
        if (statement1 == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(48);
        }
        if (statement2 == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(49);
        }
        PsiCaseLabelElementList labelElementList1 = statement1.getCaseLabelElementList();
        PsiCaseLabelElementList labelElementList2 = statement2.getCaseLabelElementList();
        if (statement1.isDefaultCase() && !statement2.isDefaultCase()) {
            return false;
        }
        if (labelElementList1 == null) {
            return true;
        }
        PsiCaseLabelElement[] psiCaseLabelElementArray = caseLabelElements = labelElementList2 == null ? PsiCaseLabelElement.EMPTY_ARRAY : labelElementList2.getElements();
        if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])labelElementList1.getElements(), (PsiElement[])caseLabelElements)) {
            return false;
        }
        PsiElement[] body = JavaMatchingVisitor.getBody(statement1);
        return body.length == 0 || this.myMatchingVisitor.matchSequentially(body, JavaMatchingVisitor.getBody(statement2));
    }

    private static PsiElement @NotNull [] getBody(@NotNull PsiSwitchLabelStatementBase switchLabelStatement) {
        if (switchLabelStatement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(50);
        }
        SmartList result = new SmartList();
        if (switchLabelStatement instanceof PsiSwitchLabeledRuleStatement) {
            PsiStatement body = ((PsiSwitchLabeledRuleStatement)switchLabelStatement).getBody();
            if (body instanceof PsiBlockStatement) {
                result.addAll(PsiTreeUtil.getChildrenOfAnyType((PsiElement)((PsiBlockStatement)body).getCodeBlock(), (Class[])new Class[]{PsiStatement.class, PsiComment.class}));
            } else {
                result.add(body);
            }
        } else {
            for (PsiElement sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)switchLabelStatement, PsiStatement.class); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getNextSibling()) {
                if (!(sibling instanceof PsiStatement) && !(sibling instanceof PsiComment)) continue;
                result.add(sibling);
            }
        }
        PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(51);
        }
        return psiElementArray;
    }

    public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(52);
        }
        PsiYieldStatement other = (PsiYieldStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getExpression(), (PsiElement)other.getExpression()));
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(53);
        }
        PsiForStatement other = (PsiForStatement)this.myMatchingVisitor.getElement();
        PsiStatement initialization = statement.getInitialization();
        if (!this.myMatchingVisitor.setResult(initialization == null || initialization instanceof PsiEmptyStatement ? this.myMatchingVisitor.isLeftLooseMatching() : this.myMatchingVisitor.matchSequentially(JavaMatchingVisitor.getIterator(initialization), JavaMatchingVisitor.getIterator(other.getInitialization())))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()))) {
            return;
        }
        PsiStatement update = statement.getUpdate();
        if (!this.myMatchingVisitor.setResult(update == null ? this.myMatchingVisitor.isLeftLooseMatching() : this.myMatchingVisitor.matchSequentially(JavaMatchingVisitor.getIterator(update), JavaMatchingVisitor.getIterator(other.getUpdate())))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    private static NodeIterator getIterator(PsiStatement statement) {
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
            return new ArrayBackedNodeIterator((PsiElement[])expressionListStatement.getExpressionList().getExpressions());
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            return SingleNodeIterator.create((PsiElement)expressionStatement.getExpression());
        }
        if (statement instanceof PsiEmptyStatement) {
            return SingleNodeIterator.EMPTY;
        }
        return SingleNodeIterator.create((PsiElement)statement);
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(54);
        }
        PsiForeachStatement other = (PsiForeachStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getIterationParameter(), (PsiElement)other.getIterationParameter()) && this.myMatchingVisitor.match((PsiElement)statement.getIteratedValue(), (PsiElement)other.getIteratedValue()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(55);
        }
        PsiWhileStatement other = (PsiWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
        PsiElement other;
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(56);
        }
        if ((other = this.myMatchingVisitor.getElement()) instanceof PsiCodeBlock) {
            this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiBlockStatement) && this.myMatchingVisitor.matchSons((PsiElement)statement.getCodeBlock(), other));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)statement, other));
        }
    }

    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(57);
        }
        PsiDeclarationStatement other = (PsiDeclarationStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(statement.getDeclaredElements(), other.getDeclaredElements()));
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(58);
        }
        PsiDoWhileStatement other = (PsiDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(59);
        }
        PsiReturnStatement other = (PsiReturnStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getReturnValue(), (PsiElement)other.getReturnValue()));
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        PsiPostfixExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(60);
        }
        if ((other = this.getExpression(PsiPostfixExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression.getOperand(), (PsiElement)other.getOperand()));
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        PsiPrefixExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(61);
        }
        if ((other = this.getExpression(PsiPrefixExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression.getOperand(), (PsiElement)other.getOperand()));
    }

    public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(62);
        }
        PsiAssertStatement other = (PsiAssertStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getAssertCondition(), (PsiElement)other.getAssertCondition()) && this.myMatchingVisitor.matchOptionally((PsiElement)statement.getAssertDescription(), (PsiElement)other.getAssertDescription()));
    }

    public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(63);
        }
        PsiBreakStatement other = (PsiBreakStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getLabelIdentifier(), (PsiElement)other.getLabelIdentifier()));
    }

    public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(64);
        }
        PsiContinueStatement other = (PsiContinueStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getLabelIdentifier(), (PsiElement)other.getLabelIdentifier()));
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(65);
        }
        this.getExpression(PsiSuperExpression.class, (PsiExpression)expression);
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(66);
        }
        this.getExpression(PsiThisExpression.class, (PsiExpression)expression);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(67);
        }
        PsiSynchronizedStatement other = (PsiSynchronizedStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getLockExpression(), (PsiElement)other.getLockExpression()) && this.myMatchingVisitor.matchSons((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(68);
        }
        PsiThrowStatement other = (PsiThrowStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getException(), (PsiElement)other.getException()));
    }

    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        PsiElement other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(69);
        }
        if (this.myMatchingVisitor.setResult((other = this.myMatchingVisitor.getElement()) instanceof PsiParenthesizedExpression)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expression, other));
        }
    }

    public void visitCatchSection(@NotNull PsiCatchSection section) {
        if (section == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(70);
        }
        PsiCatchSection other = (PsiCatchSection)this.myMatchingVisitor.getElement();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)section);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)section.getParameter(), (PsiElement)other.getParameter()) && this.myMatchingVisitor.matchSons((PsiElement)section.getCatchBlock(), (PsiElement)other.getCatchBlock()) && ((SubstitutionHandler)handler).handle((PsiElement)other, this.myMatchingVisitor.getMatchContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(71);
        }
        PsiTryStatement other = (PsiTryStatement)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)statement.getTryBlock(), (PsiElement)other.getTryBlock()))) {
            return;
        }
        PsiResourceList resourceList1 = statement.getResourceList();
        PsiCatchSection[] catches1 = statement.getCatchSections();
        PsiCodeBlock finally1 = statement.getFinallyBlock();
        PsiResourceList resourceList2 = other.getResourceList();
        Object[] catches2 = other.getCatchSections();
        PsiCodeBlock finally2 = other.getFinallyBlock();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        if (this.myMatchingVisitor.setResult(!(!context.getOptions().isLooseMatching() && (catches1.length == 0 && catches2.length != 0 || finally1 == null && finally2 != null || resourceList1 == null && resourceList2 != null)))) {
            SmartList unmatchedElements = new SmartList();
            if (resourceList1 != null) {
                List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
                List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(resources1.toArray(PsiElement.EMPTY_ARRAY), resources2.toArray(PsiElement.EMPTY_ARRAY)))) {
                    return;
                }
            } else if (resourceList2 != null) {
                unmatchedElements.add(resourceList2);
            }
            ContainerUtil.addAll((Collection)unmatchedElements, (Object[])catches2);
            context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitTryStatement$5((List)unmatchedElements, arg_0));
            try {
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])catches1, (PsiElement[])catches2))) {
                    return;
                }
            }
            finally {
                context.popMatchedElementsListener();
            }
            if (finally1 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)finally1, (PsiElement)finally2));
            } else if (finally2 != null) {
                unmatchedElements.add(finally2);
            }
            if (this.myMatchingVisitor.getResult()) {
                other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
    }

    public void visitResourceExpression(@NotNull PsiResourceExpression expression) {
        PsiElement other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(72);
        }
        this.myMatchingVisitor.setResult((other = this.myMatchingVisitor.getElement()) instanceof PsiResourceExpression && this.myMatchingVisitor.match((PsiElement)expression.getExpression(), (PsiElement)((PsiResourceExpression)other).getExpression()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(73);
        }
        PsiLabeledStatement other = (PsiLabeledStatement)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = statement.getLabelIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)identifier);
        context.pushResult();
        try {
            this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier, other.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)statement.getStatement(), (PsiElement)other.getStatement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)identifier, isTypedVar, other.getNameIdentifier());
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        PsiTypeElement otherType;
        PsiInstanceOfExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(74);
        }
        if ((other = this.getExpression(PsiInstanceOfExpression.class, (PsiExpression)expression)) == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression.getOperand(), (PsiElement)other.getOperand()))) {
            return;
        }
        PsiTypeElement expressionType = InstanceOfUtils.findCheckTypeElement((PsiInstanceOfExpression)expression);
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expressionType, (PsiElement)(otherType = InstanceOfUtils.findCheckTypeElement((PsiInstanceOfExpression)other))))) {
            return;
        }
        PsiPrimaryPattern pattern = expression.getPattern();
        PsiPrimaryPattern otherPattern = other.getPattern();
        if (pattern instanceof PsiTypeTestPattern) {
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)pattern;
            if (otherPattern instanceof PsiTypeTestPattern) {
                PsiTypeTestPattern otherVariable = (PsiTypeTestPattern)otherPattern;
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)typeTestPattern.getPatternVariable(), (PsiElement)otherVariable.getPatternVariable()));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)typeTestPattern.getPatternVariable()));
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)pattern, (PsiElement)otherPattern));
        }
    }

    public void visitTypeTestPattern(@NotNull PsiTypeTestPattern pattern) {
        if (pattern == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(75);
        }
        PsiTypeTestPattern other = (PsiTypeTestPattern)this.myMatchingVisitor.getElement(PsiTypeTestPattern.class);
        PsiPatternVariable variable = pattern.getPatternVariable();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)variable, (PsiElement)other.getPatternVariable()));
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(76);
        }
        PsiExpression other = this.getExpression(PsiExpression.class, (PsiExpression)expression);
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        if (other instanceof PsiArrayInitializerExpression && other.getParent() instanceof PsiVariable && JavaMatchingVisitor.areZeroLiterals(expression.getArrayDimensions())) {
            MatchingHandler handler;
            MatchContext matchContext = this.myMatchingVisitor.getMatchContext();
            CompiledPattern pattern = matchContext.getPattern();
            boolean isTypedVar = pattern.isTypedVar((PsiElement)classReference);
            if (isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, null))) {
                return;
            }
            PsiType otherType = other.getType();
            if (classReference != null && (handler = pattern.getHandler((PsiElement)classReference)) instanceof SubstitutionHandler && otherType != null) {
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                MatchPredicate predicate = substitutionHandler.getPredicate();
                if (predicate != null) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                    PsiTypeElement otherTypeElement = factory.createTypeElement(otherType.getDeepComponentType());
                    this.myMatchingVisitor.setResult(predicate.match((PsiElement)otherTypeElement, matchContext));
                }
            } else {
                PsiType type = expression.getType();
                this.myMatchingVisitor.setResult(type != null && type.equals(otherType));
            }
            if (this.myMatchingVisitor.getResult()) {
                PsiArrayInitializerExpression initializer = expression.getArrayInitializer();
                if (initializer != null) {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)initializer, (PsiElement)other));
                } else {
                    this.myMatchingVisitor.setResult(((PsiArrayInitializerExpression)other).getInitializers().length == 0);
                }
            }
            return;
        }
        if (!this.myMatchingVisitor.setResult(other instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression new2 = (PsiNewExpression)other;
        PsiJavaCodeReferenceElement otherClassReference = new2.getClassReference();
        if (classReference != null) {
            if (otherClassReference != null) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, (PsiElement)otherClassReference))) {
                    this.matchArrayOrArguments(expression, new2);
                }
                return;
            }
            PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)new2, PsiKeyword.class);
            PsiKeyword typeKeyword = (PsiKeyword)PsiTreeUtil.getNextSiblingOfType((PsiElement)newKeyword, PsiKeyword.class);
            if (typeKeyword != null) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, (PsiElement)typeKeyword))) {
                    this.matchArrayOrArguments(expression, new2);
                }
                return;
            }
        }
        PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
        if (classReference == otherClassReference) {
            if (anonymousClass != null) {
                this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)expression, (PsiCallExpression)new2) && this.myMatchingVisitor.matchSons((PsiElement)expression.getArgumentList(), (PsiElement)new2.getArgumentList()) && this.myMatchingVisitor.match((PsiElement)anonymousClass, (PsiElement)new2.getAnonymousClass()));
            } else {
                PsiType type1 = expression.getType();
                PsiType type2 = new2.getType();
                if (this.myMatchingVisitor.setResult(type1 != null && type2 != null && type1.getDeepComponentType() == type2.getDeepComponentType())) {
                    this.matchArrayOrArguments(expression, new2);
                }
            }
        } else if (anonymousClass == null && classReference != null && new2.getAnonymousClass() != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getAnonymousClass().getBaseClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)expression.getArgumentList(), (PsiElement)new2.getArgumentList()) && this.matchTypeParameters((PsiCallExpression)expression, (PsiCallExpression)new2));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitKeyword(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(77);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)keyword, this.myMatchingVisitor.getElement()));
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        PsiTypeCastExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(78);
        }
        if ((other = this.getExpression(PsiTypeCastExpression.class, (PsiExpression)expression)) != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression.getCastType(), (PsiElement)other.getCastType()) && this.myMatchingVisitor.match((PsiElement)expression.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        PsiClassObjectAccessExpression other;
        if (expression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(79);
        }
        if ((other = this.getExpression(PsiClassObjectAccessExpression.class, (PsiExpression)expression)) != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement other;
        if (ref == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(80);
        }
        this.myMatchingVisitor.setResult(this.matchAnnotations((PsiElement)ref, other = this.myMatchingVisitor.getElement()) && this.matchType((PsiElement)ref, other));
    }

    public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
        PsiElement other;
        if (typeElement == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(81);
        }
        if (!this.myMatchingVisitor.setResult(this.matchAnnotations((PsiElement)typeElement, other = this.myMatchingVisitor.getElement()))) {
            return;
        }
        PsiTypeElement[] typeElementChildren = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
        if (typeElementChildren != null && typeElementChildren.length > 1) {
            PsiTypeElement[] typeElementChildren2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiTypeElement.class);
            this.myMatchingVisitor.setResult(typeElementChildren2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])typeElementChildren, (PsiElement[])typeElementChildren2));
        } else {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)typeElement, other));
        }
    }

    private boolean matchAnnotations(@NotNull PsiElement pattern, PsiElement matched) {
        PsiAnnotation[] annotations;
        if (pattern == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(82);
        }
        if ((annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)pattern, PsiAnnotation.class)) == null) {
            return true;
        }
        PsiAnnotation[] otherAnnotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)matched, PsiAnnotation.class);
        return otherAnnotations != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])otherAnnotations);
    }

    public void visitTypeParameter(@NotNull PsiTypeParameter parameter) {
        if (parameter == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(83);
        }
        PsiTypeParameter other = (PsiTypeParameter)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = parameter.getNameIdentifier();
        assert (identifier != null);
        PsiIdentifier identifier2 = other.getNameIdentifier();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier);
        if (handler instanceof SubstitutionHandler ? !this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)identifier2, this.myMatchingVisitor.getMatchContext())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)identifier2))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchInAnyOrder(parameter.getExtendsList(), other.getExtendsList()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])parameter.getAnnotations(), (PsiElement[])other.getAnnotations()));
    }

    public void visitClass(@NotNull PsiClass clazz) {
        PsiClass other;
        if (clazz == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(84);
        }
        if ((other = (PsiClass)this.myMatchingVisitor.getElement(PsiClass.class)) == null) {
            return;
        }
        if (clazz.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)clazz.getTypeParameterList(), (PsiElement)other.getTypeParameterList()))) {
            return;
        }
        PsiDocComment comment = clazz.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other.getDocComment()))) {
            return;
        }
        PsiIdentifier identifier1 = clazz.getNameIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        boolean isTypedVar = pattern.isTypedVar((PsiElement)identifier1);
        PsiModifierList modifierList = clazz.getModifierList();
        if (modifierList != null && modifierList.getTextLength() > 0 && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)modifierList, (PsiElement)other.getModifierList()))) {
            return;
        }
        PsiIdentifier identifier2 = other.getNameIdentifier();
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier1, (PsiElement)identifier2)) && this.matchClasses(clazz, other)) && isTypedVar) {
            PsiIdentifier result;
            PsiClass matchElement = identifier2 == null ? other : identifier2;
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler((PsiElement)identifier1);
            Object object = result = other instanceof PsiAnonymousClass ? ((PsiAnonymousClass)other).getBaseClassReference().getReferenceNameElement() : identifier2;
            if (handler.isSubtype() || handler.isStrictSubtype()) {
                if (this.myMatchingVisitor.setResult(this.matchWithinHierarchy((PsiElement)identifier1, (PsiElement)other, handler))) {
                    handler.addResult((PsiElement)(result == null ? other : result), context);
                }
            } else if (this.myMatchingVisitor.setResult(handler.validate((PsiElement)matchElement, context))) {
                handler.addResult((PsiElement)(result == null ? other : result), context);
            }
        }
    }

    public void visitTypeParameterList(@NotNull PsiTypeParameterList psiTypeParameterList) {
        if (psiTypeParameterList == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(85);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(psiTypeParameterList.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(86);
        }
        PsiIdentifier methodNameNode = method.getNameIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)methodNameNode);
        PsiMethod other = (PsiMethod)this.myMatchingVisitor.getElement(PsiMethod.class);
        if (other == null) {
            return;
        }
        context.pushResult();
        try {
            PsiElement docComment = method.getFirstChild();
            if (docComment instanceof PsiComment && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(docComment, other.getFirstChild()))) {
                return;
            }
            if (method.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)method.getTypeParameterList(), (PsiElement)other.getTypeParameterList()))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)method))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(!(method.isConstructor() && !other.isConstructor() || !isTypedVar && !this.myMatchingVisitor.matchText((PsiElement)methodNameNode, (PsiElement)other.getNameIdentifier()) || !this.myMatchingVisitor.match((PsiElement)method.getModifierList(), (PsiElement)other.getModifierList())))) {
                return;
            }
            PsiParameterList otherParameterList = other.getParameterList();
            PsiReceiverParameter receiverParameter = (PsiReceiverParameter)PsiTreeUtil.findChildOfType((PsiElement)otherParameterList, PsiReceiverParameter.class);
            if (receiverParameter != null) {
                SubstitutionHandler substHandler;
                MatchingHandler handler;
                PsiParameterList parameterList = method.getParameterList();
                PsiVariable firstParameter = (PsiVariable)PsiTreeUtil.findChildOfType((PsiElement)parameterList, PsiVariable.class);
                if (firstParameter != null && (handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)firstParameter)) instanceof SubstitutionHandler && (substHandler = (SubstitutionHandler)handler).handle((PsiElement)receiverParameter, context) && !this.myMatchingVisitor.setResult(substHandler.getMaxOccurs() != 0)) {
                    return;
                }
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)otherParameterList) || this.myMatchingVisitor.matchSequentially(parameterList.getFirstChild(), receiverParameter.getNextSibling()))) {
                    return;
                }
            } else if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)otherParameterList))) {
                return;
            }
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)method.getReturnTypeElement(), (PsiElement)other.getReturnTypeElement()) && this.matchInAnyOrder(method.getThrowsList(), other.getThrowsList()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)method.getBody(), (PsiElement)other.getBody()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)methodNameNode, isTypedVar, (PsiElement)other.getNameIdentifier());
        }
    }

    @Nullable
    private <T extends PsiExpression> T getExpression(@NotNull Class<T> aClass, @NotNull PsiExpression patternExpression) {
        if (aClass == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(87);
        }
        if (patternExpression == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(88);
        }
        PsiExpression expression = (PsiExpression)this.myMatchingVisitor.getElement(PsiExpression.class);
        if (!(patternExpression.getParent() instanceof PsiExpressionStatement)) {
            expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        }
        return (T)(this.myMatchingVisitor.setResult(aClass.isInstance(expression)) ? (PsiExpression)aClass.cast(expression) : null);
    }

    private static /* synthetic */ void lambda$visitTryStatement$5(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    private static /* synthetic */ void lambda$visitAnnotation$2(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    private static /* synthetic */ void lambda$visitModifierList$1(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    static {
        Arrays.sort(MODIFIERS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 26, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 44: 
            case 60: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 13: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHeader";
                break;
            }
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 21: 
            case 26: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/JavaMatchingVisitor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 30: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternExpression";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call1";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call2";
                break;
            }
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchLabelStatement";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 75: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeParameterList";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/JavaMatchingVisitor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnermostComponentTypeElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitModifierList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitDocTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitDocComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayInitializerExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeBlock";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitJavaToken";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitNameValuePair";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitAnonymousClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordHeader";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodReferenceExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInnermostComponentTypeElement";
                break;
            }
            case 21: 
            case 26: 
            case 51: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplaceDiamondWithExplicitTypes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadicExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitVariable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "matchArrayOrArguments";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "areZeroLiterals";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "matchImplicitQualifier";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCallExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeParameters";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitLiteralExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "matchSwitchBlock";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabelStatement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabeledRuleStatement";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "matchLabelStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getBody";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitYieldStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitForeachStatement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockStatement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclarationStatement";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileStatement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitSynchronizedStatement";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitCatchSection";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceExpression";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceOfExpression";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeTestPattern";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "visitKeyword";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeCastExpression";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeElement";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "matchAnnotations";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameter";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameterList";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 26, 51 -> new IllegalStateException(string);
        };
    }
}

