/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompressedIntList
implements IntList {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    private final int myBlockSize;
    private final int @NotNull [] myStrongValues;
    @NotNull
    private final IntList myCompressedDeltas;

    @NotNull
    public static IntList newInstance(int[] delegateArray) {
        return CompressedIntList.newInstance(delegateArray, 30);
    }

    @NotNull
    public static IntList newInstance(final int[] delegateArray, int blockSize) {
        return CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateArray.length;
            }

            @Override
            public int get(int index) {
                return delegateArray[index];
            }
        }, blockSize);
    }

    @NotNull
    public static IntList newInstance(final @NotNull List<Integer> delegateList) {
        if (delegateList == null) {
            CompressedIntList.$$$reportNull$$$0(0);
        }
        return CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateList.size();
            }

            @Override
            public int get(int index) {
                return (Integer)delegateList.get(index);
            }
        }, 30);
    }

    @NotNull
    public static IntList newInstance(final IntList delegateList, final int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("Unsupported blockSize:" + blockSize);
        }
        if (delegateList.size() == 0) {
            return new FullIntList(new int[0]);
        }
        SmartDeltaCompressor intDeltaCompressor = SmartDeltaCompressor.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateList.size();
            }

            @Override
            public int get(int index) {
                return delegateList.get(index) - delegateList.get(index - index % blockSize);
            }
        });
        int[] strongValues = new int[(delegateList.size() - 1) / blockSize + 1];
        for (int i = 0; i < strongValues.length; ++i) {
            strongValues[i] = delegateList.get(i * blockSize);
        }
        return new CompressedIntList(blockSize, strongValues, intDeltaCompressor);
    }

    private CompressedIntList(int blockSize, int @NotNull [] strongValues, @NotNull IntList compressedDeltas) {
        if (compressedDeltas == null) {
            CompressedIntList.$$$reportNull$$$0(1);
        }
        if (strongValues == null) {
            CompressedIntList.$$$reportNull$$$0(2);
        }
        this.myBlockSize = blockSize;
        this.myStrongValues = strongValues;
        this.myCompressedDeltas = compressedDeltas;
    }

    @Override
    public int size() {
        return this.myCompressedDeltas.size();
    }

    @Override
    public int get(int index) {
        int strongIndex = index / this.myBlockSize;
        return this.myStrongValues[strongIndex] + this.myCompressedDeltas.get(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressedDeltas";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strongValues";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/CompressedIntList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

