/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;

public class JceTlsMLKem
implements TlsAgreement {
    protected final JceTlsMLKemDomain domain;
    protected KyberPrivateKeyParameters privateKey;
    protected KyberPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public JceTlsMLKem(JceTlsMLKemDomain jceTlsMLKemDomain) {
        this.domain = jceTlsMLKemDomain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation secretWithEncapsulation = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(secretWithEncapsulation.getSecret());
            return secretWithEncapsulation.getEncapsulation();
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.domain.generateKeyPair();
        this.privateKey = (KyberPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return this.domain.encodePublicKey((KyberPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(byArray);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, byArray);
            this.privateKey = null;
        }
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret tlsSecret = this.secret;
        this.secret = null;
        return tlsSecret;
    }
}

