/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Objects;
import org.openstreetmap.josm.gui.draw.SymbolShape;

public class Symbol {
    private final SymbolShape symbolShape;
    public final int size;
    public final Stroke stroke;
    public final Color strokeColor;
    public final Color fillColor;

    public Symbol(SymbolShape symbol, int size, Stroke stroke, Color strokeColor, Color fillColor) {
        if (stroke != null && strokeColor == null) {
            throw new IllegalArgumentException("Stroke given without color");
        }
        if (stroke == null && fillColor == null) {
            throw new IllegalArgumentException("Either a stroke or a fill color must be given");
        }
        this.symbolShape = symbol;
        this.size = size;
        this.stroke = stroke;
        this.strokeColor = strokeColor;
        this.fillColor = fillColor;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        return this.symbolShape == other.symbolShape && this.size == other.size && Objects.equals(this.stroke, other.stroke) && Objects.equals(this.strokeColor, other.strokeColor) && Objects.equals(this.fillColor, other.fillColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbolShape, this.size, this.stroke, this.strokeColor, this.fillColor});
    }

    public String toString() {
        return "symbolShape=" + (Object)((Object)this.symbolShape) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
    }

    public Shape buildShapeAround(double x, double y) {
        return this.symbolShape.shapeAround(x, y, this.size);
    }
}

