"use strict";

require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));

// address issue: https://github.com/opensearch-project/anomaly-detection-dashboards-plugin/issues/832
jest.mock('@osd/monaco', () => ({}));

//for mocking window.scroll(0,0)
const noop = () => {};
Object.defineProperty(window, 'scroll', {
  value: noop,
  writable: true
});

// for Plotly
//@ts-ignore
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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