"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addThreatIntelMethods = addThreatIntelMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addThreatIntelMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.ADD_THREAT_INTEL_SOURCE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_THREAT_INTEL_SOURCE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources/<%=sourceId%>`,
      req: {
        sourceId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_THREAT_INTEL_SOURCES] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_THREAT_INTEL_SOURCE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources/<%=sourceId%>`,
      req: {
        sourceId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_THREAT_INTEL_MONITOR] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/monitors`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_THREAT_INTEL_MONITOR] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/monitors/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_THREAT_INTEL_MONITORS] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/monitors/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_THREAT_INTEL_IOCS] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/iocs`,
      // fmt: '/_plugins/_security_analytics/iocs/list',
      params: {
        startIndex: {
          type: 'number'
        },
        size: {
          type: 'number'
        },
        feed_ids: {
          type: 'string'
        },
        ioc_types: {
          type: 'string'
        },
        searchString: {
          type: 'string'
        },
        sortString: {
          type: 'string'
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_THREAT_INTEL_SOURCE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources/<%=sourceId%>`,
      req: {
        sourceId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
  securityAnalytics[_constants.METHOD_NAMES.REFRESH_THREAT_INTEL_SOURCE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/sources/<%=sourceId%>/_refresh`,
      req: {
        sourceId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_THREAT_INTEL_MONITOR] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/monitors/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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