/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\f\u0001B\u0001B\u0003%A\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003U\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001da\u0007A1A\u0005\n5Da!\u001e\u0001!\u0002\u0013q\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003y\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\b\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0016\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002Z\u0001!\t!a\u0017\b\u0013\u0005uS$!A\t\u0002\u0005}c\u0001\u0003\u000f\u001e\u0003\u0003E\t!!\u0019\t\r\u0005LB\u0011AA2\u0011%\t)'GI\u0001\n\u0003\t9GA\fLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fU8pY*\u0011adH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017 \u0003\u0015)H/\u001b7t\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012!\r\t\u0003IIJ!aM\u0013\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005q!/Z9vKN$8\t[1o]\u0016dW#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iz\u0012a\u00028fi^|'o[\u0005\u0003ye\u0012aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003\u0011\t\u0007/[:\u0016\u0003\u0001\u0003\"!\u0011\"\u000e\u0003uI!aQ\u000f\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'/A\u0003ba&\u001c\b%\u0001\u0003uS6,\u0007CA$Q\u001b\u0005A%B\u0001\u0017J\u0015\tQ5*\u0001\u0004d_6lwN\u001c\u0006\u0003A1S!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO&\u0011\u0011\u000b\u0013\u0002\u0005)&lW-\u0001\u0006ok6$\u0006N]3bIN\fqD]3rk\u0016\u001cH\u000fS1oI2,'/\u0011<h\u0013\u0012dW-T3ue&\u001cg*Y7f!\t)FL\u0004\u0002W5B\u0011q+J\u0007\u00021*\u0011\u0011,I\u0001\u0007yI|w\u000e\u001e \n\u0005m+\u0013A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\u0013\u0002-1|w-\u00118e)\"\u0014X-\u00193OC6,\u0007K]3gSb\f\u0001B\\8eK:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013\r$WMZ4iS*\\\u0007CA!\u0001\u0011\u0015yC\u00021\u00012\u0011\u0015)D\u00021\u00018\u0011\u0015qD\u00021\u0001A\u0011\u0015)E\u00021\u0001G\u0011\u0015\u0011F\u00021\u00012\u0011\u0015\u0019F\u00021\u0001U\u0011\u0015yF\u00021\u0001U\u0011\u001d\u0001G\u0002%AA\u0002Q\u000bA\"\\3ue&\u001c7o\u0012:pkB,\u0012A\u001c\t\u0003_Nl\u0011\u0001\u001d\u0006\u0003cJ\fq!\\3ue&\u001c7O\u0003\u0002\u001f\u0017&\u0011A\u000f\u001d\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%\u0001\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3\u0016\u0003a\u00042!_A\u0003\u001b\u0005Q(BA>}\u0003\u0019\tGo\\7jG*\u0011QP`\u0001\u000bG>t7-\u001e:sK:$(bA@\u0002\u0002\u0005!Q\u000f^5m\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004u\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fq\u0002\u001e5sK\u0006$\u0007k\\8m'&TX\rI\u0001\u0013C\u001e<'/Z4bi\u0016LE\r\\3NKR,'/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\u0011\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001B2pe\u0016T1!]A\r\u0015\u0011\tY\"!\b\u0002\re\fW.\\3s\u0015\t\ty\"A\u0002d_6LA!a\t\u0002\u0014\t)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005I!/\u001e8oC\ndWm]\u000b\u0003\u0003W\u0001b!!\f\u00028\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\u000f5,H/\u00192mK*\u0019\u0011QG\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0005=\"aC!se\u0006L()\u001e4gKJ\u00042!QA\u001f\u0013\r\ty$\b\u0002\u0014\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u000beVtg.\u00192mKN\u0004\u0013!D2sK\u0006$X\rS1oI2,'\u000f\u0006\u0003\u0002H\u00055\u0003c\u0001\u0013\u0002J%\u0019\u00111J\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001f*\u0002\u0019A\u0019\u0002\u0005%$\u0017\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\t9%!\u0016\t\r\u0005]c\u00031\u00012\u0003\u001dqWm^*ju\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u000f\nqcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u0011\u0005\u0005K2CA\r$)\t\ty&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003SR3\u0001VA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<K\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class KafkaRequestHandlerPool
implements Logging {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final String nodeName;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$8() {
        return "broker";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time, this.nodeName));
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString();
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, String nodeName) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.nodeName = nodeName;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.metricsGroup().newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

