/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.core.SolrPrometheusCoreFormatter;
import org.apache.solr.metrics.prometheus.jetty.SolrPrometheusJettyFormatter;
import org.apache.solr.metrics.prometheus.jvm.SolrPrometheusJvmFormatter;
import org.apache.solr.metrics.prometheus.node.SolrPrometheusNodeFormatter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.RawResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusResponseWriter
extends RawResponseWriter {
    private static final String CONTENT_TYPE_PROMETHEUS = "text/plain; version=0.0.4";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        NamedList prometheusRegistries = (NamedList)response.getValues().get("metrics");
        PrometheusTextFormatWriter prometheusTextFormatWriter = new PrometheusTextFormatWriter(false);
        for (Map.Entry prometheusRegistry : prometheusRegistries) {
            SolrPrometheusFormatter prometheusFormatter = (SolrPrometheusFormatter)prometheusRegistry.getValue();
            prometheusTextFormatWriter.write(out, prometheusFormatter.collect());
        }
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return CONTENT_TYPE_PROMETHEUS;
    }

    public static void toPrometheus(MetricRegistry registry, String registryName, List<MetricFilter> shouldMatchFilters, MetricFilter mustMatchFilter, Predicate<CharSequence> propertyFilter, boolean skipHistograms, boolean skipAggregateValues, boolean compact, Consumer<SolrPrometheusFormatter> consumer) {
        Map dropwizardMetrics = registry.getMetrics();
        SolrPrometheusFormatter formatter = PrometheusResponseWriter.getFormatterType(registryName);
        if (formatter == null) {
            return;
        }
        MetricUtils.toMaps(registry, shouldMatchFilters, mustMatchFilter, propertyFilter, skipHistograms, skipAggregateValues, compact, false, (metricName, metric) -> {
            try {
                Metric dropwizardMetric = (Metric)dropwizardMetrics.get(metricName);
                formatter.exportDropwizardMetric(dropwizardMetric, (String)metricName);
            }
            catch (Exception e) {
                log.warn("Error occurred exporting Dropwizard Metric to Prometheus", (Throwable)e);
            }
        });
        consumer.accept(formatter);
    }

    public static SolrPrometheusFormatter getFormatterType(String registryName) {
        boolean cloudMode = false;
        String[] parsedRegistry = registryName.split("\\.");
        switch (parsedRegistry[1]) {
            case "core": {
                String coreName;
                if (parsedRegistry.length == 3) {
                    coreName = parsedRegistry[2];
                } else if (parsedRegistry.length == 5) {
                    coreName = Arrays.stream(parsedRegistry).skip(1L).collect(Collectors.joining("_"));
                    cloudMode = true;
                } else {
                    coreName = registryName;
                }
                return new SolrPrometheusCoreFormatter(coreName, cloudMode);
            }
            case "jvm": {
                return new SolrPrometheusJvmFormatter();
            }
            case "jetty": {
                return new SolrPrometheusJettyFormatter();
            }
            case "node": {
                return new SolrPrometheusNodeFormatter();
            }
        }
        return null;
    }
}

