/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.DocumentValueSourceDictionary;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.DictionaryFactory;

public class DocumentExpressionDictionaryFactory
extends DictionaryFactory {
    public static final String FIELD = "field";
    public static final String PAYLOAD_FIELD = "payloadField";
    public static final String WEIGHT_EXPRESSION = "weightExpression";
    public static final String SORT_FIELD = "sortField";

    @Override
    public Dictionary create(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        if (this.params == null) {
            throw new IllegalStateException("Value of params not set");
        }
        String field = (String)this.params.get(FIELD);
        String payloadField = (String)this.params.get(PAYLOAD_FIELD);
        String weightExpression = (String)this.params.get(WEIGHT_EXPRESSION);
        HashSet<SortField> sortFields = new HashSet<SortField>();
        if (field == null) {
            throw new IllegalArgumentException("field is a mandatory parameter");
        }
        if (weightExpression == null) {
            throw new IllegalArgumentException("weightExpression is a mandatory parameter");
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (!this.params.getName(i).equals(SORT_FIELD)) continue;
            String sortFieldName = (String)this.params.getVal(i);
            sortFields.add(this.getSortField(core, sortFieldName));
        }
        return new DocumentValueSourceDictionary((IndexReader)searcher.getIndexReader(), field, this.fromExpression(weightExpression, sortFields), payloadField);
    }

    public LongValuesSource fromExpression(String weightExpression, Set<SortField> sortFields) {
        Expression expression = null;
        try {
            expression = JavascriptCompiler.compile((String)weightExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SimpleBindings bindings = new SimpleBindings();
        for (SortField sortField : sortFields) {
            bindings.add(sortField.getField(), this.fromSortField(sortField));
        }
        return expression.getDoubleValuesSource((Bindings)bindings).toLongValuesSource();
    }

    private DoubleValuesSource fromSortField(SortField field) {
        switch (field.getType()) {
            case INT: {
                return DoubleValuesSource.fromIntField((String)field.getField());
            }
            case LONG: {
                return DoubleValuesSource.fromLongField((String)field.getField());
            }
            case FLOAT: {
                return DoubleValuesSource.fromFloatField((String)field.getField());
            }
            case DOUBLE: {
                return DoubleValuesSource.fromDoubleField((String)field.getField());
            }
            case SCORE: {
                return DoubleValuesSource.SCORES;
            }
        }
        throw new UnsupportedOperationException();
    }

    private SortField getSortField(SolrCore core, String sortFieldName) {
        return core.getLatestSchema().getField(sortFieldName).getSortField(true);
    }
}

