/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

public abstract class ConfigSetAdminRequest<Q extends ConfigSetAdminRequest<Q, R>, R extends ConfigSetAdminResponse>
extends SolrRequest<R> {
    protected ConfigSetParams.ConfigSetAction action = null;

    protected ConfigSetAdminRequest<Q, R> setAction(ConfigSetParams.ConfigSetAction action) {
        this.action = action;
        return this;
    }

    public ConfigSetAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/configs");
    }

    public ConfigSetAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    protected abstract Q getThis();

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        return params;
    }

    @Override
    protected abstract R createResponse(SolrClient var1);

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.ADMIN.toString();
    }

    public static class List
    extends ConfigSetAdminRequest<List, ConfigSetAdminResponse.List> {
        public List() {
            this.action = ConfigSetParams.ConfigSetAction.LIST;
        }

        @Override
        protected List getThis() {
            return this;
        }

        @Override
        protected ConfigSetAdminResponse.List createResponse(SolrClient client) {
            return new ConfigSetAdminResponse.List();
        }
    }

    public static class Delete
    extends ConfigSetSpecificAdminRequest<Delete> {
        public Delete() {
            this.action = ConfigSetParams.ConfigSetAction.DELETE;
        }

        @Override
        protected Delete getThis() {
            return this;
        }
    }

    public static class Create
    extends ConfigSetSpecificAdminRequest<Create> {
        protected static String PROPERTY_PREFIX = "configSetProp";
        protected String baseConfigSetName;
        protected Properties properties;

        public Create() {
            this.action = ConfigSetParams.ConfigSetAction.CREATE;
        }

        @Override
        protected Create getThis() {
            return this;
        }

        public final Create setBaseConfigSetName(String baseConfigSetName) {
            this.baseConfigSetName = baseConfigSetName;
            return this.getThis();
        }

        public final String getBaseConfigSetName() {
            return this.baseConfigSetName;
        }

        public final Create setNewConfigSetProperties(Properties properties) {
            this.properties = properties;
            return this.getThis();
        }

        public final Properties getNewConfigSetProperties() {
            return this.properties;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.baseConfigSetName != null) {
                params.set("baseConfigSet", this.baseConfigSetName);
            }
            if (this.properties != null) {
                for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                    params.set(PROPERTY_PREFIX + "." + entry.getKey().toString(), entry.getValue().toString());
                }
            }
            return params;
        }
    }

    public static class Upload
    extends ConfigSetSpecificAdminRequest<Upload> {
        private static final String NO_STREAM_ERROR = "There must be a ContentStream or File to Upload";
        protected ContentStream stream;
        protected String filePath;
        protected Boolean overwrite;
        protected Boolean cleanup;

        public Upload() {
            this.action = ConfigSetParams.ConfigSetAction.UPLOAD;
            this.setMethod(SolrRequest.METHOD.POST);
        }

        @Override
        protected Upload getThis() {
            return this;
        }

        public final Upload setFilePath(String filePath) {
            this.filePath = filePath;
            return this.getThis();
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final Upload setUploadFile(File file, String contentType) {
            ContentStreamBase.FileStream fileStream = new ContentStreamBase.FileStream(file);
            fileStream.setContentType(contentType);
            return this.setUploadStream(fileStream);
        }

        public final Upload setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this.getThis();
        }

        public final Boolean getOverwrite() {
            return this.overwrite;
        }

        public final Upload setCleanup(Boolean cleanup) {
            this.cleanup = cleanup;
            return this.getThis();
        }

        public final Boolean getCleanup() {
            return this.cleanup;
        }

        public final Upload setUploadStream(ContentStream stream) {
            this.stream = stream;
            return this.getThis();
        }

        @Override
        public Collection<ContentStream> getContentStreams() throws IOException {
            return Collections.singletonList(this.stream);
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            if (null == this.stream) {
                throw new NullPointerException(NO_STREAM_ERROR);
            }
            return new RequestWriter.ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    try (InputStream inStream = stream.getStream();){
                        inStream.transferTo(os);
                    }
                }

                @Override
                public String getContentType() {
                    return stream.getContentType();
                }
            };
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (null == this.stream) {
                throw new NullPointerException(NO_STREAM_ERROR);
            }
            params.setNonNull("filePath", this.filePath);
            params.setNonNull("cleanup", this.cleanup);
            params.setNonNull("overwrite", this.overwrite);
            return params;
        }
    }

    protected static abstract class ConfigSetSpecificAdminRequest<T extends ConfigSetAdminRequest<T, ConfigSetAdminResponse>>
    extends ConfigSetAdminRequest<T, ConfigSetAdminResponse> {
        protected String configSetName = null;

        protected ConfigSetSpecificAdminRequest() {
        }

        public final T setConfigSetName(String configSetName) {
            this.configSetName = configSetName;
            return (T)this.getThis();
        }

        public final String getConfigSetName() {
            return this.configSetName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.configSetName == null) {
                throw new RuntimeException("no ConfigSet specified!");
            }
            params.set("name", this.configSetName);
            return params;
        }

        @Override
        protected ConfigSetAdminResponse createResponse(SolrClient client) {
            return new ConfigSetAdminResponse();
        }
    }
}

