# Modern (IAU)

## Introduction

The modern sky culture is used internationally by modern astronomers, and is the official scheme of The International Astronomical Union. It has historical roots in Ancient Greek astronomy, with influences from Islamic astronomy.

## Description

The modern sky culture divides the celestial sphere into 88 areas of various sizes called constellations, each with precise boundary, issued by the International Astronomical Union in 1922. These constellations have become the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

The constellations in use today are based mainly on ancient Greek constellations depicted by Ptolemy in his book the Almagest during the 2nd century CE. In the subsequent centuries, this book has been translated from Greek into Arabic (6th to 9th century) and later to medieval Latin. In the Arabic more than in the Latin tradition, the Ptolemaic figures were enriched and transformed by native Arabic constellations and star names.

In the 16-18th centuries, European astronomers suggested new constellations to fill the gaps between northern constellations (e.g. the constellation of "the lynx" for an area close to the Great Bear but with stars so faint that you would need the eyes of a lynx to see them) and also created new constellations in the southern part of the sky which had not been visible to Ptolemy. These new constellations were usually named after new technical inventions of the early modern period (e.g. a chemical furnace, a balloon, an air pump) or exotic animals (e.g. a chamaeleon, a tucan, a paradise bird). Among them several constellations were also named with political consideration to honor certain kings or patrons.

In the beginning of the 20th century, the IAU (International Astronomical Union) aimed for a large clean-up: in 1922, it officially accepted the list of 88 constellation names. In 1928 it also defined precise constellation boundaries [#4] still in use today.

### Constellations

These constellations are based mainly on the Ptolemaic tradition which had been used in all three Abrahamitic religions and, thus, was common in the Near East, in Europe and its colonies on all continents. However, between the ancient Greek constellations there were gaps of areas with only faint stars belonging to no constellation.[#5] In the Modern Epoch, several astronomers suggested constellation figures for these gaps, among them several political constellations to the honor of certain kings or patrons. In the late 19th century, the astronomical research community aimed for a huge clean-up to avoid ambiguities in assigning stars to constellations.

In 1922, the IAU officially approved the list of 88 constellation names and their official abbreviations with three letters. The only remaining political constellation is Scutum, the shield of a Polish king but without mentioning the political reference anymore. The Belgian priest E. Delporte got the task to define constellation boundaries according to coordinates. In 1928, he finished the work, based on an atlas from Argentina [#6], and the IAU accepted his delimitations [#4].

These "constellations" are naked areas in the sky without any stick figures or depictions [#1]. The borders simply follow the lines of right ascension and declination from the epoch 1875.0. Precession causes a slowly increasing deviation from the originally rectilinear grid. These constellations became the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

#### Constellation Figures

In star maps it is common to mark line "patterns" that represent the shapes that give the name to the constellations. However, the IAU defines a constellation by its boundary (indicated by sky coordinates) and not by its pattern and the same constellation may have several variants in its representation.

This sky culture uses constellation figures were produced in collaboration with "Sky and Telescope" magazine (Roger Sinnott and Rick Fienberg) and published at IAU official website [#1]. Alan MacRobert's constellation patterns, were influenced by those of H. A. Rey but in many cases were adjusted to preserve earlier traditions.

### Proper names of stars

Ptolemy's star catalogue had the layout of a table listing the description of the star's position in the constellation's figure, the ecliptical coordinates, and the magnitude e.g.: "The star at the tip of the tail of Ursa Minor", "Gem 0 1/6, +66", "Mag 3".

In most cases, the star names evolved by astronomer's systematical abbreviations of these descriptions, e.g., a first astronomer abbreviated in a text "tip of the tail", a next astronomer drew a map with less space and wrote only "tail" next to the star and this name remained. Over centuries, these descriptions were translated into Arabic and Latin, and in some cases the translators or scribes made mistakes because of misreading or misspelling of the Arabic words (e.g. the Arabic "yad al gauza", the hand of the giant woman, was mangled to the common term "Betelgeuse").

However, there are also a few original Greek words like the red star "Antares", the counterpart of Ares (Mars), and even a few original Babylonian terms like "Shargaz", the Sting, in Scorpius. Our modern, most recent IAU star names [#7] are a renewed mixture, also with influences or even politically wanted additions of star names from the non-Ptolemaic sky cultures, e.g. the traditional Pingsing, a Chinese star name for a star in Hydra (its meaning is only "star", a reminescence to his lonely position), or newly adopted star names from Polynesian, Hawaiian, or Aboriginal cultures for names of stars with exoplanets.

The IAU is the only scientifically accepted authority to assign new names to stars. Commercial exploits like "star name registries", who sell stars for commemorative purposes or as gifts, only sell printed pieces of paper. These names are not approved and never used by scientists.

### Proper names of deep-sky objects

Uranometria 2000.0 is an atlas of the 2000.0 era starry sky prepared by the Dutch artist Wil Tirion and published in 1987 by the American publishing house Willmann-Bell, specializing in astronomical literature.

The Atlas of Tirion, respected by astronomers for its accuracy and beauty, is provided with detailed tables and various indexes. The second volume contains three transparent overlays designed for precise measurements. Uranometria 2000.0 contains more than 280,000 stars and more than 30,000 deep-sky objects - in particular, all the objects of the Messier and NGC catalogs.

The second (corrected and most complete) three-volume edition of "Uranometria 2000.0", was published in 2001 under the name "Uranometria 2000.0 Deep Sky Atlas" and contains 280035 stars of both hemispheres up to 9.75<sup>m</sup> in size on a scale of 1.85 cm per declination degree on 220 spreads of A3 format. Particular attention in the atlas is paid to deep-sky objects, there are more than 30 thousand of them in the second edition - many times more than in any other paper atlas.

The third volume of "Uranometria 2000.0" is a guide to deep-sky objects - Deep Sky Field Guide, consisting of tables with scientific data and proper names on objects depicted in the first two volumes [#3].

## References

 - [#1]: [The Constellations](https://www.iau.org/public/themes/constellations/)
 - [#2]: [IAU Catalog of Star Names (IAU-CSN)](http://www.pas.rochester.edu/~emamajek/WGSN/IAU-CSN.txt)
 - [#3]: [Uranometria 2000.0 Deep Sky Field Guide. ISBN: 0-943396-73-5](https://shopatsky.com/products/uranometria-2000-0-atlas-deep-sky-field-guide)
 - [#4]: Delporte, Eugene (1930). "Delimitation scientifique des constellations (tables et cartes)". Cambridge.
 - [#5]: Hoffmann, Susanne M.: Hipparchs Himmelsglobus, Springer, Wiesbaden / New York, 2017
 - [#6]: Santiago Paolantonio, Beatriz García (2019). "Uranometría Argentina and the constellation boundaries". Under One Sky: The IAU Centenary Symposium. Cambridge. p. 505.
 - [#7]: [IAU Working Group Star Names. WGSN](https://www.iau.org/science/scientific_bodies/working_groups/280/)

## Authors

Stellarium's team

## License

CC BY-SA 4.0
