/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;

public class ASTIdentifierAccess
extends JexlNode {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer identifier;

    public static Integer parseIdentifier(String id) {
        if (id != null) {
            int length = id.length();
            int val = 0;
            for (int i = 0; i < length; ++i) {
                char c = id.charAt(i);
                if (c == '0') {
                    if (length == 1) {
                        return 0;
                    }
                    if (val == 0) {
                        return null;
                    }
                } else if (c < '0' || c > '9') {
                    return null;
                }
                val *= 10;
                val += c - 48;
            }
            return val;
        }
        return null;
    }

    ASTIdentifierAccess(int id) {
        super(id);
    }

    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpression() {
        return false;
    }

    @Override
    public boolean isGlobalVar() {
        return !this.isSafe() && !this.isExpression();
    }

    public boolean isSafe() {
        return false;
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    void setIdentifier(String id) {
        this.name = id;
        this.identifier = ASTIdentifierAccess.parseIdentifier(id);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

