/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

public final class MavenVersionSupportUtil {
    public static final String MAVEN_2_PLUGIN_ID = "org.jetbrains.idea.maven.maven2-support";

    @Nullable
    public static MavenVersionAwareSupportExtension getExtensionFor(MavenDistribution distribution) {
        return (MavenVersionAwareSupportExtension)MavenVersionAwareSupportExtension.MAVEN_VERSION_SUPPORT.findFirstSafe(e -> e.isSupportedByExtension(distribution.getMavenHome().toFile()));
    }

    public static boolean isMaven2PluginInstalled() {
        return PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)MAVEN_2_PLUGIN_ID));
    }

    public static boolean isMaven2PluginDisabled() {
        return MavenVersionSupportUtil.isMaven2PluginInstalled() && PluginManagerCore.isDisabled((PluginId)PluginId.getId((String)MAVEN_2_PLUGIN_ID));
    }

    public static boolean isMaven2Used(@NotNull Project project) {
        String version;
        if (project == null) {
            MavenVersionSupportUtil.$$$reportNull$$$0(0);
        }
        if ((version = MavenDistributionsCache.getInstance(project).getSettingsDistribution().getVersion()) == null) {
            return false;
        }
        return StringUtil.compareVersionNumbers((String)version, (String)"3") < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/MavenVersionSupportUtil", "isMaven2Used"));
    }
}

