/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.compiler.progress.BuildIssueContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.CacheForCompilerErrorMessages;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.SourceLevelBuildIssue;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsReleaseVersionQuickFix;", "Lcom/intellij/compiler/progress/BuildIssueContributor;", "<init>", "()V", "createBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "project", "Lcom/intellij/openapi/project/Project;", "moduleNames", "", "", "title", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigatable", "Lcom/intellij/pom/Navigatable;", "extractFailedMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "moduleName", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nSourceOptionQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceOptionQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsReleaseVersionQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1755#2,3:278\n*S KotlinDebug\n*F\n+ 1 SourceOptionQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsReleaseVersionQuickFix\n*L\n123#1:278,3\n*E\n"})
public final class JpsReleaseVersionQuickFix
implements BuildIssueContributor {
    @Nullable
    public BuildIssue createBuildIssue(@NotNull Project project, @NotNull Collection<String> moduleNames, @NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @Nullable VirtualFile virtualFile, @Nullable Navigatable navigatable) {
        boolean bl;
        Sdk moduleJdk;
        MavenProject mavenProject;
        block10: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            if (!manager.isMavenizedProject()) {
                return null;
            }
            if (moduleNames.size() != 1) {
                return null;
            }
            String string = (String)CollectionsKt.firstOrNull((Iterable)moduleNames);
            if (string == null) {
                return null;
            }
            String moduleName = string;
            List<Function1<String, Boolean>> predicates = CacheForCompilerErrorMessages.INSTANCE.getPredicatesToCheck(project, moduleName);
            MavenId mavenId = this.extractFailedMavenId(project, moduleName);
            if (mavenId == null) {
                return null;
            }
            MavenId failedId = mavenId;
            MavenProject mavenProject2 = manager.findProject(failedId);
            if (mavenProject2 == null) {
                return null;
            }
            mavenProject = mavenProject2;
            Sdk sdk = MavenUtil.getModuleJdk(manager, mavenProject);
            if (sdk == null) {
                return null;
            }
            moduleJdk = sdk;
            Iterable $this$any$iv = predicates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.invoke((Object)message)).booleanValue()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return new SourceLevelBuildIssue(title, message, mavenProject, moduleJdk);
        }
        return null;
    }

    private final MavenId extractFailedMavenId(Project project, String moduleName) {
        Module module = ModuleManager.Companion.getInstance(project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(module2);
        if (mavenProject == null || (mavenProject = mavenProject.getMavenId()) == null) {
            return null;
        }
        return mavenProject;
    }
}

