/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFixFactory;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.ProcessQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/UpdateSourceLevelQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.maven"})
public final class UpdateSourceLevelQuickFix
implements BuildIssueQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final String id;
    @NotNull
    private static final String ID = "maven_quickfix_source_level_";

    public UpdateSourceLevelQuickFix(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.mavenProject = mavenProject;
        this.id = ID + this.mavenProject.getMavenId().getDisplayString();
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        LanguageLevelQuickFix languageLevelQuickFix = LanguageLevelQuickFixFactory.getInstance(project, this.mavenProject);
        return ProcessQuickFix.INSTANCE.perform(languageLevelQuickFix, project, this.mavenProject);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/UpdateSourceLevelQuickFix$Companion;", "", "<init>", "()V", "ID", "", "getID", "()Ljava/lang/String;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

