/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenSyncListener;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenImportListenerBridge;", "Lorg/jetbrains/idea/maven/project/MavenSyncListener;", "<init>", "()V", "importStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "importFinished", "importedProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "newModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.maven"})
public final class MavenImportListenerBridge
implements MavenSyncListener {
    @Override
    public void importStarted(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBus messageBus = project.getMessageBus();
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((MavenImportListener)messageBus.syncPublisher(topic)).importStarted();
    }

    @Override
    public void importFinished(@NotNull Project project, @NotNull Collection<MavenProject> importedProjects, @NotNull List<? extends Module> newModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
        Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
        MessageBus messageBus = project.getMessageBus();
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((MavenImportListener)messageBus.syncPublisher(topic)).importFinished(importedProjects, newModules);
    }
}

