/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.AbstractMavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.RetryingSocketFactory;
import org.jetbrains.idea.maven.server.wsl.WslMavenCmdState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0007H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslMavenServerRemoteProcessSupport;", "Lorg/jetbrains/idea/maven/server/AbstractMavenServerRemoteProcessSupport;", "myWslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "debugPort", "", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/WslMavenDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;)V", "getRunProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "target", "", "configuration", "executor", "Lcom/intellij/execution/Executor;", "getRemoteHost", "getClientSocketFactory", "Ljava/rmi/server/RMIClientSocketFactory;", "type", "intellij.maven"})
public final class WslMavenServerRemoteProcessSupport
extends AbstractMavenServerRemoteProcessSupport {
    @NotNull
    private final WSLDistribution myWslDistribution;

    public WslMavenServerRemoteProcessSupport(@NotNull WSLDistribution myWslDistribution, @NotNull Sdk jdk, @Nullable String vmOptions, @NotNull WslMavenDistribution mavenDistribution, @NotNull Project project, @Nullable Integer debugPort) {
        Intrinsics.checkNotNullParameter((Object)myWslDistribution, (String)"myWslDistribution");
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(jdk, vmOptions, mavenDistribution, project, debugPort);
        this.myWslDistribution = myWslDistribution;
    }

    @NotNull
    protected RunProfileState getRunProfileState(@NotNull Object target, @NotNull Object configuration, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Sdk sdk = this.myJdk;
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"myJdk");
        MavenDistribution mavenDistribution = this.myDistribution;
        Intrinsics.checkNotNull((Object)mavenDistribution, (String)"null cannot be cast to non-null type org.jetbrains.idea.maven.server.WslMavenDistribution");
        WslMavenDistribution wslMavenDistribution = (WslMavenDistribution)mavenDistribution;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return (RunProfileState)new WslMavenCmdState(this.myWslDistribution, sdk, this.myOptions, wslMavenDistribution, this.myDebugPort, project, this.getRemoteHost());
    }

    @NotNull
    protected String getRemoteHost() {
        String string = this.myWslDistribution.getWslIpAddress().getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
        return string;
    }

    @NotNull
    protected RMIClientSocketFactory getClientSocketFactory() {
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = RMISocketFactory.getDefaultSocketFactory();
        }
        RMISocketFactory delegate = rMISocketFactory;
        Intrinsics.checkNotNull((Object)delegate);
        return new RetryingSocketFactory(delegate);
    }

    @Override
    @NotNull
    public String type() {
        return "WSL";
    }
}

