/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;

public final class Maven40AetherModelConverter
extends Maven40ModelConverter {
    @NotNull
    public static MavenModel convertModelWithAetherDependencyTree(MavenProject mavenProject, Collection<? extends DependencyNode> dependencyTree, File localRepository) {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()));
        Parent parent = mavenProject.getModel().getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(mavenProject.getPackaging());
        result.setName(mavenProject.getName());
        result.setProperties(mavenProject.getProperties() == null ? new Properties() : mavenProject.getProperties());
        result.setPlugins(Maven40AetherModelConverter.convertPlugins(mavenProject.getModel(), mavenProject.getPluginArtifacts()));
        HashMap<org.apache.maven.artifact.Artifact, MavenArtifact> convertedArtifacts = new HashMap<org.apache.maven.artifact.Artifact, MavenArtifact>();
        result.setExtensions(Maven40AetherModelConverter.convertArtifacts(mavenProject.getExtensionArtifacts(), convertedArtifacts, localRepository));
        result.setDependencyTree(Maven40AetherModelConverter.convertAetherDependencyNodes(null, dependencyTree, convertedArtifacts, localRepository));
        result.setDependencies(Maven40AetherModelConverter.convertArtifacts(mavenProject.getArtifacts(), convertedArtifacts, localRepository));
        result.setRemoteRepositories(Maven40AetherModelConverter.convertAetherRepositories(mavenProject.getRemoteProjectRepositories()));
        result.setRemotePluginRepositories(Maven40AetherModelConverter.convertAetherRepositories(mavenProject.getRemotePluginRepositories()));
        result.setProfiles(Maven40AetherModelConverter.convertProfiles(mavenProject.getModel().getProfiles()));
        result.setModules(mavenProject.getModules());
        Maven40AetherModelConverter.convertBuild(result.getBuild(), mavenProject.getModel().getBuild(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots());
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven40AetherModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    private static List<MavenRemoteRepository> convertAetherRepositories(List<RemoteRepository> repositories) {
        return repositories.stream().map(r -> new MavenRemoteRepository(r.getId(), r.getId(), r.getUrl(), "default", Maven40AetherModelConverter.convertPolicy(r.getPolicy(false)), Maven40AetherModelConverter.convertPolicy(r.getPolicy(true)))).collect(Collectors.toList());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MavenRemoteRepository.Policy convertPolicy(RepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getArtifactUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    public static List<MavenArtifactNode> convertAetherDependencyNodes(MavenArtifactNode parent, Collection<? extends DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode dependencyNode : nodes) {
            org.apache.maven.artifact.Artifact a = Maven40AetherModelConverter.toArtifact(dependencyNode.getDependency());
            MavenArtifact ma = Maven40AetherModelConverter.convertArtifact(a, nativeToConvertedMap, localRepository);
            Map data = dependencyNode.getData();
            String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)dependencyNode);
            String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)dependencyNode);
            MavenArtifactState state = MavenArtifactState.ADDED;
            MavenArtifact relatedArtifact = null;
            String scope = dependencyNode.getDependency().getScope();
            Object winner = data.get("conflict.winner");
            if (winner instanceof DependencyNode) {
                DependencyNode winnerNode = (DependencyNode)winner;
                scope = winnerNode.getDependency().getScope();
                org.apache.maven.artifact.Artifact winnerArtifact = Maven40AetherModelConverter.toArtifact(winnerNode.getDependency());
                relatedArtifact = Maven40AetherModelConverter.convertArtifact(winnerArtifact, nativeToConvertedMap, localRepository);
                nativeToConvertedMap.put(winnerArtifact, relatedArtifact);
                state = !Objects.equals(dependencyNode.getVersion().toString(), winnerNode.getVersion().toString()) ? MavenArtifactState.CONFLICT : MavenArtifactState.DUPLICATE;
            }
            ma.setScope(scope);
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, state, relatedArtifact, dependencyNode.getDependency().getScope(), premanagedVersion, premanagedScope);
            newNode.setDependencies(Maven40AetherModelConverter.convertAetherDependencyNodes(newNode, dependencyNode.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }

    @Nullable
    public static org.apache.maven.artifact.Artifact toArtifact(@Nullable Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact result = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
        if (result == null) {
            return null;
        }
        result.setScope(dependency.getScope());
        result.setOptional(dependency.isOptional());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/maven/server/m40/utils/Maven40AetherModelConverter", "convertModelWithAetherDependencyTree"));
    }
}

