/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionsFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateConstructorAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateEnumConstantAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateEnumConstantActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldActionKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateMethodAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreatePropertyAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/GroovyElementActionsFactory;", "Lcom/intellij/lang/jvm/actions/JvmElementActionsFactory;", "<init>", "()V", "createAddFieldActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "createAddMethodActions", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "createAddConstructorActions", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "intellij.groovy"})
public final class GroovyElementActionsFactory
extends JvmElementActionsFactory {
    @NotNull
    public List<IntentionAction> createAddFieldActions(@NotNull JvmClass targetClass, @NotNull CreateFieldRequest request) {
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GrTypeDefinition grTypeDefinition = JvmPsiUtilKt.toGroovyClassOrNull(targetClass);
        if (grTypeDefinition == null) {
            return CollectionsKt.emptyList();
        }
        GrTypeDefinition groovyClass = grTypeDefinition;
        boolean constantRequested = request.isConstant() || ((Object)((Object)this)).getClass().isInterface() || request.getModifiers().containsAll((Collection)CreateFieldActionKt.getConstantModifiers());
        ArrayList result2 = new ArrayList();
        if (constantRequested || StringUtil.isCapitalized((String)request.getFieldName())) {
            ((Collection)result2).add(new CreateFieldAction(groovyClass, request, true));
        }
        if (!constantRequested) {
            ((Collection)result2).add(new CreateFieldAction(groovyClass, request, false));
        }
        if (CreateEnumConstantActionKt.canCreateEnumConstant(groovyClass, request)) {
            ((Collection)result2).add(new CreateEnumConstantAction(groovyClass, request));
        }
        return result2;
    }

    @NotNull
    public List<IntentionAction> createAddMethodActions(@NotNull JvmClass targetClass, @NotNull CreateMethodRequest request) {
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GrTypeDefinition grTypeDefinition = JvmPsiUtilKt.toGroovyClassOrNull(targetClass);
        if (grTypeDefinition == null) {
            return CollectionsKt.emptyList();
        }
        GrTypeDefinition groovyClass = grTypeDefinition;
        Collection collection = request.getModifiers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getModifiers(...)");
        Collection requestedModifiers = collection;
        boolean staticMethodRequested = requestedModifiers.contains(JvmModifier.STATIC);
        ArrayList result2 = new ArrayList();
        if (groovyClass.isInterface()) {
            return staticMethodRequested ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new CreateMethodAction(groovyClass, request, true));
        }
        ((Collection)result2).add(new CreatePropertyAction(groovyClass, request, true));
        ((Collection)result2).add(new CreatePropertyAction(groovyClass, request, false));
        ((Collection)result2).add(new CreateMethodAction(groovyClass, request, false));
        if (!staticMethodRequested && groovyClass.hasModifierProperty("abstract")) {
            ((Collection)result2).add(new CreateMethodAction(groovyClass, request, true));
        }
        return result2;
    }

    @NotNull
    public List<IntentionAction> createAddConstructorActions(@NotNull JvmClass targetClass, @NotNull CreateConstructorRequest request) {
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GrTypeDefinition grTypeDefinition = JvmPsiUtilKt.toGroovyClassOrNull(targetClass);
        if (grTypeDefinition == null) {
            return CollectionsKt.emptyList();
        }
        GrTypeDefinition groovyClass = grTypeDefinition;
        return CollectionsKt.listOf((Object)new CreateConstructorAction(groovyClass, request));
    }
}

