/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class AddMethodFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(AddMethodFix.class);
    private final String myMethodName;
    private final String myClassName;
    private final SmartPsiElementPointer<GrTypeDefinition> myPsiClassPointer;

    public AddMethodFix(@NotNull String methodName, @NotNull GrTypeDefinition aClass) {
        if (methodName == null) {
            AddMethodFix.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            AddMethodFix.$$$reportNull$$$0(1);
        }
        this.myMethodName = methodName;
        this.myClassName = aClass.getName();
        this.myPsiClassPointer = SmartPointersKt.createSmartPointer((PsiElement)aClass);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrTypeDefinition definition;
        if (target == null) {
            AddMethodFix.$$$reportNull$$$0(2);
        }
        if ((definition = (GrTypeDefinition)this.myPsiClassPointer.getElement()) == null) {
            return null;
        }
        GrTypeDefinition copy = (GrTypeDefinition)PsiTreeUtil.findSameElementInCopy((PsiElement)definition, (PsiFile)target);
        return new AddMethodFix(this.myMethodName, copy);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrTypeDefinition psiClass;
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddMethodFix.$$$reportNull$$$0(4);
        }
        if ((psiClass = (GrTypeDefinition)this.myPsiClassPointer.getElement()) == null) {
            return;
        }
        if (psiClass.isInterface()) {
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("def " + psiClass.getName() + " " + this.myMethodName + "();");
            psiClass.add(method);
        } else {
            String templName = "Implemented Method Body.java";
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templName);
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            String returnType = AddMethodFix.generateTypeText(psiClass);
            properties.setProperty("RETURN_TYPE", returnType);
            properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType((PsiClass)psiClass)));
            properties.setProperty("CALL_SUPER", "");
            properties.setProperty("CLASS_NAME", psiClass.getQualifiedName());
            properties.setProperty("SIMPLE_CLASS_NAME", psiClass.getName());
            properties.setProperty("METHOD_NAME", this.myMethodName);
            try {
                String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
                GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
                GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("", this.myMethodName, returnType, ArrayUtilRt.EMPTY_STRING_ARRAY, psiClass);
                method.setBlock(newBody);
                psiClass.add(method);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("add.method", this.myMethodName, this.myClassName);
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.method.family", new Object[0]);
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    static String generateTypeText(GrTypeDefinition aClass) {
        String className = aClass.getName();
        LOG.assertTrue(className != null, (Object)aClass);
        StringBuilder returnType = new StringBuilder(className);
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            returnType.append('<');
            for (PsiTypeParameter typeParameter : typeParameters) {
                returnType.append(typeParameter.getName()).append(", ");
            }
            returnType.replace(returnType.length() - 2, returnType.length(), ">");
        }
        return returnType.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddMethodFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

