/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.declaration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.codeInspection.declaration.GrMethodMayBeStaticInspectionFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrMethodMayBeStaticInspection
extends BaseInspection {
    public boolean myIgnoreTraitMethods = true;
    public boolean myOnlyPrivateOrFinal = false;
    public boolean myIgnoreEmptyMethods = true;

    @Override
    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreTraitMethods", (String)GroovyBundle.message("method.may.be.static.option.ignore.trait.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myOnlyPrivateOrFinal", (String)GroovyBundle.message("method.may.be.static.only.private.or.final.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreEmptyMethods", (String)GroovyBundle.message("method.may.be.static.ignore.empty.method.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GrMethodMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GrMethodMayBeStaticInspection.this.checkMethod(method)) {
                    GrModifierFix modifierFix = new GrModifierFix(method, "static", false, true, (Function<? super ProblemDescriptor, ? extends PsiModifierList>)((Function)descriptor -> {
                        PsiElement element = descriptor.getPsiElement();
                        PsiElement parent = element.getParent();
                        assert (parent instanceof GrMethod) : "element: " + element + ", parent:" + parent;
                        return ((GrMethod)parent).getModifierList();
                    }));
                    this.registerError(method.getNameIdentifierGroovy(), GroovyBundle.message("method.may.be.static", new Object[0]), new LocalQuickFix[]{modifierFix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/declaration/GrMethodMayBeStaticInspection$1", "visitMethod"));
            }
        };
    }

    private boolean checkMethod(GrMethod method) {
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (method.getModifierList().hasExplicitModifier("abstract")) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (this.myIgnoreTraitMethods && GrTraitUtil.isTrait(containingClass)) {
            return false;
        }
        if (SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null) {
            return false;
        }
        if (OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null) {
            return false;
        }
        if (GrMethodMayBeStaticInspection.ignoreMethod(method)) {
            return false;
        }
        if (this.myOnlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return false;
        }
        if (this.myIgnoreEmptyMethods && block.getStatements().length == 0) {
            return false;
        }
        if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
            return false;
        }
        for (Condition addin : InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensionList()) {
            if (!addin.value((Object)method)) continue;
            return false;
        }
        MethodMayBeStaticVisitor visitor2 = new MethodMayBeStaticVisitor();
        method.accept(visitor2);
        return !visitor2.haveInstanceRefsOutsideClosures();
    }

    private static boolean ignoreMethod(GrMethod method) {
        GrParameter[] parameters = method.getParameters();
        if (method.getName().equals("propertyMissing") && (parameters.length == 2 || parameters.length == 1)) {
            return true;
        }
        if (method.getName().equals("methodMissing") && (parameters.length == 2 || parameters.length == 1)) {
            return true;
        }
        if (method.getContainingClass() instanceof PsiAnonymousClass) {
            return true;
        }
        for (GrMethodMayBeStaticInspectionFilter filter : (GrMethodMayBeStaticInspectionFilter[])GrMethodMayBeStaticInspectionFilter.EP_NAME.getExtensions()) {
            if (!filter.isIgnored(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrintOrPrintln(PsiElement element) {
        return element instanceof GrGdkMethod && ("print".equals(((PsiMethod)element).getName()) || "println".equals(((PsiMethod)element).getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/declaration/GrMethodMayBeStaticInspection", "getGroovyOptionsPane"));
    }

    private static class MethodMayBeStaticVisitor
    extends GroovyRecursiveElementVisitor {
        private boolean myHaveInstanceRefs = false;

        private MethodMayBeStaticVisitor() {
        }

        @Override
        public void visitElement(@NotNull GroovyPsiElement element) {
            if (element == null) {
                MethodMayBeStaticVisitor.$$$reportNull$$$0(0);
            }
            if (this.myHaveInstanceRefs) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                MethodMayBeStaticVisitor.$$$reportNull$$$0(1);
            }
            if (this.myHaveInstanceRefs) {
                return;
            }
            if (PsiUtil.isSuperReference(referenceExpression)) {
                this.registerInstanceRef();
                return;
            }
            if (PsiUtil.isThisReference(referenceExpression)) {
                if (!(referenceExpression.getParent() instanceof GrReferenceExpression)) {
                    this.registerInstanceRef();
                }
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                GroovyResolveResult result2 = referenceExpression.advancedResolve();
                PsiElement element = result2.getElement();
                if (GrMethodMayBeStaticInspection.isPrintOrPrintln(element)) {
                    return;
                }
                PsiElement resolveContext = result2.getCurrentFileResolveContext();
                if (qualifier == null && resolveContext != null) {
                    return;
                }
                if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                    return;
                }
                if (element instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
                    this.registerInstanceRef();
                }
                if (element == null) {
                    this.registerInstanceRef();
                }
            } else {
                super.visitReferenceExpression(referenceExpression);
            }
        }

        private void registerInstanceRef() {
            this.myHaveInstanceRefs = true;
        }

        @Override
        public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
            if (refElement == null) {
                MethodMayBeStaticVisitor.$$$reportNull$$$0(2);
            }
            super.visitCodeReferenceElement(refElement);
            if (this.myHaveInstanceRefs) {
                return;
            }
            PsiElement resolvedElement = refElement.resolve();
            if (!(resolvedElement instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)resolvedElement;
            PsiElement scope = aClass.getScope();
            if (!(scope instanceof PsiClass)) {
                return;
            }
            if (!aClass.hasModifierProperty("static")) {
                this.registerInstanceRef();
            }
        }

        public boolean haveInstanceRefsOutsideClosures() {
            return this.myHaveInstanceRefs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/declaration/GrMethodMayBeStaticInspection$MethodMayBeStaticVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCodeReferenceElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

