/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyReferenceCopyPasteProcessor
extends CopyPasteReferenceProcessor<GrReferenceElement> {
    private static final Logger LOG = Logger.getInstance(GroovyReferenceCopyPasteProcessor.class);

    protected void addReferenceData(PsiFile file, int startOffset, PsiElement element, ArrayList<ReferenceData> to) {
        GroovyResolveResult resolveResult;
        PsiElement refElement;
        if (DumbService.isDumb((Project)element.getProject())) {
            return;
        }
        if (element instanceof GrReferenceElement && ((GrReferenceElement)element).getQualifier() == null && (refElement = (resolveResult = ((GrReferenceElement)element).advancedResolve()).getElement()) != null) {
            if (refElement instanceof PsiClass) {
                String qName;
                if (refElement.getContainingFile() != element.getContainingFile() && (qName = ((PsiClass)refElement).getQualifiedName()) != null) {
                    GroovyReferenceCopyPasteProcessor.addReferenceData((PsiElement)element, to, (int)startOffset, (String)qName, null);
                }
            } else if (resolveResult.getCurrentFileResolveContext() instanceof GrImportStatement && ((GrImportStatement)resolveResult.getCurrentFileResolveContext()).isStatic()) {
                String classQName = ((PsiMember)refElement).getContainingClass().getQualifiedName();
                String name = ((PsiNamedElement)refElement).getName();
                if (classQName != null && name != null) {
                    GroovyReferenceCopyPasteProcessor.addReferenceData((PsiElement)element, to, (int)startOffset, (String)classQName, (String)name);
                }
            }
        }
    }

    protected void removeImports(@NotNull PsiFile file, @NotNull Set<String> imports2) {
        if (file == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(0);
        }
        if (imports2 == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        GroovyFile groovyFile = (GroovyFile)file;
        for (GrImportStatement statement : groovyFile.getImportStatements()) {
            if (!imports2.contains(statement.getImportedName())) continue;
            groovyFile.removeImport(statement);
        }
    }

    protected GrReferenceElement @NotNull [] findReferencesToRestore(@NotNull PsiFile file, @NotNull RangeMarker bounds, ReferenceData @NotNull [] referenceData) {
        if (file == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if (bounds == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        if (referenceData == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper helper = facade.getResolveHelper();
        GrReferenceElement[] refs = new GrReferenceElement[referenceData.length];
        for (int i2 = 0; i2 < referenceData.length; ++i2) {
            PsiElement referent;
            TextRange range;
            PsiElement psiElement;
            ReferenceData data = referenceData[i2];
            PsiClass refClass = facade.findClass(data.qClassName, file.getResolveScope());
            if (refClass == null) continue;
            int startOffset = data.startOffset + bounds.getStartOffset();
            int endOffset = data.endOffset + bounds.getStartOffset();
            PsiElement element = file.findElementAt(startOffset);
            if (element == null || !((psiElement = element.getParent()) instanceof GrReferenceElement)) continue;
            GrReferenceElement reference = (GrReferenceElement)psiElement;
            if (PsiUtil.isThisOrSuperRef(element.getParent()) || (range = reference.getTextRange()).getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            if (data.staticMemberName == null) {
                PsiClass refClass1 = helper.resolveReferencedClass(reference.getText(), (PsiElement)reference);
                if (refClass1 != null && manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)refClass1)) continue;
                refs[i2] = reference;
                continue;
            }
            if (!(reference instanceof GrReferenceExpression) || (referent = GroovyReferenceCopyPasteProcessor.resolveReferenceIgnoreOverriding((PsiPolyVariantReference)reference)) instanceof PsiNamedElement && data.staticMemberName.equals(((PsiNamedElement)referent).getName()) && referent instanceof PsiMember && ((PsiMember)referent).getContainingClass() != null && data.qClassName.equals(((PsiMember)referent).getContainingClass().getQualifiedName())) continue;
            refs[i2] = reference;
        }
        if (refs == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        return refs;
    }

    protected void restoreReferences(ReferenceData @NotNull [] referenceData, GrReferenceElement @NotNull [] refs, @NotNull Set<? super String> imported) {
        if (imported == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        if (referenceData == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if (refs == null) {
            GroovyReferenceCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        for (int i2 = 0; i2 < refs.length; ++i2) {
            GrReferenceElement reference = refs[i2];
            if (reference == null) continue;
            try {
                PsiManager manager = reference.getManager();
                ReferenceData refData = referenceData[i2];
                PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(refData.qClassName, reference.getResolveScope());
                if (refClass == null) continue;
                if (refData.staticMemberName == null) {
                    reference.bindToElement((PsiElement)refClass);
                    imported.add(refData.qClassName);
                    continue;
                }
                LOG.assertTrue(reference instanceof GrReferenceExpression);
                PsiMember member = GroovyReferenceCopyPasteProcessor.findMember(refData, refClass);
                if (member == null) continue;
                ((GrReferenceExpression)reference).bindToElementViaStaticImport(member);
                imported.add(StringUtil.getQualifiedName((String)refData.qClassName, (String)refData.staticMemberName));
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static PsiMember findMember(ReferenceData refData, PsiClass refClass) {
        PsiField field2 = refClass.findFieldByName(refData.staticMemberName, true);
        if (field2 != null) {
            return field2;
        }
        PsiMethod[] methods = refClass.findMethodsByName(refData.staticMemberName, true);
        if (methods.length != 0) {
            return methods[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/editor/GroovyReferenceCopyPasteProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/editor/GroovyReferenceCopyPasteProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToRestore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeImports";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToRestore";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

