/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.annotations;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyAnnotationArgumentPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/annotations/AddAnnotationValueIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/GrPsiUpdateIntention;", "<init>", "()V", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "processIntention", "", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Holder", "intellij.groovy"})
public final class AddAnnotationValueIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return Holder.INSTANCE.getMyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        GrAnnotationMemberValue grAnnotationMemberValue = element instanceof GrAnnotationMemberValue ? (GrAnnotationMemberValue)element : null;
        if (grAnnotationMemberValue == null) {
            return;
        }
        GrAnnotationMemberValue value = grAnnotationMemberValue;
        PsiElement psiElement = ((GrAnnotationMemberValue)element).getParent();
        GrAnnotationNameValuePair grAnnotationNameValuePair = psiElement instanceof GrAnnotationNameValuePair ? (GrAnnotationNameValuePair)psiElement : null;
        if (grAnnotationNameValuePair == null) {
            return;
        }
        GrAnnotationNameValuePair pair = grAnnotationNameValuePair;
        ASTNode aSTNode = value.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        ASTNode anchor = aSTNode;
        pair.getNode().addLeaf(GroovyTokenTypes.mIDENT, (CharSequence)"value", anchor);
        pair.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchor);
        CodeStyleManager.getInstance((Project)context.project()).reformat((PsiElement)pair, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/annotations/AddAnnotationValueIntention$Holder;", "", "<init>", "()V", "myPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getMyPredicate", "()Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "intellij.groovy"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final PsiElementPredicate myPredicate;

        private Holder() {
        }

        @NotNull
        public final PsiElementPredicate getMyPredicate() {
            return myPredicate;
        }

        static {
            PatternCondition<GrAnnotationArgumentList> singleArgumentCondition2 = new PatternCondition<GrAnnotationArgumentList>(){

                public boolean accepts(GrAnnotationArgumentList t, ProcessingContext context) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    return t.getAttributes().length == 1;
                }
            };
            ObjectPattern objectPattern = GroovyPatternsKt.getGroovyAnnotationArgumentList().with((PatternCondition)singleArgumentCondition2);
            Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
            GroovyElementPattern.Capture argumentList = (GroovyElementPattern.Capture)objectPattern;
            TreeElementPattern treeElementPattern = GroovyPatternsKt.getGroovyAnnotationArgument().withArgumentName(null).withParent((ElementPattern)argumentList);
            Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
            GroovyAnnotationArgumentPattern.Capture argument = (GroovyAnnotationArgumentPattern.Capture)treeElementPattern;
            TreeElementPattern treeElementPattern2 = GroovyPatternsKt.getGroovyAnnotationArgumentValue().withParent((ElementPattern)argument);
            Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern2, (String)"withParent(...)");
            GroovyElementPattern.Capture argumentValue = (GroovyElementPattern.Capture)treeElementPattern2;
            myPredicate = arg_0 -> ((GroovyElementPattern.Capture)argumentValue).accepts(arg_0);
        }
    }
}

