/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectResultsConsumerEP;
import com.intellij.codeInspection.InspectionApplicationException;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileLoader;
import com.intellij.codeInspection.InspectionProfileLoaderBase;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.ReportConverterUtil;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsPreservingExecutor;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import one.util.streamex.StreamEx;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class InspectionApplicationBase
implements CommandLineInspectionProgressReporter {
    public static final Logger LOG = Logger.getInstance(InspectionApplicationBase.class);
    public static final String PROJECT_STRUCTURE_DIR = "projectStructure";
    public InspectionToolCmdlineOptionHelpProvider myHelpProvider;
    public String myProjectPath;
    public String myOutPath;
    public String mySourceDirectory;
    public String myStubProfile;
    public String myProfileName;
    public String myProfilePath;
    public boolean myRunWithEditorSettings;
    boolean myRunGlobalToolsOnly;
    public boolean myAnalyzeChanges;
    private boolean myPathProfiling;
    private int myVerboseLevel;
    private final Map<String, List<Range>> diffMap = new ConcurrentHashMap<String, List<Range>>();
    private final MultiMap<Pair<String, Integer>, String> originalWarnings = MultiMap.createConcurrent();
    private final AsyncPromise<Void> isMappingLoaded = new AsyncPromise();
    public String myOutputFormat;
    public InspectionProfileImpl myInspectionProfile;
    String myTargets;
    public boolean myErrorCodeRequired = true;
    String myScopePattern;

    public void startup() {
        if (this.myProjectPath == null) {
            this.reportError("Project to inspect is not defined");
            this.printHelpAndExit();
        }
        if (this.isProfileConfigInvalid()) {
            this.reportError("Profile to inspect with is not defined");
            this.printHelpAndExit();
        }
        ApplicationManagerEx.getApplicationEx().setSaveAllowed(false);
        try {
            this.header();
            this.execute();
        }
        catch (ProcessCanceledException e) {
            this.reportError(e);
            this.gracefulExit();
            return;
        }
        catch (Throwable e) {
            LOG.error(e);
            this.reportError(e);
            this.gracefulExit();
            return;
        }
        if (this.myErrorCodeRequired) {
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
    }

    public void enablePathProfiling() {
        this.myPathProfiling = true;
    }

    public void header() {
    }

    protected boolean isProfileConfigInvalid() {
        return this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null;
    }

    public void execute() throws Exception {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        Disposable disposable = Disposer.newDisposable();
        try {
            this.run(Paths.get(FileUtil.toCanonicalPath((String)this.myProjectPath), new String[0]), disposable);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private void printHelpAndExit() {
        this.myHelpProvider.printHelpAndExit();
    }

    @NotNull
    private CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext(final @NotNull Path projectPath, @Nullable AnalysisScope scope) {
        if (projectPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(0);
        }
        return new CommandLineInspectionProjectConfigurator.ConfiguratorContext(){

            @NotNull
            public ProgressIndicator getProgressIndicator() {
                return new ProgressIndicatorBase();
            }

            @NotNull
            public CommandLineInspectionProgressReporter getLogger() {
                InspectionApplicationBase inspectionApplicationBase = InspectionApplicationBase.this;
                if (inspectionApplicationBase == null) {
                    1.$$$reportNull$$$0(0);
                }
                return inspectionApplicationBase;
            }

            @NotNull
            public Path getProjectPath() {
                Path path = projectPath;
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                return path;
            }

            @NotNull
            public Predicate<Path> getFilesFilter() {
                Predicate<Path> predicate = __ -> true;
                if (predicate == null) {
                    1.$$$reportNull$$$0(2);
                }
                return predicate;
            }

            @NotNull
            public Predicate<VirtualFile> getVirtualFilesFilter() {
                Predicate<VirtualFile> predicate = __ -> true;
                if (predicate == null) {
                    1.$$$reportNull$$$0(3);
                }
                return predicate;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/InspectionApplicationBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLogger";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProjectPath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilesFilter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVirtualFilesFilter";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected void run(@NotNull Path projectPath, @NotNull Disposable parentDisposable) throws IOException, InterruptedException, ExecutionException {
        AnalysisScope scope;
        Project project2;
        if (projectPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            InspectionApplicationBase.$$$reportNull$$$0(2);
        }
        if ((project2 = this.openProject(projectPath, parentDisposable)) == null) {
            return;
        }
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
        if (this.myInspectionProfile == null) {
            this.myInspectionProfile = this.loadInspectionProfile(project2);
        }
        if ((scope = this.getAnalysisScope(project2)) == null) {
            return;
        }
        LOG.info("Used scope: " + scope);
        this.runAnalysisOnScope(projectPath, parentDisposable, project2, this.myInspectionProfile, scope);
    }

    @Nullable
    private Project openProject(@NotNull Path projectPath, @NotNull Disposable parentDisposable) throws InterruptedException, ExecutionException {
        InspectionsReportConverter reportConverter;
        VirtualFile vfsProject;
        if (projectPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            InspectionApplicationBase.$$$reportNull$$$0(4);
        }
        if ((vfsProject = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)projectPath.toString()))) == null) {
            this.reportError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{projectPath}));
            this.printHelpAndExit();
        }
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
        ConversionService conversionService = ConversionService.getInstance();
        StringBuilder convertErrorBuffer = new StringBuilder();
        if (conversionService != null && conversionService.blockingConvertSilently(projectPath, this.createConversionListener(convertErrorBuffer)).openingIsCanceled()) {
            this.onFailure(convertErrorBuffer.toString());
            return null;
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getExtensionList()) {
            CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, null))) continue;
            configurator.configureEnvironment(context);
        }
        if (Boolean.getBoolean("log.project.structure.changes") && (reportConverter = ReportConverterUtil.getReportConverter((String)this.myOutputFormat)) != null) {
            InspectionApplicationBase.addRootChangesListener(parentDisposable, reportConverter);
        }
        AtomicReference projectRef = new AtomicReference();
        ProgressManager.getInstance().runProcess(() -> projectRef.set(ProjectUtil.openOrImport((Path)projectPath)), (ProgressIndicator)this.createProgressIndicator());
        Project project2 = (Project)projectRef.get();
        if (project2 == null) {
            this.onFailure(InspectionsBundle.message((String)"inspection.application.unable.open.project", (Object[])new Object[0]));
            return null;
        }
        InspectionApplicationBase.waitAllStartupActivitiesPassed(project2);
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.isMappingLoaded.setResult(null));
        Disposer.register((Disposable)parentDisposable, () -> InspectionApplicationBase.closeProject(project2));
        ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        return project2;
    }

    @Nullable
    private AnalysisScope getAnalysisScope(@NotNull Project project2) throws ExecutionException, InterruptedException {
        SearchScope scope;
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(5);
        }
        if ((scope = this.getSearchScope(project2)) == null) {
            return null;
        }
        return new AnalysisScope(scope, project2);
    }

    private SearchScope getSearchScope(@NotNull Project project2) throws ExecutionException, InterruptedException {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(6);
        }
        if (this.myAnalyzeChanges) {
            return this.getSearchScopeFromChangedFiles(project2);
        }
        if (this.myScopePattern != null) {
            try {
                PackageSet packageSet2 = PackageSetFactory.getInstance().compile(this.myScopePattern);
                NamedScope namedScope = new NamedScope("commandLineScope", AllIcons.Ide.LocalScope, packageSet2);
                return GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)namedScope);
            }
            catch (ParsingException e) {
                LOG.error("Error of scope parsing", (Throwable)e);
                this.gracefulExit();
                throw new IllegalStateException("unreachable");
            }
        }
        if (this.mySourceDirectory != null) {
            if (!new File(this.mySourceDirectory).isAbsolute()) {
                this.mySourceDirectory = new File(this.myProjectPath, this.mySourceDirectory).getPath();
            }
            this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
            VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
            if (vfsDir == null) {
                this.reportError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                this.printHelpAndExit();
            }
            return GlobalSearchScopesCore.directoriesScope((Project)project2, (boolean)true, (VirtualFile[])new VirtualFile[]{Objects.requireNonNull(vfsDir)});
        }
        String scopeName = System.getProperty("idea.analyze.scope");
        NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)project2, (String)scopeName) : null;
        return namedScope != null ? GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)namedScope) : GlobalSearchScope.projectScope((Project)project2);
    }

    @NotNull
    public SearchScope getSearchScopeFromChangedFiles(@NotNull Project project2) throws ExecutionException, InterruptedException {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(7);
        }
        List<VirtualFile> files = InspectionApplicationBase.getChangedFiles(project2);
        for (VirtualFile file : files) {
            this.reportMessage(0, "modified file: " + file.getPath());
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithoutLibrariesScope((Project)project2, files);
        if (globalSearchScope == null) {
            InspectionApplicationBase.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    private static void addRootChangesListener(Disposable parentDisposable, final InspectionsReportConverter reportConverter) {
        MessageBusConnection applicationBus = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        applicationBus.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                InspectionApplicationBase.subscribeToRootChanges(project2, reportConverter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/InspectionApplicationBase$2", "projectOpened"));
            }
        });
    }

    private static void subscribeToRootChanges(final Project project2, final InspectionsReportConverter reportConverter) {
        final Path rootLogDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("projectStructureChanges");
        rootLogDir.toFile().mkdirs();
        final AtomicInteger counter = new AtomicInteger(0);
        reportConverter.projectData(project2, rootLogDir.resolve("state0"));
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                InspectionApplicationBase.updateProjectStructure(counter, reportConverter, project2, rootLogDir);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/InspectionApplicationBase$3", "rootsChanged"));
            }
        });
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (__, __1, __2, __3) -> InspectionApplicationBase.updateProjectStructure(counter, reportConverter, project2, rootLogDir));
    }

    private static void updateProjectStructure(AtomicInteger counter, InspectionsReportConverter reportConverter, Project project2, Path rootLogDir) {
        int i = counter.incrementAndGet();
        reportConverter.projectData(project2, rootLogDir.resolve("state" + i));
        LOG.info("Project structure update written. Change number " + i);
    }

    public static List<VirtualFile> getChangedFiles(@NotNull Project project2) throws ExecutionException, InterruptedException {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(9);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        CompletableFuture future = new CompletableFuture();
        changeListManager.invokeAfterUpdateWithModal(false, null, () -> {
            try {
                List<VirtualFile> files = changeListManager.getAffectedFiles();
                future.complete(files);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return (List)future.get();
    }

    private static void waitAllStartupActivitiesPassed(@NotNull Project project2) throws InterruptedException, ExecutionException {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        LOG.info("Waiting for startup activities");
        int timeout = Registry.intValue((String)"batch.inspections.startup.activities.timeout", (int)180);
        try {
            FutureKt.asCompletableFuture((Job)StartupManager.getInstance((Project)project2).getAllActivitiesPassedFuture()).get(timeout, TimeUnit.MINUTES);
            InspectionApplicationBase.waitForInvokeLaterActivities();
            LOG.info("Startup activities finished");
        }
        catch (TimeoutException e) {
            String threads = ThreadDumper.dumpThreadsToString();
            throw new RuntimeException(String.format("Cannot process startup activities in %s minutes. ", timeout) + "You can try to increase batch.inspections.startup.activities.timeout registry value. Thread dumps\n: " + threads, e);
        }
    }

    @NotNull
    private GlobalInspectionContextEx createGlobalInspectionContext(Project project2) {
        InspectionManagerBase im = (InspectionManagerBase)InspectionManager.getInstance((Project)project2);
        GlobalInspectionContextEx context = (GlobalInspectionContextEx)im.createNewGlobalContext();
        context.setExternalProfile(this.myInspectionProfile);
        if (this.myPathProfiling) {
            context.startPathProfiling();
        }
        im.setProfile(this.myInspectionProfile.getName());
        GlobalInspectionContextEx globalInspectionContextEx = context;
        if (globalInspectionContextEx == null) {
            InspectionApplicationBase.$$$reportNull$$$0(11);
        }
        return globalInspectionContextEx;
    }

    private void runAnalysisOnScope(Path projectPath, @NotNull Disposable parentDisposable, Project project2, InspectionProfileImpl inspectionProfile, AnalysisScope scope) throws IOException {
        Path resultsDataPath;
        InspectionsReportConverter reportConverter;
        if (parentDisposable == null) {
            InspectionApplicationBase.$$$reportNull$$$0(12);
        }
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        if (!this.myRunWithEditorSettings) {
            this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
        }
        if ((reportConverter = ReportConverterUtil.getReportConverter((String)this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
            reportConverter = new XSLTReportConverter(this.myOutputFormat);
        }
        try {
            resultsDataPath = ReportConverterUtil.getResultsDataPath((Disposable)parentDisposable, (InspectionsReportConverter)reportConverter, (String)this.myOutPath);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            System.err.println("Cannot create tmp directory.");
            System.exit(1);
            return;
        }
        this.runAnalysis(project2, projectPath, inspectionProfile, scope, reportConverter, resultsDataPath);
    }

    private void configureProject(@NotNull Path projectPath, @NotNull Project project2, @NotNull AnalysisScope scope) {
        CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
        if (projectPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            InspectionApplicationBase.$$$reportNull$$$0(15);
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getIterable()) {
            context = this.configuratorContext(projectPath, scope);
            configurator.preConfigureProject(project2, context);
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getIterable()) {
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, scope))) continue;
            configurator.configureProject(project2, context);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> PatchProjectUtil.patchProject((Project)project2));
        InspectionApplicationBase.waitForInvokeLaterActivities();
    }

    private static void waitForInvokeLaterActivities() {
        for (int i = 0; i < 3; ++i) {
            ApplicationManager.getApplication().invokeAndWait(() -> {}, ModalityState.any());
        }
    }

    private void runAnalysis(Project project2, Path projectPath, InspectionProfileImpl inspectionProfile, AnalysisScope scope, InspectionsReportConverter reportConverter, Path resultsDataPath) throws IOException {
        GlobalInspectionContextEx context = this.createGlobalInspectionContext(project2);
        if (this.myAnalyzeChanges) {
            AnalysisScope baseScope = scope;
            GlobalInspectionContextEx baseContext = this.createGlobalInspectionContext(project2);
            scope = this.runAnalysisOnCodeWithoutChanges(project2, baseContext, () -> this.runUnderProgress(project2, projectPath, baseContext, baseScope, resultsDataPath, new ArrayList()));
            this.setupSecondAnalysisHandler(project2, context);
        }
        ArrayList<Path> inspectionsResults = new ArrayList<Path>();
        this.runUnderProgress(project2, projectPath, context, scope, resultsDataPath, inspectionsResults);
        Path descriptionsFile = resultsDataPath.resolve(".descriptions.xml");
        try {
            InspectionsResultUtil.describeInspections((Path)descriptionsFile, (String)(this.myRunWithEditorSettings ? null : inspectionProfile.getName()), (InspectionProfile)inspectionProfile);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        inspectionsResults.add(descriptionsFile);
        if (reportConverter != null) {
            try {
                List results = ContainerUtil.map(inspectionsResults, Path::toFile);
                reportConverter.convert(resultsDataPath.toString(), this.myOutPath, context.getTools(), results);
                InspectResultsConsumerEP.runConsumers(context.getTools(), results, project2);
                if (this.myOutPath != null) {
                    reportConverter.projectData(project2, Paths.get(this.myOutPath, new String[0]).resolve(PROJECT_STRUCTURE_DIR));
                }
            }
            catch (InspectionsReportConverter.ConversionException e) {
                this.reportError("\n" + e.getMessage());
                this.printHelpAndExit();
            }
        }
    }

    @NotNull
    public AnalysisScope runAnalysisOnCodeWithoutChanges(Project project2, GlobalInspectionContextEx context, Runnable analysisRunner) {
        VirtualFile[] changes = ChangesUtil.getFilesFromChanges(ChangeListManager.getInstance(project2).getAllChanges());
        this.setupFirstAnalysisHandler(context);
        DumbService dumbService = DumbService.getInstance((Project)project2);
        while (dumbService.isDumb()) {
            LockSupport.parkNanos(50000000L);
        }
        if (ProjectLevelVcsManager.getInstance(project2).getAllVcsRoots().length == 0) {
            try {
                this.isMappingLoaded.blockingGet(60000);
            }
            catch (ExecutionException | TimeoutException e) {
                this.onFailure(InspectionsBundle.message((String)"inspection.application.cannot.initialize.vcs.mapping", (Object[])new Object[0]));
            }
        }
        InspectionApplicationBase.runAnalysisAfterShelvingSync(project2, ChangeListManager.getInstance(project2).getAffectedFiles(), (ProgressIndicator)this.createProgressIndicator(), () -> {
            InspectionApplicationBase.syncProject(project2, changes);
            analysisRunner.run();
        });
        InspectionApplicationBase.syncProject(project2, changes);
        List<VirtualFile> files = ChangeListManager.getInstance(project2).getAffectedFiles();
        if (this.myVerboseLevel == 3) {
            for (VirtualFile file : files) {
                this.reportMessage(1, "modified after unshelving: " + file.getPath());
            }
        }
        return new AnalysisScope(project2, files);
    }

    private static void syncProject(Project project2, VirtualFile[] changes) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])changes);
        WriteAction.runAndWait(() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments());
    }

    private void setupFirstAnalysisHandler(GlobalInspectionContextEx context) {
        this.reportMessage(1, "Running first analysis stage...");
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplicationBase.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            this.originalWarnings.putValue((Object)Pair.create((Object)((VirtualFile)fileAndLine.first).getPath(), (Object)((Integer)fileAndLine.second)), (Object)description);
            return false;
        });
        context.setReportedProblemFilter((element, descriptors) -> {
            List problemDescriptors = ContainerUtil.filterIsInstance((Object[])descriptors, ProblemDescriptorBase.class);
            if (!problemDescriptors.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)problemDescriptors.get(0);
                VirtualFile file = problemDescriptor.getContainingFile();
                if (file == null) {
                    return false;
                }
                int lineNumber = problemDescriptor.getLineNumber();
                for (ProblemDescriptorBase it : problemDescriptors) {
                    this.originalWarnings.putValue((Object)Pair.create((Object)file.getPath(), (Object)lineNumber), (Object)it.toString());
                }
            }
            return false;
        });
    }

    public void setupSecondAnalysisHandler(Project project2, GlobalInspectionContextEx context) {
        this.reportMessage(1, "Running second analysis stage...");
        this.printBeforeSecondStageProblems();
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplicationBase.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            return this.secondAnalysisFilter(changeListManager, description, (VirtualFile)fileAndLine.first, (Integer)fileAndLine.second);
        });
        context.setReportedProblemFilter((element, descriptors) -> {
            List any = ContainerUtil.filterIsInstance((Object[])descriptors, ProblemDescriptorBase.class);
            if (!any.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)any.get(0);
                String text2 = problemDescriptor.toString();
                VirtualFile file = problemDescriptor.getContainingFile();
                if (file == null) {
                    return true;
                }
                int line = problemDescriptor.getLineNumber();
                return this.secondAnalysisFilter(changeListManager, text2, file, line);
            }
            return true;
        });
    }

    @Nullable
    private static Pair<VirtualFile, Integer> findFileAndLineByRefElement(RefElement refElement) {
        PsiElement element = refElement.getPsiElement();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        int line = (Integer)ReadAction.compute(() -> {
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            return document == null ? -1 : document.getLineNumber(element.getTextRange().getStartOffset());
        });
        return Pair.create((Object)virtualFile, (Object)line);
    }

    private boolean secondAnalysisFilter(ChangeListManager changeListManager, String text2, VirtualFile file, int line) {
        List<Range> ranges = this.getOrComputeUnchangedRanges(file, changeListManager);
        Range first = (Range)ContainerUtil.find(ranges, it -> it.start1 <= line && line < it.end1);
        if (first == null) {
            this.logNotFiltered(text2, file, line, -1);
            return true;
        }
        int position = first.start2 + line - first.start1;
        Collection problems = this.originalWarnings.get((Object)Pair.create((Object)file.getPath(), (Object)position));
        if (problems.stream().anyMatch(it -> Objects.equals(it, text2))) {
            return false;
        }
        this.logNotFiltered(text2, file, line, position);
        return true;
    }

    private void logNotFiltered(String text2, VirtualFile file, int line, int position) {
        if (text2.contains("unused")) {
            return;
        }
        this.reportMessage(3, "Not filtered:");
        this.reportMessage(3, file.getPath() + ":" + (line + 1) + " Original: " + (position + 1));
        this.reportMessage(3, "\t\t" + text2);
    }

    private void printBeforeSecondStageProblems() {
        if (this.myVerboseLevel == 3) {
            this.reportMessage(3, "Old warnings:");
            ArrayList<Map.Entry> entries2 = new ArrayList<Map.Entry>(this.originalWarnings.entrySet());
            this.reportMessage(3, "total size: " + entries2.size());
            entries2.sort(Comparator.comparing(o -> (String)((Pair)o.getKey()).first).thenComparingInt(o -> (Integer)((Pair)o.getKey()).second));
            for (Map.Entry entry2 : entries2) {
                this.reportMessage(3, (String)((Pair)entry2.getKey()).first + ":" + ((Integer)((Pair)entry2.getKey()).second + 1));
                for (String value : (Collection)entry2.getValue()) {
                    this.reportMessage(3, "\t\t" + value);
                }
            }
        }
    }

    private void runUnderProgress(final @NotNull Project project2, final @NotNull Path projectPath, final @NotNull GlobalInspectionContextEx context, final @NotNull AnalysisScope scope, final @NotNull Path resultsDataPath, final @NotNull List<? super Path> inspectionsResults) {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(16);
        }
        if (projectPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(17);
        }
        if (context == null) {
            InspectionApplicationBase.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            InspectionApplicationBase.$$$reportNull$$$0(19);
        }
        if (resultsDataPath == null) {
            InspectionApplicationBase.$$$reportNull$$$0(20);
        }
        if (inspectionsResults == null) {
            InspectionApplicationBase.$$$reportNull$$$0(21);
        }
        Task.Backgroundable task = new Task.Backgroundable(project2, ""){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                InspectionApplicationBase.this.configureProject(projectPath, project2, scope);
                if (!GlobalInspectionContextUtil.canRunInspections((Project)project2, (boolean)false, () -> {})) {
                    InspectionApplicationBase.this.onFailure(InspectionsBundle.message((String)"inspection.application.cannot.configure.project.to.run.inspections", (Object[])new Object[0]));
                }
                context.launchInspectionsOffline(scope, resultsDataPath, InspectionApplicationBase.this.myRunGlobalToolsOnly, inspectionsResults);
                InspectionApplicationBase.this.reportMessage(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
                if (!InspectionApplicationBase.this.myErrorCodeRequired) {
                    InspectionApplicationBase.closeProject(project2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionApplicationBase$4", "run"));
            }
        };
        new ProgressRunner((Task)task).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress((ProgressIndicator)this.createProgressIndicator()).sync().submitAndGet();
    }

    @NotNull
    private ProgressIndicatorBase createProgressIndicator() {
        return new InspectionProgressIndicator();
    }

    private static void runAnalysisAfterShelvingSync(Project project2, List<? extends VirtualFile> files, ProgressIndicator progressIndicator, Runnable afterShelve) {
        Set versionedRoots = StreamEx.of(files).map(it -> ProjectLevelVcsManager.getInstance(project2).getVcsRootFor((VirtualFile)it)).nonNull().toSet();
        String message = VcsBundle.message("searching.for.code.smells.freezing.process", new Object[0]);
        VcsPreservingExecutor.executeOperation(project2, versionedRoots, message, progressIndicator, afterShelve);
    }

    public void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static void closeProject(@NotNull Project project2) {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (!project2.isDisposed()) {
                if (Boolean.getBoolean("inspect.save.project.settings")) {
                    StoreUtilKt.forPoorJavaClientOnlySaveProjectIndEdtDoNotUseThisMethod((Project)project2, (boolean)true);
                }
                ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
            }
        });
    }

    @NotNull
    private InspectionProfileImpl loadInspectionProfile(@NotNull Project project2) {
        InspectionProfileLoader<? extends InspectionProfileImpl> profileLoader;
        InspectionProfileImpl profile;
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(23);
        }
        if ((profile = (profileLoader = this.getInspectionProfileLoader(project2)).tryLoadProfileByNameOrPath(this.myProfileName, this.myProfilePath, "command line", msg -> this.onFailure((String)msg))) != null) {
            InspectionProfileImpl inspectionProfileImpl = profile;
            if (inspectionProfileImpl == null) {
                InspectionApplicationBase.$$$reportNull$$$0(24);
            }
            return inspectionProfileImpl;
        }
        if (this.myStubProfile != null && !this.myRunWithEditorSettings) {
            profile = profileLoader.loadProfileByName(this.myStubProfile);
            if (profile != null) {
                InspectionProfileImpl inspectionProfileImpl = profile;
                if (inspectionProfileImpl == null) {
                    InspectionApplicationBase.$$$reportNull$$$0(25);
                }
                return inspectionProfileImpl;
            }
            profile = profileLoader.loadProfileByPath(this.myStubProfile);
            if (profile != null) {
                InspectionProfileImpl inspectionProfileImpl = profile;
                if (inspectionProfileImpl == null) {
                    InspectionApplicationBase.$$$reportNull$$$0(26);
                }
                return inspectionProfileImpl;
            }
        }
        profile = InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile();
        this.reportError("Using default project profile");
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            InspectionApplicationBase.$$$reportNull$$$0(27);
        }
        return inspectionProfileImpl;
    }

    public InspectionProfileManager getProfileManager(@NotNull Project project2) {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(28);
        }
        return InspectionProjectProfileManager.getInstance((Project)project2);
    }

    @NotNull
    private InspectionProfileLoader<? extends InspectionProfileImpl> getInspectionProfileLoader(final @NotNull Project project2) {
        if (project2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(29);
        }
        return new InspectionProfileLoaderBase<InspectionProfileImpl>(project2){

            @Override
            @Nullable
            public InspectionProfileImpl loadProfileByName(@NotNull String profileName) {
                if (profileName == null) {
                    5.$$$reportNull$$$0(0);
                }
                InspectionProfileManager.getInstance().getProfiles();
                InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)project2);
                InspectionProfileImpl inspectionProfile = profileManager.getProfile(profileName, false);
                if (inspectionProfile == null) {
                    for (InspectionProfileImpl profile : profileManager.getProfiles()) {
                        if (!Comparing.strEqual((String)profile.getName(), (String)profileName)) continue;
                        inspectionProfile = profile;
                        break;
                    }
                }
                return inspectionProfile;
            }

            @Override
            @Nullable
            public InspectionProfileImpl loadProfileByPath(@NotNull String profilePath) {
                InspectionProfileImpl inspectionProfileFromYaml;
                if (profilePath == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((inspectionProfileFromYaml = this.tryLoadProfileFromYaml(profilePath, (InspectionToolsSupplier)InspectionToolRegistrar.getInstance(), (BaseInspectionProfileManager)InspectionProjectProfileManager.getInstance((Project)project2))) != null) {
                    return inspectionProfileFromYaml;
                }
                try {
                    InspectionProfileImpl inspectionProfile = ApplicationInspectionProfileManagerBase.getInstanceBase().loadProfile(profilePath);
                    if (inspectionProfile != null) {
                        InspectionApplicationBase.this.reportMessage(1, "Loaded the '" + inspectionProfile.getName() + "' profile from the file '" + profilePath + "'");
                    }
                    return inspectionProfile;
                }
                catch (IOException e) {
                    throw new InspectionApplicationException("Failed to read inspection profile file '" + profilePath + "': " + e);
                }
                catch (JDOMException e) {
                    throw new InspectionApplicationException("Invalid xml structure of inspection profile file '" + profilePath + "': " + e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profilePath";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplicationBase$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadProfileByName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "loadProfileByPath";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private ConversionListener createConversionListener(final StringBuilder errorBuffer) {
        return new ConversionListener(){

            public void conversionNeeded() {
                InspectionApplicationBase.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            public void successfullyConverted(@NotNull Path backupDir) {
                if (backupDir == null) {
                    6.$$$reportNull$$$0(0);
                }
                InspectionApplicationBase.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.was.successfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.toString()}));
            }

            public void error(@NotNull String message) {
                if (message == null) {
                    6.$$$reportNull$$$0(1);
                }
                errorBuffer.append(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message})).append(System.lineSeparator());
            }

            public void cannotWriteToFiles(@NotNull List<? extends Path> readonlyFiles) {
                if (readonlyFiles == null) {
                    6.$$$reportNull$$$0(2);
                }
                StringBuilder files = new StringBuilder();
                for (Path path : readonlyFiles) {
                    files.append(path.toString()).append("; ");
                }
                errorBuffer.append(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files.toString()})).append(System.lineSeparator());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "backupDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readonlyFiles";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplicationBase$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "successfullyConverted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cannotWriteToFiles";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static String getPrefix(@NotNull String text2) {
        int idx;
        if (text2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(30);
        }
        if ((idx = text2.indexOf(" in ")) == -1) {
            idx = text2.indexOf(" of ");
        }
        String string2 = idx == -1 ? text2 : text2.substring(0, idx);
        if (string2 == null) {
            InspectionApplicationBase.$$$reportNull$$$0(31);
        }
        return string2;
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    protected void reportMessageNoLineBreak(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    public void reportError(@NotNull Throwable e) {
        if (e == null) {
            InspectionApplicationBase.$$$reportNull$$$0(32);
        }
        this.reportError(e.getMessage());
    }

    public void onFailure(@NotNull String message) {
        if (message == null) {
            InspectionApplicationBase.$$$reportNull$$$0(33);
        }
        this.reportError(message);
        this.gracefulExit();
    }

    public void reportError(String message) {
        System.err.println(message);
    }

    public void reportMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }

    private List<Range> getOrComputeUnchangedRanges(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplicationBase.$$$reportNull$$$0(34);
        }
        if (changeListManager == null) {
            InspectionApplicationBase.$$$reportNull$$$0(35);
        }
        return this.diffMap.computeIfAbsent(virtualFile.getPath(), key2 -> InspectionApplicationBase.computeDiff(virtualFile, changeListManager));
    }

    private static List<Range> computeDiff(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplicationBase.$$$reportNull$$$0(36);
        }
        if (changeListManager == null) {
            InspectionApplicationBase.$$$reportNull$$$0(37);
        }
        try {
            Change change = changeListManager.getChange(virtualFile);
            if (change == null) {
                return Collections.emptyList();
            }
            ContentRevision revision = change.getBeforeRevision();
            if (revision == null) {
                return Collections.emptyList();
            }
            String oldContent = revision.getContent();
            if (oldContent == null) {
                return Collections.emptyList();
            }
            String newContent = VfsUtilCore.loadText((VirtualFile)virtualFile);
            return ContainerUtil.newArrayList((Iterable)RangesBuilder.compareLines((CharSequence)newContent, (CharSequence)oldContent, (LineOffsets)LineOffsetsUtil.create((CharSequence)newContent), (LineOffsets)LineOffsetsUtil.create((CharSequence)oldContent)).iterateUnchanged());
        }
        catch (VcsException | IOException e) {
            LOG.error("Couldn't load content", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 24, 25, 26, 27, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionApplicationBase";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsDataPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplicationBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScopeFromChangedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalInspectionContext";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInspectionProfile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configuratorContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnalysisScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScopeFromChangedFiles";
                break;
            }
            case 8: 
            case 11: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAllStartupActivitiesPassed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runAnalysisOnScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "closeProject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadInspectionProfile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProfileManager";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionProfileLoader";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onFailure";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeUnchangedRanges";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "computeDiff";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 11, 24, 25, 26, 27, 31 -> new IllegalStateException(string2);
        };
    }

    private class InspectionProgressIndicator
    extends ProgressIndicatorBase
    implements ProgressIndicatorWithDelayedPresentation {
        private String lastPrefix = "";
        private int myLastPercent = -1;
        private int nestingLevel;

        private InspectionProgressIndicator() {
            this.setText("");
        }

        public void pushState() {
            super.pushState();
            ++this.nestingLevel;
        }

        public void popState() {
            super.popState();
            --this.nestingLevel;
        }

        public void setText(String text2) {
            if (Objects.equals(text2, this.getText())) {
                return;
            }
            super.setText(text2);
            if (text2 == null) {
                return;
            }
            switch (InspectionApplicationBase.this.myVerboseLevel) {
                case 0: {
                    break;
                }
                case 1: {
                    String prefix = InspectionApplicationBase.getPrefix(text2);
                    if (prefix.equals(this.lastPrefix)) {
                        InspectionApplicationBase.this.reportMessageNoLineBreak(1, ".");
                        break;
                    }
                    this.lastPrefix = prefix;
                    InspectionApplicationBase.this.reportMessage(1, "");
                    InspectionApplicationBase.this.reportMessage(1, prefix);
                    break;
                }
                case 2: {
                    InspectionApplicationBase.this.reportMessage(2, text2);
                    break;
                }
                case 3: {
                    int percent = (int)(this.getFraction() * 100.0);
                    if (this.isIndeterminate() || !(this.getFraction() > 0.0) || this.myLastPercent == percent || this.nestingLevel != 0) break;
                    this.myLastPercent = percent;
                    String msg = InspectionApplicationBase.getPrefix(text2) + " " + percent + "%";
                    InspectionApplicationBase.this.reportMessage(2, msg);
                }
            }
        }

        public void setDelayInMillis(int delayInMillis) {
        }
    }
}

