/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.internal.inspector.UiMouseAction;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.ToolbarComboWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ui.ComponentWithEmptyText;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001c\u0010\u000e\u001a\u00020\f*\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/inspector/CopyUiLabelAction;", "Lcom/intellij/internal/inspector/UiMouseAction;", "<init>", "()V", "handleClick", "", "component", "Ljava/awt/Component;", "event", "Ljava/awt/event/MouseEvent;", "getComponentContextText", "", "", "c", "join", "separator", "getComponentText", "findJComponentFor", "Ljavax/swing/JComponent;", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nCopyUiLabelAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyUiLabelAction.kt\ncom/intellij/internal/inspector/CopyUiLabelAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n774#2:191\n865#2,2:192\n1557#2:194\n1628#2,3:195\n*S KotlinDebug\n*F\n+ 1 CopyUiLabelAction.kt\ncom/intellij/internal/inspector/CopyUiLabelAction\n*L\n92#1:191\n92#1:192,2\n161#1:194\n161#1:195,3\n*E\n"})
public final class CopyUiLabelAction
extends UiMouseAction {
    public CopyUiLabelAction() {
        super("CopyUiLabel");
    }

    @Override
    protected void handleClick(@NotNull Component component, @Nullable MouseEvent event) {
        String string2;
        Object text2;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        MouseEvent mouseEvent = event;
        boolean showFullDescription = mouseEvent != null ? mouseEvent.isShiftDown() : false;
        if (showFullDescription) {
            text2 = new ArrayList();
            ((Collection)text2).add(this.getComponentText(component));
            for (Component parent = component; parent != null; parent = (Component)parent.getParent()) {
                CollectionsKt.addAll((Collection)((Collection)text2), (Iterable)this.getComponentContextText(parent));
            }
            string2 = this.join((List<String>)text2, "\n");
        } else {
            string2 = this.getComponentText(component);
        }
        String text3 = string2;
        text2 = text3;
        if (text2 == null || StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text3));
        JComponent anchor = this.findJComponentFor(component);
        if (anchor != null) {
            String message = "Copied: '" + StringUtil.shortenTextWithEllipsis((String)text3, (int)30, (int)0) + "'";
            HintManager.getInstance().showHint((JComponent)new JLabel(message), RelativePoint.getSouthWestOf((JComponent)anchor), 18, 0);
        }
    }

    private final List<String> getComponentContextText(Component c) {
        List text2 = new ArrayList();
        if (c instanceof ComponentWithEmptyText) {
            ((Collection)text2).add(((ComponentWithEmptyText)c).getEmptyText().toString());
        }
        if (c instanceof EditorComponentImpl) {
            ((Collection)text2).add(((Object)((EditorComponentImpl)c).getEditor().getPlaceholder()).toString());
        }
        if (c instanceof JComponent) {
            Border border;
            ((Collection)text2).add(((JComponent)c).getToolTipText());
            HelpTooltip helpTooltip = HelpTooltip.getTooltipFor((JComponent)((JComponent)c));
            if (helpTooltip != null) {
                Collection collection = text2;
                JPanel jPanel = helpTooltip.createTipPanel();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createTipPanel(...)");
                collection.add(this.getComponentText(jPanel));
            }
            if ((border = ((JComponent)c).getBorder()) instanceof TitledBorder) {
                ((Collection)text2).add(((TitledBorder)border).getTitle());
            }
        }
        return text2;
    }

    /*
     * WARNING - void declaration
     */
    private final String join(List<String> $this$join, String separator) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)$this$join);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getComponentText(Component c) {
        Object object;
        Component component = c;
        if (component instanceof JLabel) {
            object = ((JLabel)c).getText();
        } else if (component instanceof AbstractButton) {
            object = ((AbstractButton)c).getText();
        } else if (component instanceof SimpleColoredComponent) {
            object = ((SimpleColoredComponent)c).toString();
        } else if (component instanceof JTextComponent) {
            object = ((JTextComponent)c).getText();
        } else if (component instanceof TextPanel) {
            object = ((TextPanel)c).getText();
        } else if (component instanceof JComboBox) {
            Object item = ((JComboBox)c).getSelectedItem();
            if (item == null || item instanceof String) {
                String string2 = (String)item;
                object = string2 != null ? string2.toString() : null;
            } else {
                ListCellRenderer listCellRenderer = ((JComboBox)c).getRenderer();
                if (listCellRenderer == null) {
                    listCellRenderer = new DefaultListCellRenderer();
                }
                ListCellRenderer renderer = listCellRenderer;
                JList<Object> jList = new BasicComboPopup((JComboBox)c).getList();
                Component rendererComponent = renderer.getListCellRendererComponent(jList, item, -1, false, false);
                Intrinsics.checkNotNull((Object)rendererComponent);
                object = this.getComponentText(rendererComponent);
            }
        } else if (component instanceof JList) {
            List text2 = new ArrayList();
            ListModel model2 = ((JList)c).getModel();
            int rendererComponent = model2.getSize();
            for (int i = 0; i < rendererComponent; ++i) {
                Object item = model2.getElementAt(i);
                ListCellRenderer listCellRenderer = ((JList)c).getCellRenderer();
                if (listCellRenderer == null) {
                    listCellRenderer = new DefaultListCellRenderer();
                }
                ListCellRenderer renderer = listCellRenderer;
                Component rendererComponent2 = renderer.getListCellRendererComponent((JList)c, item, i, false, false);
                Collection collection = text2;
                Intrinsics.checkNotNull((Object)rendererComponent2);
                collection.add(this.getComponentText(rendererComponent2));
            }
            object = this.join(text2, "\n");
        } else if (component instanceof JTable) {
            List text3 = new ArrayList();
            for (int i : ((JTable)c).getSelectedRows()) {
                List rowText = new ArrayList();
                int n = ((JTable)c).getColumnCount();
                for (int j = 0; j < n; ++j) {
                    Object value = ((JTable)c).getValueAt(i, j);
                    TableCellRenderer tableCellRenderer = ((JTable)c).getCellRenderer(i, j);
                    if (tableCellRenderer == null) {
                        tableCellRenderer = new DefaultTableCellRenderer();
                    }
                    TableCellRenderer renderer = tableCellRenderer;
                    Component rendererComponent = renderer.getTableCellRendererComponent((JTable)c, value, false, false, i, j);
                    Collection collection = rowText;
                    Intrinsics.checkNotNull((Object)rendererComponent);
                    collection.add(this.getComponentText(rendererComponent));
                }
                ((Collection)text3).add(this.join(rowText, "\t"));
            }
            object = this.join(text3, "\n");
        } else if (component instanceof JTableHeader) {
            List text4 = new ArrayList();
            TableColumnModel columnModel = ((JTableHeader)c).getTable().getColumnModel();
            int rendererComponent = columnModel.getColumnCount();
            for (int i = 0; i < rendererComponent; ++i) {
                TableColumn column = columnModel.getColumn(i);
                TableCellRenderer tableCellRenderer = column.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = ((JTableHeader)c).getDefaultRenderer();
                }
                TableCellRenderer renderer = tableCellRenderer;
                Component rendererComponent3 = renderer.getTableCellRendererComponent(((JTableHeader)c).getTable(), column.getHeaderValue(), false, false, -1, i);
                Collection collection = text4;
                Intrinsics.checkNotNull((Object)rendererComponent3);
                collection.add(this.getComponentText(rendererComponent3));
            }
            object = this.join(text4, ", ");
        } else if (component instanceof JTree) {
            List text5 = new ArrayList();
            int[] nArray = ((JTree)c).getSelectionRows();
            if (nArray == null) {
                nArray = new int[]{};
            }
            for (int i : nArray) {
                DefaultMutableTreeNode node;
                TreePath treePath = ((JTree)c).getPathForRow(i);
                Object value = treePath.getLastPathComponent();
                if ((value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null) == null) continue;
                node = node;
                TreeCellRenderer treeCellRenderer = ((JTree)c).getCellRenderer();
                if (treeCellRenderer == null) {
                    treeCellRenderer = new DefaultTreeCellRenderer();
                }
                TreeCellRenderer renderer = treeCellRenderer;
                Component rendererComponent = renderer.getTreeCellRendererComponent((JTree)c, node, false, false, true, i, false);
                Collection collection = text5;
                String string3 = StringsKt.repeat((CharSequence)"\t", (int)treePath.getPathCount());
                Intrinsics.checkNotNull((Object)rendererComponent);
                collection.add(string3 + this.getComponentText(rendererComponent));
            }
            object = this.join(text5, "\n");
        } else if (component instanceof Breadcrumbs) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((Breadcrumbs)c).getCrumbs();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getCrumbs(...)");
            Iterable text5 = CollectionsKt.toList((Iterable)iterable);
            CopyUiLabelAction copyUiLabelAction = this;
            boolean $i$f$map = false;
            void i = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Crumb renderer = (Crumb)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            object = copyUiLabelAction.join((List)destination$iv$iv, ", ");
        } else if (component instanceof ToolbarComboWidget) {
            object = ((ToolbarComboWidget)c).getText();
        } else if (component instanceof Container) {
            List text6 = new ArrayList();
            int n = ((Container)c).getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child;
                if (((Container)c).getComponent(i) == null || !child.isVisible()) continue;
                ((Collection)text6).add(this.getComponentText(child));
            }
            object = this.join(text6, "\n");
        } else {
            AccessibleContext accessibleContext = c.getAccessibleContext();
            AccessibleText accessibleText = accessibleContext != null ? accessibleContext.getAccessibleText() : null;
            object = accessibleText;
            if (object == null || (object = object.getAtIndex(3, 0)) == null) {
                String string4 = c.toString();
                object = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            }
        }
        return object;
    }

    private final JComponent findJComponentFor(Component component) {
        for (Component parent = component; parent != null; parent = (Component)parent.getParent()) {
            if (!(parent instanceof JComponent)) continue;
            return (JComponent)parent;
        }
        return null;
    }
}

