/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final Comparator<? super Configuration> CONFIGURATION_COMPARATOR = Comparator.comparing(Configuration::getCategory, NaturalComparator.INSTANCE).thenComparing(Configuration::getName, NaturalComparator.INSTANCE);
    private static LanguageFileType ourDefaultFileType;
    private static boolean ourUseUniversalMatchingAlgorithm;
    private static Map<String, LanguageFileType> ourNames2FileTypes;
    private static final Map<String, StructuralSearchProfile> cache;
    private static List<Configuration> ourPredefinedConfigurations;

    private static void clearCaches() {
        ourPredefinedConfigurations = null;
        ourDefaultFileType = null;
        ourNames2FileTypes = null;
        cache.clear();
    }

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        ourUseUniversalMatchingAlgorithm = useUniversalMatchingAlgorithm;
        cache.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(@Nullable LanguageFileType fileType) {
        return fileType == null ? null : StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String id;
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(1);
        }
        if (cache.containsKey(id = language.getID())) {
            return cache.get(id);
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            cache.put(id, profile);
            return profile;
        }
        cache.put(id, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile != null && profile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return StructuralSearchUtil.isIdentifier(element) ? element.getParent() : element;
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile == null ? element : profile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        SmartList list2 = new SmartList();
        for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(profile instanceof StructuralSearchProfileBase)) continue;
            list2.add(profile);
        }
        list2.add(new XmlStructuralSearchProfile());
        return list2.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = XmlFileType.INSTANCE;
            }
        }
        LanguageFileType languageFileType = ourDefaultFileType;
        if (languageFileType == null) {
            StructuralSearchUtil.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    public static Collection<LanguageFileType> getSuitableFileTypes() {
        return Collections.unmodifiableCollection(StructuralSearchUtil.getNames2FileTypes().values());
    }

    @NotNull
    private static Map<String, LanguageFileType> getNames2FileTypes() {
        Map<String, LanguageFileType> names2FileTypes = ourNames2FileTypes;
        if (names2FileTypes != null) {
            Map<String, LanguageFileType> map = names2FileTypes;
            if (map == null) {
                StructuralSearchUtil.$$$reportNull$$$0(3);
            }
            return map;
        }
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Map<String, LanguageFileType> cache = Arrays.stream(fileTypes).filter(fileType -> fileType instanceof LanguageFileType).collect(Collectors.toMap(FileType::getName, fileType -> (LanguageFileType)fileType));
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType2 = language.getAssociatedFileType();
            if (fileType2 == null) continue;
            cache.put(fileType2.getName(), fileType2);
        }
        ourNames2FileTypes = cache;
        if (ourNames2FileTypes == null) {
            StructuralSearchUtil.$$$reportNull$$$0(4);
        }
        return ourNames2FileTypes;
    }

    public static LanguageFileType getSuitableFileTypeByName(String name) {
        return StructuralSearchUtil.getNames2FileTypes().get(name);
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result2 = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result2, profile.getPredefinedTemplates());
            }
            Collections.sort(result2, CONFIGURATION_COMPARATOR);
            ourPredefinedConfigurations = Collections.unmodifiableList(result2);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(@NotNull PsiElement match2) {
        StructuralSearchProfile profile;
        if (match2 == null) {
            StructuralSearchUtil.$$$reportNull$$$0(5);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(match2)) != null && profile.isDocCommentOwner(match2);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(@NotNull PsiElement matchedNode, @NotNull String previousText) {
        StructuralSearchProfile profile;
        if (matchedNode == null) {
            StructuralSearchUtil.$$$reportNull$$$0(6);
        }
        if (previousText == null) {
            StructuralSearchUtil.$$$reportNull$$$0(7);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode)) != null ? profile.getAlternativeText(matchedNode, previousText) : null;
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(8);
        }
        return StructuralSearchUtil.findPatternContextByID(id, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> patternContexts = profile.getPatternContexts();
        if (patternContexts.isEmpty()) {
            return null;
        }
        if (id == null) {
            return patternContexts.get(0);
        }
        return patternContexts.stream().filter(context -> context.getId().equals(id)).findFirst().orElse(patternContexts.get(0));
    }

    public static boolean compileForeignElement(@NotNull PsiElement element, GlobalCompilingVisitor myCompilingVisitor) {
        StructuralSearchProfile profile;
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(9);
        }
        if ((profile = StructuralSearchUtil.getProfileByPsiElement(element)) == null) {
            return false;
        }
        profile.compile(new PsiElement[]{element}, myCompilingVisitor);
        CompiledPattern pattern = myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler2 = pattern.getHandler(element);
        if (handler2 instanceof TopLevelMatchingHandler) {
            TopLevelMatchingHandler topLevelMatchingHandler = (TopLevelMatchingHandler)handler2;
            pattern.setHandler(element, topLevelMatchingHandler.getDelegate());
        }
        return true;
    }

    static {
        cache = new HashMap<String, StructuralSearchProfile>();
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> StructuralSearchUtil.clearCaches(), null);
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                StructuralSearchUtil.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/StructuralSearchUtil$1", "fileTypesChanged"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames2FileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compileForeignElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

