/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace;

import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceOptions
implements JDOMExternalizable {
    private final Map<String, ReplacementVariableDefinition> variableDefs;
    private String replacement;
    private boolean toShortenFQN;
    private boolean myToReformatAccordingToStyle;
    private boolean myToUseStaticImport;
    @NotNull
    private final MatchOptions matchOptions;
    @NonNls
    private static final String REFORMAT_ATTR_NAME = "reformatAccordingToStyle";
    @NonNls
    private static final String REPLACEMENT_ATTR_NAME = "replacement";
    @NonNls
    private static final String SHORTEN_FQN_ATTR_NAME = "shortenFQN";
    @NonNls
    private static final String USE_STATIC_IMPORT_ATTR_NAME = "useStaticImport";
    @NonNls
    private static final String VARIABLE_DEFINITION_TAG_NAME = "variableDefinition";

    public ReplaceOptions() {
        this(new MatchOptions());
    }

    public ReplaceOptions(@NotNull MatchOptions matchOptions) {
        if (matchOptions == null) {
            ReplaceOptions.$$$reportNull$$$0(0);
        }
        this.variableDefs = new LinkedHashMap<String, ReplacementVariableDefinition>();
        this.matchOptions = matchOptions;
        this.replacement = matchOptions.getSearchPattern();
        this.myToUseStaticImport = false;
    }

    private ReplaceOptions(@NotNull ReplaceOptions options) {
        if (options == null) {
            ReplaceOptions.$$$reportNull$$$0(1);
        }
        this.variableDefs = new LinkedHashMap<String, ReplacementVariableDefinition>(options.variableDefs.size());
        options.variableDefs.forEach((key2, value) -> this.variableDefs.put((String)key2, value.copy()));
        this.replacement = options.replacement;
        this.toShortenFQN = options.toShortenFQN;
        this.myToReformatAccordingToStyle = options.myToReformatAccordingToStyle;
        this.myToUseStaticImport = options.myToUseStaticImport;
        this.matchOptions = options.matchOptions.copy();
    }

    @NotNull
    public ReplaceOptions copy() {
        return new ReplaceOptions(this);
    }

    @NotNull
    @NlsSafe
    public String getReplacement() {
        String string2 = this.replacement;
        if (string2 == null) {
            ReplaceOptions.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void setReplacement(@NotNull String replacement) {
        if (replacement == null) {
            ReplaceOptions.$$$reportNull$$$0(3);
        }
        this.replacement = replacement;
    }

    public boolean isToShortenFQN() {
        return this.toShortenFQN;
    }

    public void setToShortenFQN(boolean shortedFQN) {
        this.toShortenFQN = shortedFQN;
    }

    public boolean isToReformatAccordingToStyle() {
        return this.myToReformatAccordingToStyle;
    }

    @NotNull
    public MatchOptions getMatchOptions() {
        MatchOptions matchOptions = this.matchOptions;
        if (matchOptions == null) {
            ReplaceOptions.$$$reportNull$$$0(4);
        }
        return matchOptions;
    }

    public void setToReformatAccordingToStyle(boolean reformatAccordingToStyle) {
        this.myToReformatAccordingToStyle = reformatAccordingToStyle;
    }

    public boolean isToUseStaticImport() {
        return this.myToUseStaticImport;
    }

    public void setToUseStaticImport(boolean useStaticImport) {
        this.myToUseStaticImport = useStaticImport;
    }

    @NotNull
    private Set<String> getUsedVariableNames() {
        LinkedHashSet linkedHashSet = TemplateImplUtil.parseVariableNames((CharSequence)this.replacement);
        if (linkedHashSet == null) {
            ReplaceOptions.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    public void removeUnusedVariables() {
        this.variableDefs.keySet().removeIf(key2 -> !this.getUsedVariableNames().contains(key2));
    }

    public void readExternal(Element element) {
        this.matchOptions.readExternal(element);
        Attribute attribute = element.getAttribute(REFORMAT_ATTR_NAME);
        try {
            this.myToReformatAccordingToStyle = attribute == null || attribute.getBooleanValue();
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        attribute = element.getAttribute(SHORTEN_FQN_ATTR_NAME);
        try {
            this.toShortenFQN = attribute == null || attribute.getBooleanValue();
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        attribute = element.getAttribute(USE_STATIC_IMPORT_ATTR_NAME);
        if (attribute != null) {
            try {
                this.myToUseStaticImport = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        this.replacement = element.getAttributeValue(REPLACEMENT_ATTR_NAME);
        for (Element child : element.getChildren(VARIABLE_DEFINITION_TAG_NAME)) {
            ReplacementVariableDefinition variableDefinition = new ReplacementVariableDefinition();
            variableDefinition.readExternal(child);
            this.addVariableDefinition(variableDefinition);
        }
    }

    public void writeExternal(Element element) {
        this.matchOptions.writeExternal(element);
        element.setAttribute(REFORMAT_ATTR_NAME, String.valueOf(this.myToReformatAccordingToStyle));
        element.setAttribute(SHORTEN_FQN_ATTR_NAME, String.valueOf(this.toShortenFQN));
        if (this.myToUseStaticImport) {
            element.setAttribute(USE_STATIC_IMPORT_ATTR_NAME, String.valueOf(true));
        }
        element.setAttribute(REPLACEMENT_ATTR_NAME, this.replacement);
        Set<String> nameSet = this.getUsedVariableNames();
        for (ReplacementVariableDefinition variableDefinition : this.variableDefs.values()) {
            if (!nameSet.contains(variableDefinition.getName())) continue;
            Element infoElement = new Element(VARIABLE_DEFINITION_TAG_NAME);
            element.addContent(infoElement);
            variableDefinition.writeExternal(infoElement);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplaceOptions)) {
            return false;
        }
        ReplaceOptions replaceOptions = (ReplaceOptions)o;
        if (this.myToReformatAccordingToStyle != replaceOptions.myToReformatAccordingToStyle) {
            return false;
        }
        if (this.toShortenFQN != replaceOptions.toShortenFQN) {
            return false;
        }
        if (this.myToUseStaticImport != replaceOptions.myToUseStaticImport) {
            return false;
        }
        if (!this.matchOptions.equals(replaceOptions.matchOptions)) {
            return false;
        }
        if (!Objects.equals(this.replacement, replaceOptions.replacement)) {
            return false;
        }
        return this.variableDefs.equals(replaceOptions.variableDefs);
    }

    public int hashCode() {
        int result2 = this.replacement.hashCode();
        result2 = 29 * result2 + (this.toShortenFQN ? 1 : 0);
        result2 = 29 * result2 + (this.myToReformatAccordingToStyle ? 1 : 0);
        result2 = 29 * result2 + (this.myToUseStaticImport ? 1 : 0);
        result2 = 29 * result2 + this.matchOptions.hashCode();
        result2 = 29 * result2 + this.variableDefs.hashCode();
        return result2;
    }

    public ReplacementVariableDefinition getVariableDefinition(@NotNull String name) {
        if (name == null) {
            ReplaceOptions.$$$reportNull$$$0(6);
        }
        return this.variableDefs != null ? this.variableDefs.get(name) : null;
    }

    public void addVariableDefinition(@NotNull ReplacementVariableDefinition definition) {
        if (definition == null) {
            ReplaceOptions.$$$reportNull$$$0(7);
        }
        this.variableDefs.put(definition.getName(), definition);
    }

    @NotNull
    public ReplacementVariableDefinition addNewVariableDefinition(@NotNull String name) {
        if (name == null) {
            ReplaceOptions.$$$reportNull$$$0(8);
        }
        ReplacementVariableDefinition definition = new ReplacementVariableDefinition(name);
        this.variableDefs.put(name, definition);
        ReplacementVariableDefinition replacementVariableDefinition = definition;
        if (replacementVariableDefinition == null) {
            ReplaceOptions.$$$reportNull$$$0(9);
        }
        return replacementVariableDefinition;
    }

    @NotNull
    public Collection<ReplacementVariableDefinition> getVariableDefinitions() {
        Collection<ReplacementVariableDefinition> collection = this.variableDefs.values();
        if (collection == null) {
            ReplaceOptions.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public void clearVariableDefinitions() {
        this.variableDefs.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/ReplaceOptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = REPLACEMENT_ATTR_NAME;
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/ReplaceOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVariableNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewVariableDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setReplacement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariableDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addVariableDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNewVariableDefinition";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 5, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

