/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

final class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    EscapeEntitiesAction() {
    }

    private static String escape(XmlFile file, Int2ObjectMap<String> map, String text2, int start2) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            String escape;
            char c = text2.charAt(i);
            PsiElement element = file.findElementAt(start2 + i);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)map.get((int)c)) != null) {
                result2.append("&").append(escape).append(";");
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    @NotNull
    private static Int2ObjectMap<String> computeMap(XmlFile xmlFile) {
        XmlFile file = XmlUtil.findXmlFile(xmlFile, Html5SchemaProvider.getCharsDtdLocation());
        assert (file != null);
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        XmlUtil.processXmlElements(file, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)arg_0 -> EscapeEntitiesAction.lambda$computeMap$0((Int2ObjectMap)result2, arg_0)), true);
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
        if (int2ObjectOpenHashMap == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(0);
        }
        return int2ObjectOpenHashMap;
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(3);
        }
        return file instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(4);
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(7);
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        XmlFile xmlFile = (XmlFile)file;
        Int2ObjectMap<String> map = EscapeEntitiesAction.computeMap(xmlFile);
        for (int i = starts.length - 1; i >= 0; --i) {
            String newText;
            int start2 = starts[i];
            int end = ends[i];
            String oldText = document.getText(new TextRange(start2, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape(xmlFile, map, oldText, start2))) continue;
            document.replaceString(start2, end, (CharSequence)newText);
        }
    }

    private static /* synthetic */ boolean lambda$computeMap$0(Int2ObjectMap result2, PsiElement element) {
        String value;
        int key2;
        if (element instanceof XmlEntityDecl && !result2.containsKey(key2 = Integer.parseInt((value = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value.length() - 1)))) {
            result2.put(key2, (Object)((XmlEntityDecl)element).getName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

