/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.common;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.util.Localizer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorReporter {
    private final Localizer localizer;
    private final ErrorHandler eh;
    private boolean hadError = false;

    public ErrorReporter(ErrorHandler errorHandler, Class clazz) {
        this.eh = errorHandler;
        this.localizer = new Localizer(clazz);
    }

    public void error(String string2, SourceLocation sourceLocation) {
        this.hadError = true;
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.error(ErrorReporter.makeParseException(this.localizer.message(string2), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void error(String string2, String string3, SourceLocation sourceLocation) {
        this.hadError = true;
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.error(ErrorReporter.makeParseException(this.localizer.message(string2, string3), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void error(String string2, String string3, String string4, SourceLocation sourceLocation) {
        this.hadError = true;
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.error(ErrorReporter.makeParseException(this.localizer.message(string2, string3, string4), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void warning(String string2, SourceLocation sourceLocation) {
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.warning(ErrorReporter.makeParseException(this.localizer.message(string2), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void warning(String string2, String string3, SourceLocation sourceLocation) {
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.warning(ErrorReporter.makeParseException(this.localizer.message(string2, string3), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void warning(String string2, String string3, String string4, SourceLocation sourceLocation) {
        if (this.eh == null) {
            return;
        }
        try {
            this.eh.warning(ErrorReporter.makeParseException(this.localizer.message(string2, string3, string4), sourceLocation));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public boolean getHadError() {
        return this.hadError;
    }

    private static SAXParseException makeParseException(String string2, SourceLocation sourceLocation) {
        if (sourceLocation == null) {
            return new SAXParseException(string2, null);
        }
        return new SAXParseException(string2, null, sourceLocation.getUri(), sourceLocation.getLineNumber(), sourceLocation.getColumnNumber());
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public static class WrappedSAXException
    extends RuntimeException {
        private final SAXException exception;

        private WrappedSAXException(SAXException sAXException) {
            this.exception = sAXException;
        }

        public SAXException getException() {
            return this.exception;
        }
    }
}

